/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.base;

import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.base.AutoValue_SourceFilePath;
import com.google.template.soy.base.SourceLogicalPath;
import com.google.template.soy.soytree.SoyFileP;

@Immutable
@AutoValue
public abstract class SourceFilePath
implements Comparable<SourceFilePath> {
    public static SourceFilePath create(String path, String realPath) {
        Preconditions.checkArgument((!path.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkArgument((!realPath.isEmpty() ? 1 : 0) != 0);
        return new AutoValue_SourceFilePath(path, realPath);
    }

    public static SourceFilePath create(SourceLogicalPath path) {
        return SourceFilePath.create(path.path(), path.path());
    }

    public static SourceFilePath create(SoyFileP fileP) {
        return SourceFilePath.create(fileP.getFilePath(), SourceFilePath.getRealPath(fileP));
    }

    public static String getRealPath(SoyFileP fileP) {
        String path = fileP.getFilePath();
        String root = fileP.getFileRoot();
        return root.isEmpty() ? path : root + "/" + path;
    }

    public static SourceFilePath forTest(String path) {
        return SourceFilePath.create(path, path);
    }

    SourceFilePath() {
    }

    public abstract String path();

    public abstract String realPath();

    public String getRoot() {
        int diff = this.realPath().length() - this.path().length();
        if (diff < 1 || !this.realPath().endsWith("/" + this.path())) {
            return "";
        }
        return this.realPath().substring(0, diff - 1);
    }

    @Memoized
    public SourceLogicalPath asLogicalPath() {
        return SourceLogicalPath.create(this.path());
    }

    public final String fileName() {
        String path = this.path();
        int lastSlashIndex = CharMatcher.anyOf((CharSequence)"/\\").lastIndexIn((CharSequence)path);
        if (lastSlashIndex != -1 && lastSlashIndex != path.length() - 1) {
            return path.substring(lastSlashIndex + 1);
        }
        return path;
    }

    @Override
    public int compareTo(SourceFilePath o) {
        return this.path().compareTo(o.path());
    }

    public final String toString() {
        return this.realPath();
    }
}

