/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.conformance;

import com.google.template.soy.basetree.ParentNode;
import com.google.template.soy.conformance.Rule;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.soytree.HtmlAttributeNode;
import com.google.template.soy.soytree.HtmlOpenTagNode;
import com.google.template.soy.soytree.SoyNode;

final class BanFragmentNavigation
extends Rule<HtmlAttributeNode> {
    BanFragmentNavigation(SoyErrorKind error) {
        super(error);
    }

    @Override
    protected void doCheckConformance(HtmlAttributeNode attributeNode, ErrorReporter errorReporter) {
        HtmlOpenTagNode openTagNode;
        String value;
        if (attributeNode.definitelyMatchesAttributeName("href") && attributeNode.getStaticContent() != null && (value = attributeNode.getStaticContent()).startsWith("#") && !value.equals("#") && ((openTagNode = BanFragmentNavigation.getOwningTag(attributeNode)) == null || !openTagNode.getTagName().isStatic() || openTagNode.getTagName().getStaticTagNameAsLowerCase().equals("a"))) {
            errorReporter.report(((SoyNode.StandaloneNode)attributeNode.getChild(0)).getSourceLocation(), this.error, new Object[0]);
        }
    }

    private static HtmlOpenTagNode getOwningTag(HtmlAttributeNode attributeNode) {
        ParentNode parent = attributeNode.getParent();
        while (true) {
            switch (parent.getKind()) {
                case TEMPLATE_BASIC_NODE: 
                case TEMPLATE_DELEGATE_NODE: 
                case TEMPLATE_ELEMENT_NODE: {
                    return null;
                }
                case HTML_OPEN_TAG_NODE: {
                    return (HtmlOpenTagNode)parent;
                }
            }
            parent = parent.getParent();
        }
    }
}

