/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.coredirectives;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.template.soy.data.Dir;
import com.google.template.soy.data.LogStatement;
import com.google.template.soy.data.LoggingAdvisingAppendable;
import com.google.template.soy.data.LoggingFunctionInvocation;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.UnsafeSanitizedContentOrdainer;
import com.google.template.soy.data.restricted.NullData;
import com.google.template.soy.shared.internal.AbstractStreamingHtmlEscaper;
import com.google.template.soy.shared.internal.EscapingConventions;
import java.io.IOException;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class CoreDirectivesRuntime {
    @Nonnull
    public static SanitizedContent escapeHtml(SoyValue value) {
        if (value == null) {
            value = NullData.INSTANCE;
        }
        Dir valueDir = null;
        if (value instanceof SanitizedContent) {
            SanitizedContent sanitizedContent = (SanitizedContent)value;
            if (sanitizedContent.getContentKind() == SanitizedContent.ContentKind.HTML) {
                return (SanitizedContent)value;
            }
            valueDir = sanitizedContent.getContentDirection();
        }
        return UnsafeSanitizedContentOrdainer.ordainAsSafe(EscapingConventions.EscapeHtml.INSTANCE.escape(value.coerceToString()), SanitizedContent.ContentKind.HTML, valueDir);
    }

    @Nonnull
    public static SanitizedContent escapeHtml(String value) {
        return UnsafeSanitizedContentOrdainer.ordainAsSafe(EscapingConventions.EscapeHtml.INSTANCE.escape(value), SanitizedContent.ContentKind.HTML);
    }

    @Nonnull
    public static LoggingAdvisingAppendable streamingEscapeHtml(LoggingAdvisingAppendable delegate) {
        return new StreamingHtmlEscaper(delegate);
    }

    private CoreDirectivesRuntime() {
    }

    private static final class StreamingHtmlEscaper
    extends AbstractStreamingHtmlEscaper {
        private StreamingHtmlEscaper(LoggingAdvisingAppendable delegate) {
            super(delegate, EscapingConventions.EscapeHtml.INSTANCE.escape(delegate));
        }

        @Override
        protected void notifyKindAndDirectionality(SanitizedContent.ContentKind kind, @Nullable Dir dir) throws IOException {
            if (this.isInHtml()) {
                this.activeAppendable = this.delegate;
            }
            this.delegate.setKindAndDirectionality(kind, dir);
        }

        @Override
        @CanIgnoreReturnValue
        public LoggingAdvisingAppendable appendLoggingFunctionInvocation(LoggingFunctionInvocation funCall, ImmutableList<Function<String, String>> escapers) throws IOException {
            if (this.isInHtml()) {
                this.delegate.appendLoggingFunctionInvocation(funCall, escapers);
            } else {
                this.activeAppendable.append(StreamingHtmlEscaper.escapePlaceholder(funCall.placeholderValue(), escapers));
            }
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public LoggingAdvisingAppendable enterLoggableElement(LogStatement statement) {
            if (this.isInHtml()) {
                this.delegate.enterLoggableElement(statement);
            }
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public LoggingAdvisingAppendable exitLoggableElement() {
            if (this.isInHtml()) {
                this.delegate.exitLoggableElement();
            }
            return this;
        }
    }
}

