/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.css;

import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.base.SourceFilePath;
import com.google.template.soy.base.SourceLogicalPath;
import com.google.template.soy.css.AutoValue_CssRegistry;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

@Immutable
@AutoValue
public abstract class CssRegistry {
    public static final CssRegistry EMPTY = CssRegistry.createForTest((ImmutableSet<String>)ImmutableSet.of(), (ImmutableMap<String, String>)ImmutableMap.of());

    public ImmutableSet<String> providedSymbols() {
        return this.symbolToPath().keySet();
    }

    abstract ImmutableMap<String, String> lfpmeToNamespace();

    abstract Optional<ImmutableSetMultimap<String, String>> symbolToClasses();

    abstract ImmutableMap<SourceLogicalPath, ImmutableMap<String, String>> filePathToShortClassMap();

    abstract ImmutableMap<SourceLogicalPath, SourceFilePath> logicalToRealMap();

    abstract ImmutableMap<String, SourceLogicalPath> symbolToPath();

    public abstract ImmutableMap<SourceLogicalPath, String> prefixes();

    public abstract boolean skipCssReferenceCheck();

    @Memoized
    ImmutableMap<String, String> symbolToLfpme() {
        return (ImmutableMap)this.lfpmeToNamespace().entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getValue, Map.Entry::getKey));
    }

    public String getLfpmeForSymbol(String symbol) {
        return (String)this.symbolToLfpme().get((Object)symbol);
    }

    public boolean isInRegistry(String symbol) {
        return this.providedSymbols().contains((Object)symbol);
    }

    public String getSymbolFromFilepath(String filePath) {
        return (String)this.lfpmeToNamespace().get((Object)filePath);
    }

    public ImmutableSet<String> allowedSymbolsToUse(String nsOrPath) {
        return this.symbolToClasses().get().get((Object)nsOrPath);
    }

    public boolean containsClassMap() {
        return this.symbolToClasses().isPresent();
    }

    public boolean containsLogicalPath(SourceLogicalPath logicalPath) {
        return this.filePathToShortClassMap().containsKey((Object)logicalPath);
    }

    public ImmutableSet<SourceLogicalPath> getAllLogicalPaths() {
        return this.filePathToShortClassMap().keySet();
    }

    public ImmutableMap<String, String> getShortClassNameMapForLogicalPath(SourceLogicalPath logicalPath) {
        return (ImmutableMap)this.filePathToShortClassMap().get((Object)logicalPath);
    }

    public static CssRegistry createWithFilePathToShortClassMap(ImmutableSet<String> providedSymbols, ImmutableMap<SourceLogicalPath, ImmutableMap<String, String>> filePathToShortClassMap) {
        return new AutoValue_CssRegistry((ImmutableMap<String, String>)ImmutableMap.of(), Optional.empty(), filePathToShortClassMap, (ImmutableMap<SourceLogicalPath, SourceFilePath>)ImmutableMap.of(), (ImmutableMap<String, SourceLogicalPath>)((ImmutableMap)providedSymbols.stream().collect(ImmutableMap.toImmutableMap(s -> s, s -> SourceLogicalPath.create("not-used")))), (ImmutableMap<SourceLogicalPath, String>)ImmutableMap.of(), false);
    }

    public static CssRegistry createForTest(ImmutableSet<String> providedSymbols) {
        return CssRegistry.createForTest(providedSymbols, (ImmutableMap<String, String>)ImmutableMap.of());
    }

    public static CssRegistry createForTest(ImmutableSet<String> providedSymbols, ImmutableMap<String, String> filePathToSymbol) {
        return new AutoValue_CssRegistry(filePathToSymbol, Optional.empty(), (ImmutableMap<SourceLogicalPath, ImmutableMap<String, String>>)ImmutableMap.of(), (ImmutableMap<SourceLogicalPath, SourceFilePath>)ImmutableMap.of(), (ImmutableMap<String, SourceLogicalPath>)((ImmutableMap)providedSymbols.stream().collect(ImmutableMap.toImmutableMap(s -> s, s -> SourceLogicalPath.create("not-used")))), (ImmutableMap<SourceLogicalPath, String>)ImmutableMap.of(), false);
    }

    @Nullable
    public SourceFilePath getFilePathForLogicalPath(SourceLogicalPath path) {
        return (SourceFilePath)this.logicalToRealMap().get((Object)path);
    }

    @Nullable
    public SourceLogicalPath getFilePathForSymbol(String s) {
        return (SourceLogicalPath)this.symbolToPath().get((Object)s);
    }
}

