/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.data;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.html.types.SafeHtmlProto;
import com.google.common.html.types.SafeScriptProto;
import com.google.common.html.types.SafeStyleProto;
import com.google.common.html.types.SafeStyleSheetProto;
import com.google.common.html.types.SafeUrlProto;
import com.google.common.html.types.TrustedResourceUrlProto;
import com.google.common.io.BaseEncoding;
import com.google.common.primitives.Ints;
import com.google.common.primitives.UnsignedInts;
import com.google.common.primitives.UnsignedLongs;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.Message;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SanitizedContents;
import com.google.template.soy.data.SoyList;
import com.google.template.soy.data.SoyMap;
import com.google.template.soy.data.SoyProtoValue;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.data.internal.ListImpl;
import com.google.template.soy.data.internal.SoyMapImpl;
import com.google.template.soy.data.restricted.BooleanData;
import com.google.template.soy.data.restricted.FloatData;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.internal.proto.FieldVisitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class ProtoFieldInterpreter {
    private static final FieldVisitor<ProtoFieldInterpreter> VISITOR = new Visitor(false);
    private static final FieldVisitor<ProtoFieldInterpreter> FORCE_STRING_VISITOR = new Visitor(true);
    public static final ProtoFieldInterpreter BYTES = new ProtoFieldInterpreter(){

        @Override
        public SoyValue soyFromProto(Object field) {
            return StringData.forValue(BaseEncoding.base64().encode(((ByteString)field).toByteArray()));
        }

        @Override
        public Object protoFromSoy(SoyValue field) {
            return ByteString.copyFrom((byte[])BaseEncoding.base64().decode((CharSequence)field.stringValue()));
        }
    };
    public static final ProtoFieldInterpreter BOOL = new ProtoFieldInterpreter(){

        @Override
        public SoyValue soyFromProto(Object field) {
            return BooleanData.forValue((Boolean)field);
        }

        @Override
        public Object protoFromSoy(SoyValue field) {
            return field.booleanValue();
        }
    };
    public static final ProtoFieldInterpreter INT = new ProtoFieldInterpreter(){

        @Override
        public SoyValue soyFromProto(Object field) {
            return IntegerData.forValue(((Number)field).longValue());
        }

        @Override
        public Object protoFromSoy(SoyValue field) {
            return Ints.saturatedCast((long)field.coerceToLong());
        }
    };
    public static final ProtoFieldInterpreter UNSIGNED_INT = new ProtoFieldInterpreter(){

        @Override
        public SoyValue soyFromProto(Object field) {
            return IntegerData.forValue(UnsignedInts.toLong((int)((Number)field).intValue()));
        }

        @Override
        public Object protoFromSoy(SoyValue field) {
            return UnsignedInts.saturatedCast((long)field.coerceToLong());
        }
    };
    public static final ProtoFieldInterpreter LONG_AS_INT = new ProtoFieldInterpreter(){

        @Override
        public SoyValue soyFromProto(Object field) {
            return IntegerData.forValue((Long)field);
        }

        @Override
        public Object protoFromSoy(SoyValue field) {
            return field.coerceToLong();
        }
    };
    public static final ProtoFieldInterpreter LONG_AS_STRING = new ProtoFieldInterpreter(){

        @Override
        public SoyValue soyFromProto(Object field) {
            return StringData.forValue(field.toString());
        }

        @Override
        public Object protoFromSoy(SoyValue field) {
            return Long.parseLong(field.stringValue());
        }
    };
    public static final ProtoFieldInterpreter UNSIGNEDLONG_AS_STRING = new ProtoFieldInterpreter(){

        @Override
        public SoyValue soyFromProto(Object field) {
            return StringData.forValue(UnsignedLongs.toString((long)((Long)field)));
        }

        @Override
        public Object protoFromSoy(SoyValue field) {
            return UnsignedLongs.parseUnsignedLong((String)field.stringValue());
        }
    };
    public static final ProtoFieldInterpreter FLOAT = new ProtoFieldInterpreter(){

        @Override
        public SoyValue soyFromProto(Object field) {
            return FloatData.forValue(((Float)field).floatValue());
        }

        @Override
        public Object protoFromSoy(SoyValue field) {
            return Float.valueOf((float)field.numberValue());
        }
    };
    public static final ProtoFieldInterpreter DOUBLE_AS_FLOAT = new ProtoFieldInterpreter(){

        @Override
        public SoyValue soyFromProto(Object field) {
            return FloatData.forValue((Double)field);
        }

        @Override
        public Object protoFromSoy(SoyValue field) {
            return field.numberValue();
        }
    };
    public static final ProtoFieldInterpreter STRING = new ProtoFieldInterpreter(){

        @Override
        public SoyValue soyFromProto(Object field) {
            return StringData.forValue(field.toString());
        }

        @Override
        public Object protoFromSoy(SoyValue field) {
            return field.stringValue();
        }
    };
    public static final ProtoFieldInterpreter SAFE_HTML_PROTO = new ProtoFieldInterpreter(){

        @Override
        public SoyValue soyFromProto(Object field) {
            return SanitizedContents.fromSafeHtmlProto((SafeHtmlProto)field);
        }

        @Override
        public Object protoFromSoy(SoyValue field) {
            return ((SanitizedContent)field).toSafeHtmlProto();
        }
    };
    public static final ProtoFieldInterpreter SAFE_SCRIPT_PROTO = new ProtoFieldInterpreter(){

        @Override
        public SoyValue soyFromProto(Object field) {
            return SanitizedContents.fromSafeScriptProto((SafeScriptProto)field);
        }

        @Override
        public Object protoFromSoy(SoyValue field) {
            return ((SanitizedContent)field).toSafeScriptProto();
        }
    };
    public static final ProtoFieldInterpreter SAFE_STYLE_PROTO = new ProtoFieldInterpreter(){

        @Override
        public SoyValue soyFromProto(Object field) {
            return SanitizedContents.fromSafeStyleProto((SafeStyleProto)field);
        }

        @Override
        public Object protoFromSoy(SoyValue field) {
            return ((SanitizedContent)field).toSafeStyleProto();
        }
    };
    public static final ProtoFieldInterpreter SAFE_STYLE_SHEET_PROTO = new ProtoFieldInterpreter(){

        @Override
        public SoyValue soyFromProto(Object field) {
            return SanitizedContents.fromSafeStyleSheetProto((SafeStyleSheetProto)field);
        }

        @Override
        public Object protoFromSoy(SoyValue field) {
            return ((SanitizedContent)field).toSafeStyleSheetProto();
        }
    };
    public static final ProtoFieldInterpreter SAFE_URL_PROTO = new ProtoFieldInterpreter(){

        @Override
        public SoyValue soyFromProto(Object field) {
            return SanitizedContents.fromSafeUrlProto((SafeUrlProto)field);
        }

        @Override
        public Object protoFromSoy(SoyValue field) {
            return ((SanitizedContent)field).toSafeUrlProto();
        }
    };
    public static final ProtoFieldInterpreter TRUSTED_RESOURCE_URI_PROTO = new ProtoFieldInterpreter(){

        @Override
        public SoyValue soyFromProto(Object field) {
            return SanitizedContents.fromTrustedResourceUrlProto((TrustedResourceUrlProto)field);
        }

        @Override
        public Object protoFromSoy(SoyValue field) {
            return ((SanitizedContent)field).toTrustedResourceUrlProto();
        }
    };
    public static final ProtoFieldInterpreter ENUM_FROM_PROTO = new ProtoFieldInterpreter(){

        @Override
        public SoyValue soyFromProto(Object field) {
            int value = field instanceof ProtocolMessageEnum ? ((ProtocolMessageEnum)field).getNumber() : ((Descriptors.EnumValueDescriptor)field).getNumber();
            return IntegerData.forValue(value);
        }

        @Override
        public Object protoFromSoy(SoyValue field) {
            throw new UnsupportedOperationException("can't convert enum to proto");
        }
    };
    public static final ProtoFieldInterpreter PROTO_MESSAGE = new ProtoFieldInterpreter(){

        @Override
        public SoyValue soyFromProto(Object field) {
            return SoyProtoValue.create((Message)field);
        }

        @Override
        public Object protoFromSoy(SoyValue field) {
            return ((SoyProtoValue)field).getProto();
        }
    };

    static ProtoFieldInterpreter create(Descriptors.FieldDescriptor fieldDescriptor, boolean forceStringConversion) {
        return FieldVisitor.visitField(fieldDescriptor, forceStringConversion ? FORCE_STRING_VISITOR : VISITOR);
    }

    private static ProtoFieldInterpreter getListType(final ProtoFieldInterpreter local) {
        return new ProtoFieldInterpreter(){

            @Override
            public SoyValue soyFromProto(Object field) {
                List entries = (List)field;
                ImmutableList.Builder builder = ImmutableList.builder();
                for (Object item : entries) {
                    builder.add((Object)local.soyFromProto(item));
                }
                return ListImpl.forProviderList((ImmutableList<? extends SoyValueProvider>)builder.build());
            }

            @Override
            public Object protoFromSoy(SoyValue field) {
                SoyList list = (SoyList)field;
                ArrayList<Object> uninterpretedValues = new ArrayList<Object>();
                for (SoyValue soyValue : list.asResolvedJavaList()) {
                    uninterpretedValues.add(local.protoFromSoy(soyValue));
                }
                return uninterpretedValues;
            }
        };
    }

    private static ProtoFieldInterpreter getMapType(final Descriptors.FieldDescriptor mapField, final ProtoFieldInterpreter keyField, final ProtoFieldInterpreter valueField) {
        final Descriptors.Descriptor messageDescriptor = mapField.getMessageType();
        final Descriptors.FieldDescriptor keyDescriptor = (Descriptors.FieldDescriptor)messageDescriptor.getFields().get(0);
        final Descriptors.FieldDescriptor valueDescriptor = (Descriptors.FieldDescriptor)messageDescriptor.getFields().get(1);
        return new ProtoFieldInterpreter(){

            @Override
            public SoyValue soyFromProto(Object field) {
                List entries = (List)field;
                HashMap map = Maps.newHashMapWithExpectedSize((int)entries.size());
                for (Message message : entries) {
                    SoyValue key = keyField.soyFromProto(message.getField(keyDescriptor)).resolve();
                    map.put(key, valueField.soyFromProto(message.getField(valueDescriptor)));
                }
                return SoyMapImpl.forProviderMap(map);
            }

            @Override
            public Object protoFromSoy(SoyValue field) {
                SoyMap map = (SoyMap)field;
                ImmutableList.Builder mapEntries = ImmutableList.builder();
                DynamicMessage.Builder defaultInstance = DynamicMessage.newBuilder((Descriptors.Descriptor)messageDescriptor.getContainingType());
                for (Map.Entry<? extends SoyValue, ? extends SoyValueProvider> entry : map.asJavaMap().entrySet()) {
                    Message.Builder entryBuilder = defaultInstance.newBuilderForField(mapField);
                    entryBuilder.setField(keyDescriptor, keyField.protoFromSoy(entry.getKey()));
                    entryBuilder.setField(valueDescriptor, valueField.protoFromSoy(entry.getValue().resolve()));
                    mapEntries.add((Object)entryBuilder.build());
                }
                return mapEntries.build();
            }
        };
    }

    private static ProtoFieldInterpreter enumTypeField(final Descriptors.EnumDescriptor enumDescriptor) {
        return new ProtoFieldInterpreter(){

            @Override
            public SoyValue soyFromProto(Object field) {
                return ENUM_FROM_PROTO.soyFromProto(field);
            }

            @Override
            public Object protoFromSoy(SoyValue field) {
                int value = field.integerValue();
                if (enumDescriptor.getFile().getSyntax() == Descriptors.FileDescriptor.Syntax.PROTO3) {
                    return enumDescriptor.findValueByNumberCreatingIfUnknown(value);
                }
                return enumDescriptor.findValueByNumber(value);
            }
        };
    }

    private ProtoFieldInterpreter() {
    }

    public abstract SoyValue soyFromProto(Object var1);

    public abstract Object protoFromSoy(SoyValue var1);

    private static final class Visitor
    extends FieldVisitor<ProtoFieldInterpreter> {
        private final boolean forceStringConversion;

        Visitor(boolean forceStringConversion) {
            this.forceStringConversion = forceStringConversion;
        }

        @Override
        protected ProtoFieldInterpreter visitLongAsInt() {
            return this.forceStringConversion ? LONG_AS_STRING : LONG_AS_INT;
        }

        @Override
        protected ProtoFieldInterpreter visitUnsignedInt() {
            return this.forceStringConversion ? UNSIGNEDLONG_AS_STRING : UNSIGNED_INT;
        }

        @Override
        protected ProtoFieldInterpreter visitUnsignedLongAsString() {
            return UNSIGNEDLONG_AS_STRING;
        }

        @Override
        protected ProtoFieldInterpreter visitLongAsString() {
            return LONG_AS_STRING;
        }

        @Override
        protected ProtoFieldInterpreter visitBool() {
            return BOOL;
        }

        @Override
        protected ProtoFieldInterpreter visitBytes() {
            return BYTES;
        }

        @Override
        protected ProtoFieldInterpreter visitString() {
            return STRING;
        }

        @Override
        protected ProtoFieldInterpreter visitDoubleAsFloat() {
            return DOUBLE_AS_FLOAT;
        }

        @Override
        protected ProtoFieldInterpreter visitFloat() {
            return FLOAT;
        }

        @Override
        protected ProtoFieldInterpreter visitInt() {
            return INT;
        }

        @Override
        protected ProtoFieldInterpreter visitSafeHtml() {
            return SAFE_HTML_PROTO;
        }

        @Override
        protected ProtoFieldInterpreter visitSafeScript() {
            return SAFE_SCRIPT_PROTO;
        }

        @Override
        protected ProtoFieldInterpreter visitSafeStyle() {
            return SAFE_STYLE_PROTO;
        }

        @Override
        protected ProtoFieldInterpreter visitSafeStyleSheet() {
            return SAFE_STYLE_SHEET_PROTO;
        }

        @Override
        protected ProtoFieldInterpreter visitSafeUrl() {
            return SAFE_URL_PROTO;
        }

        @Override
        protected ProtoFieldInterpreter visitTrustedResourceUrl() {
            return TRUSTED_RESOURCE_URI_PROTO;
        }

        @Override
        protected ProtoFieldInterpreter visitMessage(Descriptors.Descriptor messageType) {
            return PROTO_MESSAGE;
        }

        @Override
        protected ProtoFieldInterpreter visitEnum(Descriptors.EnumDescriptor enumType, Descriptors.FieldDescriptor fieldType) {
            return ProtoFieldInterpreter.enumTypeField(enumType);
        }

        @Override
        protected ProtoFieldInterpreter visitMap(Descriptors.FieldDescriptor mapField, ProtoFieldInterpreter keyValue, ProtoFieldInterpreter valueValue) {
            return ProtoFieldInterpreter.getMapType(mapField, keyValue, valueValue);
        }

        @Override
        protected ProtoFieldInterpreter visitRepeated(ProtoFieldInterpreter value) {
            return ProtoFieldInterpreter.getListType(value);
        }
    }
}

