/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.data;

import com.google.common.base.Preconditions;
import com.google.template.soy.data.SoyAbstractCachingValueProvider;
import com.google.template.soy.data.SoyFutureException;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.jbcsrc.api.RenderResult;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Function;
import javax.annotation.Nonnull;

public final class SoyFutureValueProvider
extends SoyAbstractCachingValueProvider {
    public static final ThreadLocal<FutureBlockCallback> futureBlockCallback = ThreadLocal.withInitial(() -> () -> {});
    private final Future<?> future;
    private final Function<Object, SoyValueProvider> converter;

    public SoyFutureValueProvider(Future<?> future, Function<Object, SoyValueProvider> converter) {
        this.future = (Future)Preconditions.checkNotNull(future);
        this.converter = (Function)Preconditions.checkNotNull(converter);
    }

    @Override
    public RenderResult status() {
        return this.future.isDone() ? RenderResult.done() : RenderResult.continueAfter(this.future);
    }

    @Override
    @Nonnull
    protected SoyValue compute() {
        try {
            if (!this.future.isDone()) {
                futureBlockCallback.get().beforeBlock();
            }
            return this.converter.apply(this.future.get()).resolve();
        }
        catch (ExecutionException e) {
            throw new SoyFutureException(e.getCause());
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new SoyFutureException(ie);
        }
        catch (Throwable e) {
            throw new SoyFutureException(e);
        }
    }

    public static interface FutureBlockCallback {
        public void beforeBlock();
    }
}

