/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.data;

import com.google.protobuf.Message;
import com.google.template.soy.data.LoggingAdvisingAppendable;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SoyDataException;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.data.restricted.NullData;
import com.google.template.soy.data.restricted.UndefinedData;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public interface SoyValue
extends SoyValueProvider {
    public static boolean isNullish(@Nullable SoyValue value) {
        return value == null || value.isNullish();
    }

    default public boolean isNullish() {
        return this.isNull() || this.isUndefined();
    }

    public boolean equals(Object var1);

    public boolean coerceToBoolean();

    public String coerceToString();

    public long coerceToLong();

    default public boolean isTruthyNonEmpty() {
        return this.coerceToBoolean();
    }

    default public boolean hasContent() {
        return this.coerceToBoolean();
    }

    public void render(LoggingAdvisingAppendable var1) throws IOException;

    public void render(Appendable var1) throws IOException;

    public boolean booleanValue();

    public int integerValue();

    public long longValue();

    public double floatValue();

    public double numberValue();

    @Nonnull
    public String stringValue();

    @Nullable
    default public String stringValueOrNull() {
        return this.isNullish() ? null : this.stringValue();
    }

    default public boolean isNull() {
        return this == NullData.INSTANCE;
    }

    default public boolean isUndefined() {
        return this == UndefinedData.INSTANCE;
    }

    default public SoyValue nullishToNull() {
        return this == UndefinedData.INSTANCE ? NullData.INSTANCE : this;
    }

    default public SoyValue nullishToUndefined() {
        return this == NullData.INSTANCE ? UndefinedData.INSTANCE : this;
    }

    @Nonnull
    default public Message getProto() {
        throw new SoyDataException("Expecting proto value but instead encountered type " + this.getClass().getSimpleName());
    }

    @Nullable
    default public Message getProtoOrNull() {
        return this.isNullish() ? null : this.getProto();
    }

    @Nonnull
    default public List<? extends SoyValueProvider> asJavaList() {
        throw new SoyDataException("Expecting list value but instead encountered type " + this.getClass().getSimpleName());
    }

    @Nullable
    default public List<? extends SoyValueProvider> asJavaListOrNull() {
        return this.isNullish() ? null : this.asJavaList();
    }

    @Nonnull
    default public Map<? extends SoyValue, ? extends SoyValueProvider> asJavaMap() {
        throw new SoyDataException("Expecting map value but instead encountered type " + this.getClass().getSimpleName());
    }

    default public SoyValue checkNullishType(Class<? extends SoyValue> type) {
        return type.cast(this);
    }

    default public SoyValue checkNullishInt() {
        throw new ClassCastException(this.getClass().getSimpleName() + " cannot be cast to IntegerData");
    }

    default public SoyValue checkNullishFloat() {
        throw new ClassCastException(this.getClass().getSimpleName() + " cannot be cast to FloatData");
    }

    default public SoyValue checkNullishNumber() {
        throw new ClassCastException(this.getClass().getSimpleName() + " cannot be cast to NumberData");
    }

    default public SoyValue checkNullishBoolean() {
        throw new ClassCastException(this.getClass().getSimpleName() + " cannot be cast to BooleanData");
    }

    default public SoyValue checkNullishString() {
        throw new ClassCastException(this.getClass().getSimpleName() + " cannot be cast to StringData");
    }

    default public SoyValue checkNullishSanitizedContent(SanitizedContent.ContentKind contentKind) {
        throw new ClassCastException(this.getClass().getSimpleName() + " cannot be cast to " + String.valueOf((Object)contentKind));
    }

    default public SoyValue checkNullishProto(Class<? extends Message> messageType) {
        throw new ClassCastException(this.getClass().getSimpleName() + " cannot be cast to " + messageType.getName());
    }
}

