/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.data.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.template.soy.data.ProtoFieldInterpreter;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.internal.AbstractSoyMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public final class LazyProtoToSoyValueMap<K, V>
extends AbstractSoyMap {
    private final Map<K, V> rawMap;
    private final Map<SoyValue, SoyValue> wrappedValues;
    private final ProtoFieldInterpreter keyFieldInterpreter;
    private final ProtoFieldInterpreter valueFieldInterpreter;
    private boolean fullyResolved;

    @Nonnull
    public static <K, V> LazyProtoToSoyValueMap<K, V> forMap(Map<K, V> map, ProtoFieldInterpreter keyFieldInterpreter, ProtoFieldInterpreter valueFieldInterpreter) {
        return new LazyProtoToSoyValueMap<K, V>(map, keyFieldInterpreter, valueFieldInterpreter);
    }

    private LazyProtoToSoyValueMap(Map<K, V> map, ProtoFieldInterpreter keyFieldInterpreter, ProtoFieldInterpreter valueFieldInterpreter) {
        this.rawMap = (Map)Preconditions.checkNotNull(map);
        this.wrappedValues = Maps.newLinkedHashMapWithExpectedSize((int)this.rawMap.size());
        this.keyFieldInterpreter = keyFieldInterpreter;
        this.valueFieldInterpreter = valueFieldInterpreter;
    }

    @Override
    public int size() {
        return this.rawMap.size();
    }

    @Nonnull
    public Set<SoyValue> keys() {
        return this.asJavaMap().keySet();
    }

    @Override
    public boolean containsKey(SoyValue key) {
        if (this.wrappedValues.containsKey(key)) {
            return true;
        }
        V value = this.rawMap.get(this.soyValueToKey(key));
        if (value == null) {
            return false;
        }
        this.wrappedValues.put(key, this.valueFieldInterpreter.soyFromProto(value));
        return true;
    }

    @Override
    public SoyValue get(SoyValue key) {
        return this.wrappedValues.computeIfAbsent(key, k -> {
            V value = this.rawMap.get(this.soyValueToKey((SoyValue)k));
            if (value == null) {
                return null;
            }
            return this.valueFieldInterpreter.soyFromProto(value);
        });
    }

    @Override
    public SoyValue getProvider(SoyValue key) {
        return this.get(key);
    }

    @Nonnull
    public Map<SoyValue, SoyValue> asJavaMap() {
        if (!this.fullyResolved) {
            for (K key : this.rawMap.keySet()) {
                SoyValue soyValue = this.get(this.keyFieldInterpreter.soyFromProto(key));
            }
            this.fullyResolved = true;
        }
        return this.wrappedValues;
    }

    private Object soyValueToKey(SoyValue soyValue) {
        if (soyValue.isNullish()) {
            return null;
        }
        return this.keyFieldInterpreter.protoFromSoy(soyValue);
    }
}

