/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.data.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.data.internal.AbstractSoyMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class SoyMapImpl
extends AbstractSoyMap {
    public static final SoyMapImpl EMPTY = new SoyMapImpl((Map<? extends SoyValue, ? extends SoyValueProvider>)ImmutableMap.of());
    private final Map<? extends SoyValue, ? extends SoyValueProvider> providerMap;

    @Nonnull
    public static SoyMapImpl forProviderMap(Map<? extends SoyValue, ? extends SoyValueProvider> providerMap) {
        return new SoyMapImpl(providerMap);
    }

    @Nonnull
    public static SoyMapImpl forProviderMapNoNullKeys(Map<? extends SoyValue, ? extends SoyValueProvider> providerMap) {
        for (SoyValue soyValue : providerMap.keySet()) {
            if (soyValue != null && !soyValue.isNullish()) continue;
            throw new IllegalArgumentException(String.format("null key in entry: null=%s", providerMap.get(soyValue)));
        }
        return new SoyMapImpl(providerMap);
    }

    private SoyMapImpl(Map<? extends SoyValue, ? extends SoyValueProvider> providerMap) {
        Preconditions.checkNotNull(providerMap);
        if (providerMap.containsKey(null)) {
            throw new AssertionError();
        }
        this.providerMap = providerMap;
    }

    @Override
    public int size() {
        return this.providerMap.size();
    }

    @Override
    @Nonnull
    public Iterable<? extends SoyValue> keys() {
        return this.providerMap.keySet();
    }

    @Override
    public boolean containsKey(SoyValue key) {
        return this.providerMap.containsKey(key);
    }

    @Override
    public SoyValue get(SoyValue key) {
        SoyValueProvider provider = this.getProvider(key);
        return provider != null ? provider.resolve() : null;
    }

    @Override
    public SoyValueProvider getProvider(SoyValue key) {
        return this.providerMap.get(key);
    }

    @Override
    @Nonnull
    public Map<? extends SoyValue, ? extends SoyValueProvider> asJavaMap() {
        return this.providerMap;
    }
}

