/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.error;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.SoyFileSupplier;
import com.google.template.soy.error.AutoValue_SourceSnippetPrinter_SourceLine;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Optional;
import java.util.stream.Collectors;

public final class SourceSnippetPrinter {
    public static final Printable ELLIPSIS = new Printable(){

        @Override
        public String print(SourceLocation location) {
            return Strings.repeat((String)" ", (int)(this.lineNumberPadding(location) + 2)) + "[...]\n";
        }
    };
    private final int maxLines;

    public SourceSnippetPrinter() {
        this.maxLines = Integer.MAX_VALUE;
    }

    public SourceSnippetPrinter(int maxLines) {
        Preconditions.checkArgument((maxLines > 1 ? 1 : 0) != 0, (Object)"maxLines must be at least 2");
        this.maxLines = maxLines;
    }

    public Optional<String> getSnippet(SoyFileSupplier soyFileSupplier, SourceLocation location) {
        if (!location.isKnown()) {
            return Optional.empty();
        }
        ImmutableList snippetLines = SourceSnippetPrinter.getSourceLines(soyFileSupplier, location);
        if (snippetLines.isEmpty()) {
            return Optional.empty();
        }
        int locationLines = snippetLines.size();
        if (locationLines > this.maxLines) {
            int linesAtTop = (this.maxLines + 1) / 2;
            int linesAtBottom = this.maxLines - linesAtTop;
            snippetLines = ImmutableList.builder().addAll((Iterable)snippetLines.subList(0, linesAtTop)).add((Object)ELLIPSIS).addAll((Iterable)snippetLines.subList(locationLines - linesAtBottom, locationLines)).build();
        }
        return Optional.of(snippetLines.stream().map(line -> line.print(location)).collect(Collectors.joining("")));
    }

    private static ImmutableList<Printable> getSourceLines(SoyFileSupplier supplier, SourceLocation location) {
        ImmutableList immutableList;
        ImmutableList.Builder lines = ImmutableList.builder();
        BufferedReader reader = new BufferedReader(supplier.open());
        try {
            String line;
            for (int lineNum = 1; lineNum <= location.getEndLine() && (line = reader.readLine()) != null; ++lineNum) {
                if (lineNum < location.getBeginLine()) continue;
                lines.add((Object)SourceLine.create(lineNum, line));
            }
            immutableList = lines.build();
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ioe) {
                return ImmutableList.of();
            }
        }
        reader.close();
        return immutableList;
    }

    @AutoValue
    static abstract class SourceLine
    implements Printable {
        SourceLine() {
        }

        static SourceLine create(int lineNumber, String line) {
            return new AutoValue_SourceSnippetPrinter_SourceLine(lineNumber, line);
        }

        abstract int getLineNumber();

        abstract String getLine();

        @Override
        public String print(SourceLocation location) {
            String lineTemplate = "%" + this.lineNumberPadding(location) + "d: %s";
            String codeLine = String.format(lineTemplate, this.getLineNumber(), this.getLine());
            return codeLine + "\n" + this.getHighlightLine(location) + "\n";
        }

        private String getHighlightLine(SourceLocation location) {
            if (this.getLineNumber() < location.getBeginLine() || this.getLineNumber() > location.getEndLine()) {
                return "";
            }
            int highlightFrom = this.getLineNumber() == location.getBeginLine() ? location.getBeginColumn() - 1 : 0;
            String initialWhitespace = Strings.repeat((String)" ", (int)(this.lineNumberPadding(location) + ": ".length() + highlightFrom));
            boolean isSingleCharacter = location.getBeginPoint().equals(location.getEndPoint());
            if (isSingleCharacter) {
                return initialWhitespace + "^";
            }
            int highlightTo = this.getLineNumber() == location.getEndLine() ? location.getEndColumn() : this.getLine().length() + 1;
            int highlightLength = highlightTo - highlightFrom;
            return initialWhitespace + Strings.repeat((String)"~", (int)highlightLength);
        }
    }

    private static interface Printable {
        public String print(SourceLocation var1);

        default public int lineNumberPadding(SourceLocation location) {
            return String.valueOf(location.getEndLine()).length();
        }
    }
}

