/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.error;

import com.google.auto.value.AutoValue;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.error.AutoValue_SoyError;
import com.google.template.soy.error.SoyErrorKind;
import java.util.Comparator;
import java.util.Optional;

@AutoValue
public abstract class SoyError
implements Comparable<SoyError> {
    static SoyError create(SourceLocation location, SoyErrorKind kind, String message, Optional<String> snippet, boolean isWarning) {
        return new AutoValue_SoyError(location, kind, message, snippet, isWarning);
    }

    SoyError() {
    }

    public abstract SourceLocation location();

    public abstract SoyErrorKind errorKind();

    public abstract String message();

    abstract Optional<String> snippet();

    public abstract boolean isWarning();

    public final String toString() {
        return this.toStringInternal(true);
    }

    public String toStringWithoutSnippet() {
        return this.toStringInternal(false);
    }

    private String toStringInternal(boolean snippet) {
        return this.location().getFilePath().realPath() + ":" + this.location().getBeginLine() + ": " + (this.isWarning() ? "warning" : "error") + ": " + this.message() + (String)(snippet ? "\n" + this.snippet().orElse("") : "");
    }

    @Override
    public int compareTo(SoyError o) {
        return Comparator.comparing(SoyError::location).thenComparing(SoyError::message).compare(this, o);
    }
}

