/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.exprtree;

import com.google.template.soy.basetree.AbstractNodeVisitor;
import com.google.template.soy.exprtree.BooleanNode;
import com.google.template.soy.exprtree.DataAccessNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.FieldAccessNode;
import com.google.template.soy.exprtree.FloatNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.exprtree.GroupNode;
import com.google.template.soy.exprtree.IntegerNode;
import com.google.template.soy.exprtree.ItemAccessNode;
import com.google.template.soy.exprtree.ListComprehensionNode;
import com.google.template.soy.exprtree.ListLiteralNode;
import com.google.template.soy.exprtree.MapLiteralFromListNode;
import com.google.template.soy.exprtree.MapLiteralNode;
import com.google.template.soy.exprtree.MethodCallNode;
import com.google.template.soy.exprtree.NullNode;
import com.google.template.soy.exprtree.NullSafeAccessNode;
import com.google.template.soy.exprtree.OperatorNodes;
import com.google.template.soy.exprtree.ProtoEnumValueNode;
import com.google.template.soy.exprtree.RecordLiteralNode;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.exprtree.TemplateLiteralNode;
import com.google.template.soy.exprtree.UndefinedNode;
import com.google.template.soy.exprtree.VarRefNode;

public abstract class AbstractExprNodeVisitor<R>
extends AbstractNodeVisitor<ExprNode, R> {
    @Override
    protected final void visit(ExprNode node) {
        switch (node.getKind()) {
            case EXPR_ROOT_NODE: {
                this.visitExprRootNode((ExprRootNode)node);
                break;
            }
            case NULL_NODE: {
                this.visitNullNode((NullNode)node);
                break;
            }
            case UNDEFINED_NODE: {
                this.visitUndefinedNode((UndefinedNode)node);
                break;
            }
            case BOOLEAN_NODE: {
                this.visitBooleanNode((BooleanNode)node);
                break;
            }
            case INTEGER_NODE: {
                this.visitIntegerNode((IntegerNode)node);
                break;
            }
            case FLOAT_NODE: {
                this.visitFloatNode((FloatNode)node);
                break;
            }
            case STRING_NODE: {
                this.visitStringNode((StringNode)node);
                break;
            }
            case PROTO_ENUM_VALUE_NODE: {
                this.visitProtoEnumValueNode((ProtoEnumValueNode)node);
                break;
            }
            case LIST_LITERAL_NODE: {
                this.visitListLiteralNode((ListLiteralNode)node);
                break;
            }
            case LIST_COMPREHENSION_NODE: {
                this.visitListComprehensionNode((ListComprehensionNode)node);
                break;
            }
            case MAP_LITERAL_NODE: {
                this.visitMapLiteralNode((MapLiteralNode)node);
                break;
            }
            case MAP_LITERAL_FROM_LIST_NODE: {
                this.visitMapLiteralFromListNode((MapLiteralFromListNode)node);
                break;
            }
            case RECORD_LITERAL_NODE: {
                this.visitRecordLiteralNode((RecordLiteralNode)node);
                break;
            }
            case VAR_REF_NODE: {
                this.visitVarRefNode((VarRefNode)node);
                break;
            }
            case FIELD_ACCESS_NODE: {
                this.visitFieldAccessNode((FieldAccessNode)node);
                break;
            }
            case ITEM_ACCESS_NODE: {
                this.visitItemAccessNode((ItemAccessNode)node);
                break;
            }
            case METHOD_CALL_NODE: {
                this.visitMethodCallNode((MethodCallNode)node);
                break;
            }
            case NULL_SAFE_ACCESS_NODE: {
                this.visitNullSafeAccessNode((NullSafeAccessNode)node);
                break;
            }
            case GLOBAL_NODE: {
                this.visitGlobalNode((GlobalNode)node);
                break;
            }
            case GROUP_NODE: {
                this.visitGroupNode((GroupNode)node);
                break;
            }
            case NEGATIVE_OP_NODE: {
                this.visitNegativeOpNode((OperatorNodes.NegativeOpNode)node);
                break;
            }
            case NOT_OP_NODE: {
                this.visitNotOpNode((OperatorNodes.NotOpNode)node);
                break;
            }
            case TIMES_OP_NODE: {
                this.visitTimesOpNode((OperatorNodes.TimesOpNode)node);
                break;
            }
            case DIVIDE_BY_OP_NODE: {
                this.visitDivideByOpNode((OperatorNodes.DivideByOpNode)node);
                break;
            }
            case MOD_OP_NODE: {
                this.visitModOpNode((OperatorNodes.ModOpNode)node);
                break;
            }
            case PLUS_OP_NODE: {
                this.visitPlusOpNode((OperatorNodes.PlusOpNode)node);
                break;
            }
            case MINUS_OP_NODE: {
                this.visitMinusOpNode((OperatorNodes.MinusOpNode)node);
                break;
            }
            case LESS_THAN_OP_NODE: {
                this.visitLessThanOpNode((OperatorNodes.LessThanOpNode)node);
                break;
            }
            case GREATER_THAN_OP_NODE: {
                this.visitGreaterThanOpNode((OperatorNodes.GreaterThanOpNode)node);
                break;
            }
            case LESS_THAN_OR_EQUAL_OP_NODE: {
                this.visitLessThanOrEqualOpNode((OperatorNodes.LessThanOrEqualOpNode)node);
                break;
            }
            case GREATER_THAN_OR_EQUAL_OP_NODE: {
                this.visitGreaterThanOrEqualOpNode((OperatorNodes.GreaterThanOrEqualOpNode)node);
                break;
            }
            case EQUAL_OP_NODE: {
                this.visitEqualOpNode((OperatorNodes.EqualOpNode)node);
                break;
            }
            case NOT_EQUAL_OP_NODE: {
                this.visitNotEqualOpNode((OperatorNodes.NotEqualOpNode)node);
                break;
            }
            case TRIPLE_EQUAL_OP_NODE: {
                this.visitTripleEqualOpNode((OperatorNodes.TripleEqualOpNode)node);
                break;
            }
            case TRIPLE_NOT_EQUAL_OP_NODE: {
                this.visitTripleNotEqualOpNode((OperatorNodes.TripleNotEqualOpNode)node);
                break;
            }
            case AND_OP_NODE: {
                this.visitAndOpNode((OperatorNodes.AndOpNode)node);
                break;
            }
            case AMP_AMP_OP_NODE: {
                this.visitAmpAmpOpNode((OperatorNodes.AmpAmpOpNode)node);
                break;
            }
            case OR_OP_NODE: {
                this.visitOrOpNode((OperatorNodes.OrOpNode)node);
                break;
            }
            case BAR_BAR_OP_NODE: {
                this.visitBarBarOpNode((OperatorNodes.BarBarOpNode)node);
                break;
            }
            case NULL_COALESCING_OP_NODE: {
                this.visitNullCoalescingOpNode((OperatorNodes.NullCoalescingOpNode)node);
                break;
            }
            case CONDITIONAL_OP_NODE: {
                this.visitConditionalOpNode((OperatorNodes.ConditionalOpNode)node);
                break;
            }
            case SHIFT_LEFT_OP_NODE: {
                this.visitShiftLeftOpNode((OperatorNodes.ShiftLeftOpNode)node);
                break;
            }
            case SHIFT_RIGHT_OP_NODE: {
                this.visitShiftRightOpNode((OperatorNodes.ShiftRightOpNode)node);
                break;
            }
            case BITWISE_OR_OP_NODE: {
                this.visitBitwiseOrOpNode((OperatorNodes.BitwiseOrOpNode)node);
                break;
            }
            case BITWISE_XOR_OP_NODE: {
                this.visitBitwiseXorOpNode((OperatorNodes.BitwiseXorOpNode)node);
                break;
            }
            case BITWISE_AND_OP_NODE: {
                this.visitBitwiseAndOpNode((OperatorNodes.BitwiseAndOpNode)node);
                break;
            }
            case FUNCTION_NODE: {
                this.visitFunctionNode((FunctionNode)node);
                break;
            }
            case TEMPLATE_LITERAL_NODE: {
                this.visitTemplateLiteralNode((TemplateLiteralNode)node);
                break;
            }
            case ASSERT_NON_NULL_OP_NODE: {
                this.visitAssertNonNullOpNode((OperatorNodes.AssertNonNullOpNode)node);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    protected void visitChildren(ExprNode.ParentExprNode node) {
        this.visitChildren(node);
    }

    protected void visitChildrenAllowingConcurrentModification(ExprNode.ParentExprNode node) {
        this.visitChildrenAllowingConcurrentModification(node);
    }

    protected void visitExprRootNode(ExprRootNode node) {
        this.visitExprNode(node);
    }

    protected void visitAssertNonNullOpNode(OperatorNodes.AssertNonNullOpNode node) {
        this.visitExprNode(node);
    }

    protected void visitNullNode(NullNode node) {
        this.visitPrimitiveNode(node);
    }

    protected void visitUndefinedNode(UndefinedNode node) {
        this.visitPrimitiveNode(node);
    }

    protected void visitBooleanNode(BooleanNode node) {
        this.visitPrimitiveNode(node);
    }

    protected void visitIntegerNode(IntegerNode node) {
        this.visitPrimitiveNode(node);
    }

    protected void visitFloatNode(FloatNode node) {
        this.visitPrimitiveNode(node);
    }

    protected void visitStringNode(StringNode node) {
        this.visitPrimitiveNode(node);
    }

    protected void visitProtoEnumValueNode(ProtoEnumValueNode node) {
        this.visitPrimitiveNode(node);
    }

    protected void visitPrimitiveNode(ExprNode.PrimitiveNode node) {
        this.visitExprNode(node);
    }

    protected void visitListLiteralNode(ListLiteralNode node) {
        this.visitExprNode(node);
    }

    protected void visitListComprehensionNode(ListComprehensionNode node) {
        this.visitExprNode(node);
    }

    protected void visitMapLiteralNode(MapLiteralNode node) {
        this.visitExprNode(node);
    }

    protected void visitMapLiteralFromListNode(MapLiteralFromListNode node) {
        this.visitExprNode(node);
    }

    protected void visitRecordLiteralNode(RecordLiteralNode node) {
        this.visitExprNode(node);
    }

    protected void visitVarRefNode(VarRefNode node) {
        this.visitExprNode(node);
    }

    protected void visitDataAccessNode(DataAccessNode node) {
        this.visitExprNode(node);
    }

    protected void visitFieldAccessNode(FieldAccessNode node) {
        this.visitDataAccessNode(node);
    }

    protected void visitItemAccessNode(ItemAccessNode node) {
        this.visitDataAccessNode(node);
    }

    protected void visitMethodCallNode(MethodCallNode node) {
        this.visitDataAccessNode(node);
    }

    protected void visitNullSafeAccessNode(NullSafeAccessNode node) {
        this.visitExprNode(node);
    }

    protected void visitGlobalNode(GlobalNode node) {
        this.visitExprNode(node);
    }

    protected void visitGroupNode(GroupNode node) {
        this.visitExprNode(node);
    }

    protected void visitNegativeOpNode(OperatorNodes.NegativeOpNode node) {
        this.visitOperatorNode(node);
    }

    protected void visitNotOpNode(OperatorNodes.NotOpNode node) {
        this.visitOperatorNode(node);
    }

    protected void visitTimesOpNode(OperatorNodes.TimesOpNode node) {
        this.visitOperatorNode(node);
    }

    protected void visitDivideByOpNode(OperatorNodes.DivideByOpNode node) {
        this.visitOperatorNode(node);
    }

    protected void visitModOpNode(OperatorNodes.ModOpNode node) {
        this.visitOperatorNode(node);
    }

    protected void visitPlusOpNode(OperatorNodes.PlusOpNode node) {
        this.visitOperatorNode(node);
    }

    protected void visitMinusOpNode(OperatorNodes.MinusOpNode node) {
        this.visitOperatorNode(node);
    }

    protected void visitLessThanOpNode(OperatorNodes.LessThanOpNode node) {
        this.visitOperatorNode(node);
    }

    protected void visitGreaterThanOpNode(OperatorNodes.GreaterThanOpNode node) {
        this.visitOperatorNode(node);
    }

    protected void visitLessThanOrEqualOpNode(OperatorNodes.LessThanOrEqualOpNode node) {
        this.visitOperatorNode(node);
    }

    protected void visitGreaterThanOrEqualOpNode(OperatorNodes.GreaterThanOrEqualOpNode node) {
        this.visitOperatorNode(node);
    }

    protected void visitEqualOpNode(OperatorNodes.EqualOpNode node) {
        this.visitOperatorNode(node);
    }

    protected void visitNotEqualOpNode(OperatorNodes.NotEqualOpNode node) {
        this.visitOperatorNode(node);
    }

    protected void visitTripleEqualOpNode(OperatorNodes.TripleEqualOpNode node) {
        this.visitOperatorNode(node);
    }

    protected void visitTripleNotEqualOpNode(OperatorNodes.TripleNotEqualOpNode node) {
        this.visitOperatorNode(node);
    }

    protected void visitAndOpNode(OperatorNodes.AndOpNode node) {
        this.visitOperatorNode(node);
    }

    protected void visitAmpAmpOpNode(OperatorNodes.AmpAmpOpNode node) {
        this.visitOperatorNode(node);
    }

    protected void visitOrOpNode(OperatorNodes.OrOpNode node) {
        this.visitOperatorNode(node);
    }

    protected void visitBarBarOpNode(OperatorNodes.BarBarOpNode node) {
        this.visitOperatorNode(node);
    }

    protected void visitNullCoalescingOpNode(OperatorNodes.NullCoalescingOpNode node) {
        this.visitOperatorNode(node);
    }

    protected void visitConditionalOpNode(OperatorNodes.ConditionalOpNode node) {
        this.visitOperatorNode(node);
    }

    protected void visitShiftLeftOpNode(OperatorNodes.ShiftLeftOpNode node) {
        this.visitOperatorNode(node);
    }

    protected void visitShiftRightOpNode(OperatorNodes.ShiftRightOpNode node) {
        this.visitOperatorNode(node);
    }

    protected void visitBitwiseOrOpNode(OperatorNodes.BitwiseOrOpNode node) {
        this.visitOperatorNode(node);
    }

    protected void visitBitwiseXorOpNode(OperatorNodes.BitwiseXorOpNode node) {
        this.visitOperatorNode(node);
    }

    protected void visitBitwiseAndOpNode(OperatorNodes.BitwiseAndOpNode node) {
        this.visitOperatorNode(node);
    }

    protected void visitOperatorNode(ExprNode.OperatorNode node) {
        this.visitExprNode(node);
    }

    protected void visitFunctionNode(FunctionNode node) {
        this.visitExprNode(node);
    }

    protected void visitTemplateLiteralNode(TemplateLiteralNode node) {
        this.visitExprNode(node);
    }

    protected void visitExprNode(ExprNode node) {
        throw new UnsupportedOperationException("no implementation for: " + String.valueOf(node));
    }
}

