/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.exprtree;

import com.google.common.base.Preconditions;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.exprtree.DataAccessNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.SoyPrecedence;
import com.google.template.soy.shared.restricted.SoySourceFunctionMethod;
import javax.annotation.Nullable;

public final class FieldAccessNode
extends DataAccessNode {
    private final String fieldName;
    @Nullable
    private SoySourceFunctionMethod method;

    public FieldAccessNode(ExprNode base, String fieldName, SourceLocation accessLocation, boolean isNullSafe) {
        super(base, accessLocation, isNullSafe);
        Preconditions.checkArgument((fieldName != null ? 1 : 0) != 0);
        this.fieldName = fieldName;
    }

    private FieldAccessNode(FieldAccessNode orig, CopyState copyState) {
        super(orig, copyState);
        this.fieldName = orig.fieldName;
        this.method = orig.method;
    }

    @Override
    public ExprNode.Kind getKind() {
        return ExprNode.Kind.FIELD_ACCESS_NODE;
    }

    @Override
    public SoyPrecedence getPrecedence() {
        return SoyPrecedence.P13;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public String getSourceStringSuffix() {
        return (this.isNullSafe() ? "?." : ".") + this.fieldName;
    }

    @Override
    public FieldAccessNode copy(CopyState copyState) {
        return new FieldAccessNode(this, copyState);
    }

    public void setSoyMethod(SoySourceFunctionMethod method) {
        this.method = method;
    }

    @Nullable
    public SoySourceFunctionMethod getSoyMethod() {
        return this.method;
    }
}

