/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.exprtree;

import com.google.auto.value.AutoOneOf;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.SourceLogicalPath;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.exprtree.AbstractParentExprNode;
import com.google.template.soy.exprtree.AutoOneOf_FunctionNode_FunctionRef;
import com.google.template.soy.exprtree.AutoValue_FunctionNode_ExternRef;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.plugin.restricted.SoySourceFunction;
import com.google.template.soy.shared.internal.BuiltinFunction;
import com.google.template.soy.shared.restricted.SoyFunction;
import com.google.template.soy.shared.restricted.SoyFunctions;
import com.google.template.soy.types.FunctionType;
import com.google.template.soy.types.SoyType;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;

public final class FunctionNode
extends AbstractParentExprNode
implements ExprNode.CallableExpr {
    public static final SoySourceFunction UNRESOLVED = new SoySourceFunction(){

        public String toString() {
            return "UNRESOLVED";
        }
    };
    private final Identifier name;
    private final ExprNode.CallableExpr.ParamsStyle paramsStyle;
    private final ImmutableList<Identifier> paramNames;
    @Nullable
    private final ImmutableList<SourceLocation.Point> commaLocations;
    private final FunctionState state = new FunctionState();

    public static FunctionNode newPositional(Identifier name, BuiltinFunction soyFunction, SourceLocation sourceLocation) {
        FunctionNode fn = new FunctionNode(sourceLocation, name, null, ExprNode.CallableExpr.ParamsStyle.POSITIONAL, (ImmutableList<Identifier>)ImmutableList.of(), null);
        fn.setSoyFunction(soyFunction);
        return fn;
    }

    public static FunctionNode newPositional(Identifier name, SoySourceFunction soyFunction, SourceLocation sourceLocation) {
        FunctionNode fn = new FunctionNode(sourceLocation, name, null, ExprNode.CallableExpr.ParamsStyle.POSITIONAL, (ImmutableList<Identifier>)ImmutableList.of(), null);
        fn.setSoyFunction(soyFunction);
        return fn;
    }

    public static FunctionNode newPositional(Identifier name, SourceLocation sourceLocation, @Nullable List<SourceLocation.Point> commaLocations) {
        return new FunctionNode(sourceLocation, name, null, ExprNode.CallableExpr.ParamsStyle.POSITIONAL, (ImmutableList<Identifier>)ImmutableList.of(), (ImmutableList<SourceLocation.Point>)(commaLocations == null ? null : ImmutableList.copyOf(commaLocations)));
    }

    public static FunctionNode newNamed(Identifier name, Iterable<Identifier> paramNames, SourceLocation sourceLocation) {
        return new FunctionNode(sourceLocation, name, null, ExprNode.CallableExpr.ParamsStyle.NAMED, (ImmutableList<Identifier>)ImmutableList.copyOf(paramNames), null);
    }

    FunctionNode(SourceLocation sourceLocation, Identifier name, ExprNode nameExpr, ExprNode.CallableExpr.ParamsStyle paramsStyle, ImmutableList<Identifier> paramNames, @Nullable ImmutableList<SourceLocation.Point> commaLocations) {
        super(sourceLocation);
        Preconditions.checkArgument((paramNames.isEmpty() || paramsStyle == ExprNode.CallableExpr.ParamsStyle.NAMED ? 1 : 0) != 0);
        Preconditions.checkArgument((name == null != (nameExpr == null) ? 1 : 0) != 0);
        this.name = name;
        if (nameExpr != null) {
            this.addChild(nameExpr);
        }
        this.paramsStyle = paramsStyle;
        this.paramNames = paramNames;
        this.commaLocations = commaLocations;
    }

    private FunctionNode(FunctionNode orig, CopyState copyState) {
        super(orig, copyState);
        this.name = orig.name;
        this.paramsStyle = orig.paramsStyle;
        this.paramNames = orig.paramNames;
        this.state.function = orig.state.function;
        this.state.allowedParamTypes = orig.state.allowedParamTypes;
        this.state.allowedToInvokeAsFunction = orig.state.allowedToInvokeAsFunction;
        this.commaLocations = orig.commaLocations;
    }

    @Override
    public Optional<ImmutableList<SourceLocation.Point>> getCommaLocations() {
        return Optional.ofNullable(this.commaLocations);
    }

    @Override
    public ExprNode.Kind getKind() {
        return ExprNode.Kind.FUNCTION_NODE;
    }

    public boolean hasStaticName() {
        return this.name != null;
    }

    public String getStaticFunctionName() {
        return this.name.identifier();
    }

    public String getFunctionName() {
        return this.name != null ? this.name.identifier() : "";
    }

    public ExprNode getNameExpr() {
        Preconditions.checkState((this.name == null ? 1 : 0) != 0);
        return (ExprNode)Preconditions.checkNotNull((Object)this.getChild(0));
    }

    @Override
    public ExprNode.CallableExpr.ParamsStyle getParamsStyle() {
        return this.paramsStyle;
    }

    @Override
    public Identifier getIdentifier() {
        return this.name;
    }

    public SourceLocation getFunctionNameLocation() {
        return this.name != null ? this.name.location() : this.getNameExpr().getSourceLocation();
    }

    public boolean isResolved() {
        return this.state.function != null;
    }

    public boolean allowedToInvokeAsFunction() {
        return this.state.allowedToInvokeAsFunction;
    }

    public void setAllowedToInvokeAsFunction(boolean cond) {
        this.state.allowedToInvokeAsFunction = cond;
    }

    public Object getSoyFunction() {
        Preconditions.checkState((this.state.function != null ? 1 : 0) != 0, (String)"setSoyFunction() hasn't been called yet %s %s", (Object)this.name, (Object)this.getSourceLocation());
        return this.state.function.either();
    }

    public void setSoyFunction(Object soyFunction) {
        Preconditions.checkNotNull((Object)soyFunction);
        FunctionRef newRef = FunctionRef.of(soyFunction);
        Preconditions.checkState((this.state.function == null || this.state.function.equals(newRef) ? 1 : 0) != 0, (String)"setSoyFunction() was already called; %s; %s (previous) != %s (current)", (Object)this.getSourceLocation().toLineColumnString(), (Object)this.state.function, (Object)newRef);
        this.state.function = newRef;
    }

    public void setAllowedParamTypes(List<SoyType> allowedParamTypes) {
        Preconditions.checkState((this.paramsStyle == ExprNode.CallableExpr.ParamsStyle.POSITIONAL || this.numParams() == 0 ? 1 : 0) != 0);
        Preconditions.checkState((allowedParamTypes.size() == this.numParams() ? 1 : 0) != 0, (String)"allowedParamTypes.size (%s) != numParams (%s)", (int)allowedParamTypes.size(), (int)this.numParams());
        this.state.allowedParamTypes = ImmutableList.copyOf(allowedParamTypes);
    }

    @Nullable
    public ImmutableList<SoyType> getAllowedParamTypes() {
        Preconditions.checkState((this.paramsStyle == ExprNode.CallableExpr.ParamsStyle.POSITIONAL || this.numParams() == 0 ? 1 : 0) != 0);
        return this.state.allowedParamTypes;
    }

    @Override
    public ImmutableList<Identifier> getParamNames() {
        Preconditions.checkState((this.paramsStyle == ExprNode.CallableExpr.ParamsStyle.NAMED || this.numParams() == 0 ? 1 : 0) != 0);
        return this.paramNames;
    }

    @Override
    public String toSourceString() {
        StringBuilder sourceSb = new StringBuilder();
        sourceSb.append(this.hasStaticName() ? this.getStaticFunctionName() : this.getNameExpr().toSourceString()).append('(');
        List<ExprNode> params = this.getParams();
        if (this.paramsStyle == ExprNode.CallableExpr.ParamsStyle.POSITIONAL) {
            boolean isFirst = true;
            for (ExprNode child : params) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sourceSb.append(", ");
                }
                sourceSb.append(child.toSourceString());
            }
        } else if (this.paramsStyle == ExprNode.CallableExpr.ParamsStyle.NAMED) {
            for (int i = 0; i < params.size(); ++i) {
                if (i > 0) {
                    sourceSb.append(", ");
                }
                sourceSb.append(this.paramNames.get(i)).append(": ");
                sourceSb.append(params.get(i).toSourceString());
            }
        }
        sourceSb.append(')');
        return sourceSb.toString();
    }

    @Override
    public FunctionNode copy(CopyState copyState) {
        return new FunctionNode(this, copyState);
    }

    public boolean isPure() {
        if (!this.isResolved()) {
            return false;
        }
        if (this.state.function.type() == FunctionRef.Type.EXTERN) {
            return false;
        }
        return SoyFunctions.isPure(this.state.function.either());
    }

    @Override
    public List<ExprNode> getParams() {
        return this.name == null ? this.getChildren().subList(1, this.numChildren()) : this.getChildren();
    }

    @Override
    public ExprNode getParam(int index) {
        return this.name == null ? this.getChild(index + 1) : this.getChild(index);
    }

    @Override
    public int numParams() {
        return this.name == null ? this.numChildren() - 1 : this.numChildren();
    }

    public int getParamIndex(ExprNode node) {
        return this.name == null ? this.getChildIndex(node) - 1 : this.getChildIndex(node);
    }

    private static final class FunctionState {
        @Nullable
        private FunctionRef function;
        @Nullable
        private ImmutableList<SoyType> allowedParamTypes;
        private boolean allowedToInvokeAsFunction = false;

        private FunctionState() {
        }
    }

    @AutoOneOf(value=Type.class)
    public static abstract class FunctionRef {
        public static FunctionRef of(Object soyFunction) {
            if (soyFunction instanceof SoyFunction) {
                return FunctionRef.of((SoyFunction)soyFunction);
            }
            if (soyFunction instanceof SoySourceFunction) {
                return FunctionRef.of((SoySourceFunction)soyFunction);
            }
            if (soyFunction instanceof ExternRef) {
                return FunctionRef.of((ExternRef)soyFunction);
            }
            throw new ClassCastException(String.valueOf(soyFunction));
        }

        public static FunctionRef of(SoyFunction soyFunction) {
            return AutoOneOf_FunctionNode_FunctionRef.soyFunction(soyFunction);
        }

        public static FunctionRef of(SoySourceFunction soySourceFunction) {
            return AutoOneOf_FunctionNode_FunctionRef.soySourceFunction(soySourceFunction);
        }

        public static FunctionRef of(ExternRef functionType) {
            return AutoOneOf_FunctionNode_FunctionRef.extern(functionType);
        }

        abstract Type type();

        abstract SoyFunction soyFunction();

        abstract SoySourceFunction soySourceFunction();

        abstract ExternRef extern();

        public Object either() {
            switch (this.type()) {
                case SOY_FUNCTION: {
                    return this.soyFunction();
                }
                case SOY_SOURCE_FUNCTION: {
                    return this.soySourceFunction();
                }
                case EXTERN: {
                    return this.extern();
                }
            }
            throw new AssertionError();
        }

        static enum Type {
            SOY_FUNCTION,
            SOY_SOURCE_FUNCTION,
            EXTERN;

        }
    }

    @AutoValue
    public static abstract class ExternRef {
        public static ExternRef of(SourceLogicalPath path, String name, FunctionType signature) {
            return new AutoValue_FunctionNode_ExternRef(path, name, signature);
        }

        public abstract SourceLogicalPath path();

        public abstract String name();

        public abstract FunctionType signature();
    }
}

