/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.exprtree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.exprtree.DataAccessNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.SoyPrecedence;
import com.google.template.soy.shared.restricted.SoyMethod;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypes;
import java.util.List;
import java.util.Optional;

public final class MethodCallNode
extends DataAccessNode
implements ExprNode.CallableExpr {
    private final Identifier methodName;
    private final ExprNode.CallableExpr.ParamsStyle paramsStyle;
    private final ImmutableList<Identifier> paramNames;
    private SoyMethod method;

    public static MethodCallNode newWithPositionalArgs(ExprNode base, List<ExprNode> params, Identifier methodName, SourceLocation location, boolean isNullSafe) {
        MethodCallNode call = new MethodCallNode(base, isNullSafe, location, methodName, ExprNode.CallableExpr.ParamsStyle.POSITIONAL, (ImmutableList<Identifier>)ImmutableList.of());
        call.addChildren((List<? extends ExprNode>)params);
        return call;
    }

    MethodCallNode(ExprNode base, boolean isNullSafe, SourceLocation sourceLocation, Identifier methodName, ExprNode.CallableExpr.ParamsStyle paramsStyle, ImmutableList<Identifier> paramNames) {
        super(base, sourceLocation, isNullSafe);
        this.methodName = (Identifier)Preconditions.checkNotNull((Object)methodName);
        this.paramNames = paramNames;
        this.paramsStyle = paramsStyle;
    }

    private MethodCallNode(MethodCallNode orig, CopyState copyState) {
        super(orig, copyState);
        this.methodName = orig.methodName;
        this.paramsStyle = orig.paramsStyle;
        this.paramNames = orig.paramNames;
        this.method = orig.method;
    }

    public Identifier getMethodName() {
        return this.methodName;
    }

    public void setSoyMethod(SoyMethod method) {
        this.method = method;
    }

    public SoyMethod getSoyMethod() {
        Preconditions.checkState((this.method != null ? 1 : 0) != 0, (Object)("setSoyMethod() hasn't been called yet at " + String.valueOf(this.getSourceLocation())));
        return this.method;
    }

    public SoyType getBaseType(boolean nullSafe) {
        SoyType type = this.getBaseExprChild().getType();
        if (nullSafe) {
            type = SoyTypes.tryRemoveNullish(type);
        }
        return type;
    }

    @Override
    public List<ExprNode> getParams() {
        return this.getChildren().subList(1, this.numChildren());
    }

    @Override
    public int numParams() {
        return this.numChildren() - 1;
    }

    public boolean isMethodResolved() {
        return this.method != null;
    }

    @Override
    public String getSourceStringSuffix() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.isNullSafe() ? "?." : ".").append(this.getMethodName().identifier()).append('(');
        for (int i = 1; i < this.numChildren(); ++i) {
            if (i > 1) {
                sb.append(", ");
            }
            sb.append(this.getChild(i).toSourceString());
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public ExprNode.Kind getKind() {
        return ExprNode.Kind.METHOD_CALL_NODE;
    }

    @Override
    public SoyPrecedence getPrecedence() {
        return SoyPrecedence.P13;
    }

    @Override
    public ExprNode copy(CopyState copyState) {
        return new MethodCallNode(this, copyState);
    }

    @Override
    public ExprNode.CallableExpr.ParamsStyle getParamsStyle() {
        return this.paramsStyle;
    }

    @Override
    public ImmutableList<Identifier> getParamNames() {
        Preconditions.checkState((this.paramsStyle != ExprNode.CallableExpr.ParamsStyle.POSITIONAL ? 1 : 0) != 0);
        return this.paramNames;
    }

    @Override
    public Optional<ImmutableList<SourceLocation.Point>> getCommaLocations() {
        return Optional.empty();
    }

    @Override
    public Identifier getIdentifier() {
        return this.methodName;
    }
}

