/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.exprtree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.internal.QuoteStyle;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.exprtree.AbstractParentExprNode;
import com.google.template.soy.exprtree.DataAccessNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.FieldAccessNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.exprtree.GroupNode;
import com.google.template.soy.exprtree.ItemAccessNode;
import com.google.template.soy.exprtree.MethodCallNode;
import com.google.template.soy.exprtree.OperatorNodes;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.internal.util.TreeStreams;
import java.util.List;
import javax.annotation.Nullable;

public final class NullSafeAccessNode
extends AbstractParentExprNode {
    private static final String BASE_PLACEHOLDER_VALUE = "DO_NOT_USE__NULL_SAFE_ACCESS";

    private NullSafeAccessNode(ExprNode base, ExprNode.AccessChainComponentNode access) {
        super(access.getSourceLocation());
        this.addChild(base);
        this.addChild(access);
    }

    private NullSafeAccessNode(NullSafeAccessNode orig, CopyState copyState) {
        super(orig, copyState);
    }

    @Override
    public ExprNode.Kind getKind() {
        return ExprNode.Kind.NULL_SAFE_ACCESS_NODE;
    }

    @Override
    public String toSourceString() {
        StringBuilder sourceString = new StringBuilder(this.getBase().toSourceString());
        ExprNode dataAccess = this.getDataAccess();
        while (dataAccess.getKind() == ExprNode.Kind.NULL_SAFE_ACCESS_NODE) {
            NullSafeAccessNode node = (NullSafeAccessNode)dataAccess;
            NullSafeAccessNode.accumulateDataAccess(sourceString, (ExprNode.AccessChainComponentNode)node.getBase());
            dataAccess = node.getDataAccess();
        }
        NullSafeAccessNode.accumulateDataAccess(sourceString, (ExprNode.AccessChainComponentNode)dataAccess);
        return sourceString.toString();
    }

    private static void accumulateDataAccess(StringBuilder accumulator, ExprNode.AccessChainComponentNode node) {
        StringBuilder dataAccessChain = new StringBuilder();
        ExprNode child = node;
        while (child instanceof ExprNode.AccessChainComponentNode) {
            if (child instanceof DataAccessNode) {
                DataAccessNode dataAccessNode = (DataAccessNode)child;
                dataAccessChain.insert(0, dataAccessNode.getSourceStringSuffix());
                child = dataAccessNode.getBaseExprChild();
                continue;
            }
            OperatorNodes.AssertNonNullOpNode assertNonNullOpNode = (OperatorNodes.AssertNonNullOpNode)child;
            dataAccessChain.insert(0, assertNonNullOpNode.getOperator().getTokenString());
            child = assertNonNullOpNode.getChild(0);
        }
        accumulator.append('?').append((CharSequence)dataAccessChain);
    }

    @Override
    public ExprNode copy(CopyState copyState) {
        return new NullSafeAccessNode(this, copyState);
    }

    public ExprNode getBase() {
        return this.getChild(0);
    }

    public ExprNode getDataAccess() {
        return this.getChild(1);
    }

    public static boolean isPlaceholder(ExprNode node) {
        return node.getKind() == ExprNode.Kind.STRING_NODE && ((StringNode)node).getValue().equals(BASE_PLACEHOLDER_VALUE) || node.getKind() == ExprNode.Kind.GROUP_NODE && ((GroupNode)node).isNullSafeAccessPlaceHolder();
    }

    public static void createAndInsert(DataAccessNode node, ExprNode.AccessChainComponentNode accessChainRoot) {
        NullSafeAccessNode nullSafe;
        DataAccessNode child;
        Preconditions.checkArgument((boolean)node.isNullSafe());
        ExprNode base = node.getBaseExprChild();
        StringNode basePlaceholder = new StringNode(BASE_PLACEHOLDER_VALUE, QuoteStyle.DOUBLE, base.getSourceLocation());
        switch (node.getKind()) {
            case FIELD_ACCESS_NODE: {
                child = new FieldAccessNode(basePlaceholder, ((FieldAccessNode)node).getFieldName(), node.getAccessSourceLocation(), false);
                break;
            }
            case ITEM_ACCESS_NODE: {
                child = new ItemAccessNode(basePlaceholder, ((ItemAccessNode)node).getKeyExprChild(), node.getAccessSourceLocation(), false);
                break;
            }
            case METHOD_CALL_NODE: {
                MethodCallNode childMethodCall = MethodCallNode.newWithPositionalArgs(basePlaceholder, node.getChildren().subList(1, node.numChildren()), ((MethodCallNode)node).getMethodName(), node.getAccessSourceLocation(), false);
                if (((MethodCallNode)node).isMethodResolved()) {
                    childMethodCall.setSoyMethod(((MethodCallNode)node).getSoyMethod());
                }
                child = childMethodCall;
                break;
            }
            default: {
                throw new AssertionError((Object)node.getKind());
            }
        }
        ExprNode.ParentExprNode accessChainParent = accessChainRoot.getParent();
        int rootIndex = accessChainParent.getChildIndex(accessChainRoot);
        if (node == accessChainRoot) {
            nullSafe = new NullSafeAccessNode(base, child);
            accessChainParent.removeChild(rootIndex);
        } else {
            node.getParent().replaceChild(node, child);
            nullSafe = new NullSafeAccessNode(base, accessChainRoot);
        }
        accessChainParent.addChild(rootIndex, nullSafe);
    }

    @Nullable
    public ExprNode.AccessChainComponentNode asAccessChain() {
        NullSafeAccessNode nsan = (NullSafeAccessNode)this.copy(new CopyState());
        Preconditions.checkState((!(nsan.getParent() instanceof NullSafeAccessNode) ? 1 : 0) != 0);
        ExprNode base = nsan.getBase();
        Preconditions.checkState((!NullSafeAccessNode.isPlaceholder(base) ? 1 : 0) != 0);
        ImmutableList bfNodes = (ImmutableList)TreeStreams.depthFirst(nsan, NullSafeAccessNode::dataAccessSuccessors).filter(DataAccessNode.class::isInstance).map(DataAccessNode.class::cast).filter(n -> NullSafeAccessNode.isPlaceholder(n.getBaseExprChild())).collect(ImmutableList.toImmutableList());
        for (DataAccessNode node : bfNodes) {
            node.setNullSafe(true);
            node.replaceChild(0, base);
            base = node;
            while (base.getParent() instanceof ExprNode.AccessChainComponentNode) {
                base = base.getParent();
            }
        }
        if (base instanceof ExprNode.AccessChainComponentNode) {
            return (ExprNode.AccessChainComponentNode)base;
        }
        return null;
    }

    private static List<ExprNode> dataAccessSuccessors(ExprNode node) {
        switch (node.getKind()) {
            case NULL_SAFE_ACCESS_NODE: {
                return ((NullSafeAccessNode)node).getChildren();
            }
            case FIELD_ACCESS_NODE: 
            case ITEM_ACCESS_NODE: 
            case METHOD_CALL_NODE: {
                return ImmutableList.of((Object)((DataAccessNode)node).getBaseExprChild());
            }
            case ASSERT_NON_NULL_OP_NODE: {
                return ImmutableList.of((Object)((OperatorNodes.AssertNonNullOpNode)node).getChild(0));
            }
        }
        return ImmutableList.of();
    }

    public ImmutableList<ExprNode> asNullSafeBaseList() {
        ExprNode.AccessChainComponentNode accessChainHead = this.asAccessChain();
        if (accessChainHead == null) {
            return ImmutableList.of();
        }
        ExprNode.AccessChainComponentNode accessChainTail = accessChainHead;
        while (accessChainTail.getChild(0) instanceof ExprNode.AccessChainComponentNode) {
            accessChainTail = (ExprNode.AccessChainComponentNode)accessChainTail.getChild(0);
        }
        ImmutableList.Builder nullSafeBases = ImmutableList.builder();
        while (true) {
            DataAccessNode dataAccess;
            if (accessChainTail instanceof DataAccessNode && (dataAccess = (DataAccessNode)accessChainTail).isNullSafe()) {
                dataAccess.setNullSafe(false);
                nullSafeBases.add((Object)dataAccess.getBaseExprChild());
            }
            if (accessChainTail == accessChainHead) break;
            accessChainTail = (ExprNode.AccessChainComponentNode)accessChainTail.getParent();
        }
        nullSafeBases.add((Object)accessChainHead);
        return nullSafeBases.build();
    }

    public ExprNode asMergedBase() {
        if (!(this.getBase() instanceof ExprNode.AccessChainComponentNode)) {
            return this.getBase().copy(new CopyState());
        }
        NullSafeAccessNode nsan = this;
        ImmutableList.Builder bases = ImmutableList.builder();
        while (nsan.getParent() instanceof NullSafeAccessNode) {
            nsan = (NullSafeAccessNode)nsan.getParent();
            bases.add((Object)nsan.getBase());
        }
        return NullSafeAccessNode.copyAndGraftPlaceholders((ExprNode.AccessChainComponentNode)this.getBase(), (ImmutableList<ExprNode>)bases.build());
    }

    public static ExprNode.AccessChainComponentNode copyAndGraftPlaceholders(ExprNode.AccessChainComponentNode head, ImmutableList<ExprNode> bases) {
        ExprNode.AccessChainComponentNode copy = (ExprNode.AccessChainComponentNode)head.copy(new CopyState());
        ExprNode curr = copy;
        for (ExprNode base : bases) {
            block5: {
                while (true) {
                    if (curr instanceof DataAccessNode) {
                        if (!NullSafeAccessNode.isPlaceholder(((DataAccessNode)curr).getBaseExprChild())) {
                            curr = ((DataAccessNode)curr).getBaseExprChild();
                            continue;
                        }
                        break block5;
                    }
                    if (!(curr instanceof OperatorNodes.AssertNonNullOpNode)) break;
                    curr = ((OperatorNodes.AssertNonNullOpNode)curr).getChild(0);
                }
                if (curr instanceof GlobalNode) {
                    return copy;
                }
                throw new AssertionError((Object)("Found unexpected node " + String.valueOf((Object)curr.getKind())));
            }
            ((DataAccessNode)curr).replaceChild(0, base.copy(new CopyState()));
        }
        return copy;
    }
}

