/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.exprtree;

import com.google.common.base.Preconditions;
import com.google.template.soy.exprtree.ExprNode;

public enum SoyPrecedence {
    NONE,
    P1,
    P2,
    P3,
    P4,
    P5,
    P6,
    P7,
    P8,
    P9,
    P10,
    P11,
    P12,
    P13,
    PRIMARY;


    public boolean greaterThan(SoyPrecedence other) {
        return this.ordinal() > other.ordinal();
    }

    public boolean lessThan(SoyPrecedence other) {
        return this.ordinal() < other.ordinal();
    }

    public boolean lessThanOrEqual(SoyPrecedence other) {
        return this.ordinal() <= other.ordinal();
    }

    public static boolean shouldGuard(ExprNode.ParentExprNode parent, ExprNode child) {
        int childIndex = parent.getChildIndex(child);
        Preconditions.checkArgument((childIndex >= 0 ? 1 : 0) != 0);
        return SoyPrecedence.shouldGuard(parent, child, childIndex);
    }

    public static boolean shouldGuard(ExprNode.ParentExprNode parent, ExprNode child, int childIndex) {
        switch (parent.getKind()) {
            case EXPR_ROOT_NODE: 
            case GROUP_NODE: 
            case FUNCTION_NODE: 
            case LIST_LITERAL_NODE: 
            case MAP_LITERAL_NODE: 
            case MAP_LITERAL_FROM_LIST_NODE: 
            case LIST_COMPREHENSION_NODE: 
            case RECORD_LITERAL_NODE: {
                return false;
            }
            case METHOD_CALL_NODE: 
            case ITEM_ACCESS_NODE: {
                if (childIndex <= 0) break;
                return false;
            }
        }
        OperandPosition operandPosition = SoyPrecedence.getOperandPosition(childIndex);
        return child.getPrecedence().lessThan(parent.getPrecedence()) || child.getPrecedence() == parent.getPrecedence() && operandPosition.shouldParenthesize(child.getAssociativity());
    }

    private static OperandPosition getOperandPosition(int childIndex) {
        return childIndex == 0 ? OperandPosition.LEFT : OperandPosition.RIGHT;
    }

    private static enum OperandPosition {
        LEFT{

            @Override
            public boolean shouldParenthesize(Associativity operandAssociativity) {
                return operandAssociativity == Associativity.RIGHT;
            }
        }
        ,
        RIGHT{

            @Override
            public boolean shouldParenthesize(Associativity operandAssociativity) {
                return operandAssociativity == Associativity.LEFT;
            }
        };


        public abstract boolean shouldParenthesize(Associativity var1);
    }

    public static enum Associativity {
        LEFT,
        RIGHT,
        NA;

    }
}

