/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.exprtree;

import com.google.common.base.Preconditions;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.base.internal.QuoteStyle;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.exprtree.AbstractPrimitiveNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.types.StringType;

public final class StringNode
extends AbstractPrimitiveNode {
    private final String value;
    private final QuoteStyle quoteStyle;
    private final boolean isXid;

    public StringNode(String value, QuoteStyle quoteStyle, SourceLocation sourceLocation) {
        this(value, quoteStyle, sourceLocation, false);
    }

    public StringNode(String value, QuoteStyle quoteStyle, SourceLocation sourceLocation, boolean isXid) {
        super(sourceLocation);
        this.value = (String)Preconditions.checkNotNull((Object)value);
        Preconditions.checkArgument((quoteStyle == QuoteStyle.SINGLE || quoteStyle == QuoteStyle.DOUBLE ? 1 : 0) != 0, (Object)"StringNode quote style must be SINGLE or DOUBLE");
        this.quoteStyle = quoteStyle;
        this.isXid = isXid;
    }

    private StringNode(StringNode orig, CopyState copyState) {
        super(orig, copyState);
        this.value = orig.value;
        this.quoteStyle = orig.quoteStyle;
        this.isXid = orig.isXid;
    }

    @Override
    public ExprNode.Kind getKind() {
        return ExprNode.Kind.STRING_NODE;
    }

    @Override
    public StringType getType() {
        return StringType.getInstance();
    }

    public String getValue() {
        return this.value;
    }

    public QuoteStyle getQuoteStyle() {
        return this.quoteStyle;
    }

    public boolean isXid() {
        return this.isXid;
    }

    @Override
    public String toSourceString() {
        return this.toSourceString(false);
    }

    public String toSourceString(boolean escapeToAscii) {
        return BaseUtils.escapeToWrappedSoyString(this.value, escapeToAscii, this.quoteStyle);
    }

    @Override
    public StringNode copy(CopyState copyState) {
        return new StringNode(this, copyState);
    }
}

