/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.exprtree;

import com.google.common.base.Preconditions;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.TriState;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.exprtree.AbstractParentExprNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.TemplateImportType;
import com.google.template.soy.types.UnknownType;
import javax.annotation.Nullable;

public final class TemplateLiteralNode
extends AbstractParentExprNode {
    private TriState isStaticCall = TriState.UNSET;
    private String templateFqn;
    private SoyType type;

    public static TemplateLiteralNode forVarRef(VarRefNode varRef) {
        return TemplateLiteralNode.forVarRef(varRef, varRef.getSourceLocation());
    }

    public static TemplateLiteralNode forVarRef(VarRefNode varRef, SourceLocation sourceLocation) {
        TemplateLiteralNode node = new TemplateLiteralNode(sourceLocation);
        node.addChild(varRef);
        if (varRef.hasType() && varRef.getType().getKind() == SoyType.Kind.TEMPLATE_TYPE) {
            node.resolveTemplateName();
        }
        return node;
    }

    private TemplateLiteralNode(SourceLocation sourceLocation) {
        super(sourceLocation);
    }

    private TemplateLiteralNode(TemplateLiteralNode orig, CopyState copyState) {
        super(orig, copyState);
        this.isStaticCall = orig.isStaticCall;
        this.templateFqn = orig.templateFqn;
        this.type = orig.type;
    }

    public boolean isStaticCall() {
        Preconditions.checkState((boolean)this.isStaticCall.isSet(), (Object)"May not call before setStaticCall()");
        return this.isStaticCall == TriState.ENABLED;
    }

    public void setStaticCall(boolean isStaticCall) {
        this.isStaticCall = TriState.from(isStaticCall);
    }

    public void resolveTemplateName() {
        Preconditions.checkState((!this.isResolved() ? 1 : 0) != 0, (Object)"Template identifier has already been resolved.");
        SoyType type = this.getChild(0).getType();
        if (type.getKind() == SoyType.Kind.TEMPLATE_TYPE) {
            this.templateFqn = ((TemplateImportType)type).getName();
            this.type = type;
        } else {
            this.templateFqn = "";
            this.type = UnknownType.getInstance();
        }
    }

    public boolean isResolved() {
        return this.templateFqn != null;
    }

    @Nullable
    public String getResolvedName() {
        return this.templateFqn;
    }

    @Override
    public SoyType getType() {
        return this.type;
    }

    @Override
    public void setType(SoyType type) {
        this.type = (SoyType)Preconditions.checkNotNull((Object)type);
    }

    @Override
    public ExprNode.Kind getKind() {
        return ExprNode.Kind.TEMPLATE_LITERAL_NODE;
    }

    @Override
    public String toSourceString() {
        return this.getChild(0).toSourceString();
    }

    @Override
    public TemplateLiteralNode copy(CopyState copyState) {
        return new TemplateLiteralNode(this, copyState);
    }
}

