/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.incrementaldomsrc;

import com.google.common.base.Ascii;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SanitizedContentOperator;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.incrementaldomsrc.AssistantForHtmlMsgs;
import com.google.template.soy.incrementaldomsrc.IncrementalDomRuntime;
import com.google.template.soy.incrementaldomsrc.IncrementalDomTranslateExprNodeVisitor;
import com.google.template.soy.jssrc.SoyJsSrcOptions;
import com.google.template.soy.jssrc.dsl.ConditionalBuilder;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.Expressions;
import com.google.template.soy.jssrc.dsl.GoogRequire;
import com.google.template.soy.jssrc.dsl.JsArrowFunction;
import com.google.template.soy.jssrc.dsl.JsDoc;
import com.google.template.soy.jssrc.dsl.LineComment;
import com.google.template.soy.jssrc.dsl.Statement;
import com.google.template.soy.jssrc.dsl.Statements;
import com.google.template.soy.jssrc.dsl.TryCatch;
import com.google.template.soy.jssrc.dsl.VariableDeclaration;
import com.google.template.soy.jssrc.internal.CanInitOutputVarVisitor;
import com.google.template.soy.jssrc.internal.GenCallCodeUtils;
import com.google.template.soy.jssrc.internal.GenJsCodeVisitor;
import com.google.template.soy.jssrc.internal.GenJsCodeVisitorAssistantForMsgs;
import com.google.template.soy.jssrc.internal.GenJsExprsVisitor;
import com.google.template.soy.jssrc.internal.GenJsTemplateBodyVisitor;
import com.google.template.soy.jssrc.internal.IsComputableAsJsExprsVisitor;
import com.google.template.soy.jssrc.internal.JavaScriptValueFactoryImpl;
import com.google.template.soy.jssrc.internal.JsRuntime;
import com.google.template.soy.jssrc.internal.OutputVarHandler;
import com.google.template.soy.jssrc.internal.TemplateAliases;
import com.google.template.soy.jssrc.internal.TranslateExprNodeVisitor;
import com.google.template.soy.jssrc.internal.TranslationContext;
import com.google.template.soy.logging.LoggingFunction;
import com.google.template.soy.shared.internal.BuiltinFunction;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.FileSetMetadata;
import com.google.template.soy.soytree.ForNode;
import com.google.template.soy.soytree.HtmlAttributeNode;
import com.google.template.soy.soytree.HtmlAttributeValueNode;
import com.google.template.soy.soytree.HtmlCloseTagNode;
import com.google.template.soy.soytree.HtmlCommentNode;
import com.google.template.soy.soytree.HtmlContext;
import com.google.template.soy.soytree.HtmlOpenTagNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.KeyNode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.Metadata;
import com.google.template.soy.soytree.MsgFallbackGroupNode;
import com.google.template.soy.soytree.MsgHtmlTagNode;
import com.google.template.soy.soytree.MsgPlaceholderNode;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SkipNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SwitchCaseNode;
import com.google.template.soy.soytree.SwitchDefaultNode;
import com.google.template.soy.soytree.SwitchNode;
import com.google.template.soy.soytree.TagName;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.VeLogNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public final class GenIncrementalDomTemplateBodyVisitor
extends GenJsTemplateBodyVisitor {
    private final Deque<SanitizedContentKind> contentKind;
    private final List<Statement> staticVarDeclarations;
    private final boolean generatePositionalParamsSignature;
    private final FileSetMetadata fileSetMetadata;
    private final String alias;
    private int staticsCounter = 0;
    private String scriptOutputVar;

    GenIncrementalDomTemplateBodyVisitor(OutputVarHandler outputVars, SoyJsSrcOptions jsSrcOptions, JavaScriptValueFactoryImpl javaScriptValueFactory, GenCallCodeUtils genCallCodeUtils, IsComputableAsJsExprsVisitor isComputableAsJsExprsVisitor, CanInitOutputVarVisitor canInitOutputVarVisitor, GenJsExprsVisitor genJsExprsVisitor, ErrorReporter errorReporter, TranslationContext templateTranslationContext, TemplateAliases templateAliases, Deque<SanitizedContentKind> contentKind, List<Statement> staticVarDeclarations, boolean generatePositionalParamsSignature, FileSetMetadata fileSetMetadata, String alias) {
        super(outputVars, jsSrcOptions, javaScriptValueFactory, genCallCodeUtils, isComputableAsJsExprsVisitor, canInitOutputVarVisitor, genJsExprsVisitor, errorReporter, templateTranslationContext, templateAliases);
        this.contentKind = contentKind;
        this.staticVarDeclarations = staticVarDeclarations;
        this.generatePositionalParamsSignature = generatePositionalParamsSignature;
        this.fileSetMetadata = fileSetMetadata;
        this.alias = alias;
    }

    @Override
    protected List<Statement> visitChildren(SoyNode.ParentSoyNode<?> node) {
        ArrayList<Statement> statements = new ArrayList<Statement>();
        for (SoyNode child : node.getChildren()) {
            statements.add(this.visit(child));
        }
        return statements;
    }

    private Statement visitLetParamContentNode(SoyNode.RenderUnitNode node, String generatedVarName) {
        Statement definition;
        Preconditions.checkState((node.getContentKind() != null ? 1 : 0) != 0);
        this.contentKind.push(node.getContentKind());
        VariableDeclaration.Builder builder = VariableDeclaration.builder(generatedVarName);
        SanitizedContentKind kind = node.getContentKind();
        if (kind.isHtml() || kind == SanitizedContentKind.ATTRIBUTES) {
            Expression constructor = kind.isHtml() ? IncrementalDomRuntime.SOY_IDOM_MAKE_HTML : IncrementalDomRuntime.SOY_IDOM_MAKE_ATTRIBUTES;
            JsDoc jsdoc = JsDoc.builder().addParam("idomRenderer", "incrementaldomlib.IncrementalDomRenderer").build();
            Statement content = Statements.of(this.visitChildren(node));
            definition = builder.setRhs(constructor.call(Expressions.arrowFunction(jsdoc, content))).build();
        } else {
            String outputVarName = generatedVarName + "_output";
            this.outputVars.pushOutputVar(outputVarName);
            this.outputVars.setOutputVarInited();
            definition = Statements.of(VariableDeclaration.builder(outputVarName).setMutable().setRhs(Expressions.LITERAL_EMPTY_STRING).build(), Statements.of(this.visitChildren(node)), builder.setRhs(kind == SanitizedContentKind.TEXT ? Expressions.id(outputVarName) : JsRuntime.sanitizedContentOrdainerFunction(node.getContentKind()).call(Expressions.id(outputVarName))).build());
            this.outputVars.popOutputVar();
        }
        this.contentKind.pop();
        return definition;
    }

    @Override
    protected Statement visitLetContentNode(LetContentNode node) {
        String generatedVarName = node.getUniqueVarName();
        Statement statement = this.visitLetParamContentNode(node, generatedVarName);
        this.templateTranslationContext.soyToJsVariableMappings().put(node.getVar(), Expressions.id(generatedVarName));
        return statement;
    }

    @Override
    protected Statement visitCallParamContentNode(CallParamContentNode node) {
        String generatedVarName = "param" + node.getId();
        return this.visitLetParamContentNode(node, generatedVarName);
    }

    @Override
    protected Statement visitCallNode(CallNode node) {
        Expression call;
        ArrayList<Statement> statements = new ArrayList<Statement>();
        for (CallParamNode child : node.getChildren()) {
            if (!(child instanceof CallParamContentNode) || ((Boolean)this.isComputableAsJsExprsVisitor.exec(child)).booleanValue()) continue;
            statements.add(this.visit(child));
        }
        Optional<SanitizedContentKind> kind = Metadata.getCallContentKind(this.fileSetMetadata, node);
        GenCallCodeUtils.Callee callee = this.genCallCodeUtils.genCallee(node, this.templateAliases, this.getExprTranslator());
        Supplier<Expression> objToPass = () -> this.genCallCodeUtils.genObjToPass(node, this.templateAliases, this.templateTranslationContext, this.errorReporter, this.getExprTranslator());
        Optional<Supplier<List<Expression>>> positionalParameters = Optional.empty();
        if (this.genCallCodeUtils.canPerformPositionalCall(node)) {
            positionalParameters = Optional.of(() -> this.genCallCodeUtils.getPositionalParams((CallBasicNode)node, this.templateAliases, this.templateTranslationContext, this.errorReporter, this.getExprTranslator(), GenCallCodeUtils.hasVariant(node)));
        }
        boolean shouldPushKey = false;
        Expression idomRenderer = IncrementalDomRuntime.INCREMENTAL_DOM;
        if (node.isErrorFallbackSkip()) {
            VariableDeclaration bufferRendererInit = VariableDeclaration.builder("renderer_call_" + node.getId()).setRhs(Expressions.construct(IncrementalDomRuntime.BUFFERING_IDOM_RENDERER, new Expression[0])).build();
            idomRenderer = bufferRendererInit.ref();
            statements.add(bufferRendererInit);
        }
        switch (node.getHtmlContext()) {
            case HTML_TAG: {
                if (!kind.isPresent() || kind.get() != SanitizedContentKind.ATTRIBUTES) {
                    call = IncrementalDomRuntime.SOY_IDOM_CALL_DYNAMIC_ATTRIBUTES.call(idomRenderer, callee.objectStyle(), objToPass.get(), JsRuntime.IJ_DATA);
                    break;
                }
                call = GenIncrementalDomTemplateBodyVisitor.directCall(callee, node, this.getExprTranslator(), positionalParameters, objToPass, idomRenderer);
                break;
            }
            case CSS: {
                call = IncrementalDomRuntime.SOY_IDOM_CALL_DYNAMIC_CSS.call(idomRenderer, callee.objectStyle(), objToPass.get(), JsRuntime.IJ_DATA);
                break;
            }
            case JS: {
                call = IncrementalDomRuntime.SOY_IDOM_CALL_DYNAMIC_JS.call(idomRenderer, callee.objectStyle(), objToPass.get(), JsRuntime.IJ_DATA);
                break;
            }
            case URI: 
            case TEXT: 
            case HTML_ATTRIBUTE_NAME: 
            case HTML_NORMAL_ATTR_VALUE: {
                Expression textCall = !kind.isPresent() || kind.get() == SanitizedContentKind.ATTRIBUTES || kind.get().isHtml() ? (node instanceof CallBasicNode && ((CallBasicNode)node).getVariantExpr() != null ? IncrementalDomRuntime.SOY_IDOM_CALL_DYNAMIC_TEXT.call(callee.objectStyle(), objToPass.get(), JsRuntime.IJ_DATA, (Expression)this.getExprTranslator().exec(((CallBasicNode)node).getVariantExpr().getRoot())) : IncrementalDomRuntime.SOY_IDOM_CALL_DYNAMIC_TEXT.call(callee.objectStyle(), objToPass.get(), JsRuntime.IJ_DATA)) : GenIncrementalDomTemplateBodyVisitor.directCall(callee, node, this.getExprTranslator(), positionalParameters, objToPass, null);
                Statement callStatement = this.outputVars.addChunkToOutputVar(GenCallCodeUtils.applyEscapingDirectives(textCall, node));
                statements.add(node.isErrorFallbackSkip() ? TryCatch.create(Statements.of(callStatement, idomRenderer.dotAccess("replayOn").call(IncrementalDomRuntime.INCREMENTAL_DOM).asStatement())) : callStatement);
                return Statements.of(statements);
            }
            default: {
                if (!kind.isPresent() || !kind.get().isHtml()) {
                    call = node instanceof CallBasicNode && ((CallBasicNode)node).getVariantExpr() != null ? IncrementalDomRuntime.SOY_IDOM_CALL_DYNAMIC_HTML.call(idomRenderer, callee.objectStyle(), objToPass.get(), JsRuntime.IJ_DATA, (Expression)this.getExprTranslator().exec(((CallBasicNode)node).getVariantExpr().getRoot())) : IncrementalDomRuntime.SOY_IDOM_CALL_DYNAMIC_HTML.call(idomRenderer, callee.objectStyle(), objToPass.get(), JsRuntime.IJ_DATA);
                    shouldPushKey = true;
                    break;
                }
                call = GenIncrementalDomTemplateBodyVisitor.directCall(callee, node, this.getExprTranslator(), positionalParameters, objToPass, idomRenderer);
                shouldPushKey = true;
            }
        }
        SoyNode.RenderUnitNode renderUnitNode = node.getNearestAncestor(SoyNode.RenderUnitNode.class);
        boolean delegatesToTemplate = false;
        if (renderUnitNode instanceof TemplateNode) {
            TemplateNode template = (TemplateNode)renderUnitNode;
            boolean bl = delegatesToTemplate = template.getHtmlElementMetadata().getIsHtmlElement() && !template.getHtmlElementMetadata().getFinalCallee().isEmpty();
        }
        if (shouldPushKey) {
            if (node.getKeyExpr() != null) {
                statements.add(IncrementalDomRuntime.INCREMENTAL_DOM_PUSH_MANUAL_KEY.call(this.translateExpr(node.getKeyExpr())).asStatement());
            } else if (!delegatesToTemplate) {
                statements.add(IncrementalDomRuntime.INCREMENTAL_DOM_PUSH_KEY.call(JsRuntime.XID.call(Expressions.stringLiteral(node.getTemplateCallKey()))).asStatement());
            }
        }
        Statement callStatement = node.getHtmlContext() == HtmlContext.JS ? this.outputVars.addChunkToOutputVar(call) : call.asStatement();
        statements.add(node.isErrorFallbackSkip() ? TryCatch.create(Statements.of(callStatement, idomRenderer.dotAccess("replayOn").call(IncrementalDomRuntime.INCREMENTAL_DOM).asStatement())) : callStatement);
        if (shouldPushKey) {
            if (node.getKeyExpr() != null) {
                statements.add(IncrementalDomRuntime.INCREMENTAL_DOM_POP_MANUAL_KEY.call(new Expression[0]).asStatement());
            } else if (!delegatesToTemplate) {
                statements.add(IncrementalDomRuntime.INCREMENTAL_DOM_POP_KEY.call(new Expression[0]).asStatement());
            }
        }
        return Statements.of(statements);
    }

    private static Expression directCall(GenCallCodeUtils.Callee callee, CallNode callNode, TranslateExprNodeVisitor exprTranslator, Optional<Supplier<List<Expression>>> positionalParameters, Supplier<Expression> paramObject, @Nullable Expression rendererParam) {
        ArrayList<Expression> params = new ArrayList<Expression>();
        if (rendererParam != null) {
            params.add(rendererParam);
        }
        if (positionalParameters.isPresent()) {
            params.add(0, JsRuntime.IJ_DATA);
            params.add(0, JsRuntime.SOY_INTERNAL_CALL_MARKER);
            params.addAll((Collection<Expression>)positionalParameters.get().get());
            GenCallCodeUtils.maybeAddVariantParam(callNode, exprTranslator, params);
            return callee.positionalStyle().get().call(params);
        }
        params.add(paramObject.get());
        params.add(JsRuntime.IJ_DATA);
        GenCallCodeUtils.maybeAddVariantParam(callNode, exprTranslator, params);
        return callee.objectStyle().call(params);
    }

    @Override
    protected Statement visitIfNode(IfNode node) {
        if (!GenIncrementalDomTemplateBodyVisitor.isTextContent(this.contentKind.peek())) {
            return super.generateNonExpressionIfNode(node);
        }
        return super.visitIfNode(node);
    }

    @Override
    protected Statement visitForNode(ForNode node) {
        Statement ret = super.visitForNode(node);
        return ret;
    }

    @Override
    protected Statement visitSwitchNode(SwitchNode node) {
        Statement ret = super.visitSwitchNode(node);
        return ret;
    }

    @Override
    protected Statement visitSwitchCaseNode(SwitchCaseNode node) {
        return (Statement)super.visitSwitchCaseNode(node);
    }

    @Override
    protected Statement visitSwitchDefaultNode(SwitchDefaultNode node) {
        return super.visitSwitchDefaultNode(node);
    }

    private static boolean isTextContent(SanitizedContentKind contentKind) {
        return !contentKind.isHtml() && contentKind != SanitizedContentKind.ATTRIBUTES;
    }

    @Override
    protected TranslateExprNodeVisitor getExprTranslator() {
        return new IncrementalDomTranslateExprNodeVisitor(this.javaScriptValueFactory, this.templateTranslationContext, this.templateAliases, this.errorReporter, JsRuntime.OPT_DATA);
    }

    @Override
    protected Statement visitHtmlCommentNode(HtmlCommentNode node) {
        ArrayList<Statement> statements = new ArrayList<Statement>();
        String id = "html_comment_" + node.getId();
        statements.add(VariableDeclaration.builder(id).setMutable().setRhs(Expressions.LITERAL_EMPTY_STRING).build());
        this.outputVars.pushOutputVar(id);
        this.outputVars.setOutputVarInited();
        this.contentKind.push(SanitizedContentKind.TEXT);
        for (int i = 0; i < node.numChildren(); ++i) {
            statements.add(this.visit((SoyNode)node.getChild(i)));
        }
        statements.add(IncrementalDomRuntime.INCREMENTAL_DOM_VISIT_HTML_COMMENT.call(Expressions.id(id)).asStatement());
        this.outputVars.popOutputVar();
        this.contentKind.pop();
        return Statements.of(statements);
    }

    @Override
    protected Statement visitHtmlAttributeNode(HtmlAttributeNode node) {
        if (node.hasValue()) {
            Preconditions.checkState((boolean)((Boolean)this.isComputableAsJsExprsVisitor.exec(node.getChild(0))));
            return this.maybeLoggingFunctionAttrExpr(node).orElse(IncrementalDomRuntime.INCREMENTAL_DOM_ATTR.call(this.genJsExprsVisitor.exec((SoyNode)node.getChild(0)).get(0), Expressions.concatForceString(this.getAttributeValues(node))).asStatement());
        }
        return Statements.of(this.visitChildren(node));
    }

    Optional<Statement> maybeLoggingFunctionAttrExpr(HtmlAttributeNode node) {
        FunctionNode func;
        PrintNode printNode;
        HtmlAttributeValueNode attrValue;
        if (node.hasValue() && node.getChild(1) instanceof HtmlAttributeValueNode && (attrValue = (HtmlAttributeValueNode)node.getChild(1)).numChildren() == 1 && attrValue.getChild(0) instanceof PrintNode && (printNode = (PrintNode)attrValue.getChild(0)).getExpr().getRoot() instanceof FunctionNode && (func = (FunctionNode)printNode.getExpr().getRoot()).getSoyFunction() instanceof LoggingFunction) {
            LoggingFunction loggingNode = (LoggingFunction)func.getSoyFunction();
            return Optional.of(IncrementalDomRuntime.INCREMENTAL_DOM_LOGGING_FUNCTION_ATTR.call(this.genJsExprsVisitor.exec((SoyNode)node.getChild(0)).get(0), JsRuntime.XID.call(Expressions.stringLiteral(func.getStaticFunctionName())), Expressions.arrayLiteral((Iterable)func.getParams().stream().map(n -> (Expression)this.getExprTranslator().exec(n)).collect(ImmutableList.toImmutableList())), Expressions.stringLiteral(loggingNode.getPlaceholder())).asStatement());
        }
        return Optional.empty();
    }

    @Override
    protected Statement visitHtmlAttributeValueNode(HtmlAttributeValueNode node) {
        return Statements.of(this.visitChildren(node));
    }

    private List<Expression> getAttributeValues(HtmlAttributeNode node) {
        if (!node.hasValue()) {
            return ImmutableList.of((Object)Expressions.LITERAL_EMPTY_STRING);
        }
        SoyNode.ParentSoyNode value = (SoyNode.ParentSoyNode)node.getChild(1);
        String outputVar = "html_attribute_" + node.getId();
        boolean needsToBeCoerced = false;
        for (SoyNode n : value.getChildren()) {
            if (!(n instanceof CallNode)) continue;
            Optional<SanitizedContentKind> kind = Metadata.getCallContentKind(this.fileSetMetadata, (CallNode)n);
            needsToBeCoerced = !kind.isPresent() || kind.get().isHtml() || kind.get() == SanitizedContentKind.ATTRIBUTES;
        }
        if (!this.isComputableAsJsExprsVisitor.execOnChildren(value).booleanValue() || needsToBeCoerced) {
            this.outputVars.pushOutputVar(outputVar);
            this.outputVars.setOutputVarInited();
            this.contentKind.push(SanitizedContentKind.TEXT);
            VariableDeclaration decl = VariableDeclaration.builder(outputVar).setMutable().setRhs(Expressions.LITERAL_EMPTY_STRING).build();
            Statement statement = this.visit(value);
            this.outputVars.popOutputVar();
            this.contentKind.pop();
            return ImmutableList.of((Object)decl.ref().withInitialStatements((Iterable<? extends Statement>)ImmutableList.of((Object)decl, (Object)statement)));
        }
        return this.genJsExprsVisitor.exec(value);
    }

    private ImmutableMap<String, Expression> getStaticAttributes(HtmlOpenTagNode node) {
        ArrayList<HtmlAttributeNode> nodesToRemove = new ArrayList<HtmlAttributeNode>();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (int i = 1; i < node.numChildren(); ++i) {
            if (!(node.getChild(i) instanceof HtmlAttributeNode)) continue;
            HtmlAttributeNode attrNode = (HtmlAttributeNode)node.getChild(i);
            String attributeKey = attrNode.getStaticKey();
            Expression value = this.getStaticContent(attrNode);
            if (attributeKey == null || value == null) continue;
            nodesToRemove.add(attrNode);
            builder.put((Object)attributeKey, (Object)value);
        }
        for (HtmlAttributeNode child : nodesToRemove) {
            node.removeChild(child);
        }
        return builder.build();
    }

    @Nullable
    private Expression getStaticContent(HtmlAttributeNode node) {
        if (!node.hasValue()) {
            return Expressions.stringLiteral("");
        }
        if (!(node.getChild(1) instanceof HtmlAttributeValueNode)) {
            return null;
        }
        HtmlAttributeValueNode attrValue = (HtmlAttributeValueNode)node.getChild(1);
        if (attrValue.numChildren() == 0) {
            return Expressions.stringLiteral("");
        }
        for (int i = 0; i < attrValue.numChildren(); ++i) {
            if (attrValue.getChild(i) instanceof RawTextNode) continue;
            if (attrValue.getChild(i) instanceof PrintNode) {
                PrintNode n = (PrintNode)attrValue.getChild(i);
                if (n.getExpr().getRoot() instanceof FunctionNode) {
                    FunctionNode fnNode = (FunctionNode)n.getExpr().getRoot();
                    if (fnNode.getSoyFunction() == BuiltinFunction.XID || fnNode.getSoyFunction() == BuiltinFunction.CSS && fnNode.numParams() == 1) continue;
                    return null;
                }
                return null;
            }
            return null;
        }
        return Expressions.concatForceString(this.getAttributeValues(node));
    }

    private Expression getMaybeSkip(HtmlOpenTagNode node, Statement continueStatements) {
        ArrayList<Expression> args = new ArrayList<Expression>();
        if (node.isElementRoot() && !node.isSkipChildrenRoot()) {
            Expression paramsObject = this.generatePositionalParamsSignature ? Expressions.arrayLiteral((Iterable)node.getNearestAncestor(TemplateNode.class).getParams().stream().map(p -> Expressions.id(GenJsCodeVisitor.genParamAlias(p.name()))).collect(ImmutableList.toImmutableList())) : JsRuntime.OPT_DATA;
            args.add(Expressions.ifExpression(JsRuntime.GOOG_DEBUG, paramsObject).setElse(Expressions.LITERAL_UNDEFINED).build(this.templateTranslationContext.codeGenerator()));
        } else {
            args.add(Expressions.LITERAL_UNDEFINED);
        }
        args.add(JsArrowFunction.create(JsDoc.builder().addParam("idomRenderer", "incrementaldomlib.IncrementalDomRenderer").build(), continueStatements));
        return IncrementalDomRuntime.INCREMENTAL_DOM_KEEP_GOING.call(args);
    }

    private Expression getOpenCall(HtmlOpenTagNode node) {
        ArrayList<Expression> args = new ArrayList<Expression>();
        args.add(this.getTagNameCodeChunk(node.getTagName()));
        KeyNode keyNode = node.getKeyNode();
        Expression key = Expressions.LITERAL_UNDEFINED;
        if (keyNode == null) {
            key = JsRuntime.XID.call(Expressions.stringLiteral(node.getKeyId()));
        } else if (node.isSkipRoot() || node.isSkipChildrenRoot()) {
            key = this.translateExpr(node.getKeyNode().getExpr());
        }
        args.add(key);
        Expression openCall = node.isDynamic() ? IncrementalDomRuntime.INCREMENTAL_DOM_OPEN : IncrementalDomRuntime.INCREMENTAL_DOM_OPEN_SIMPLE;
        return openCall.call(args);
    }

    private Optional<Expression> getApplyStaticAttributes(Map<String, Expression> staticAttributes) {
        ImmutableList.Builder staticsBuilder = ImmutableList.builder();
        for (Map.Entry<String, Expression> entry : staticAttributes.entrySet()) {
            staticsBuilder.add((Object)Expressions.stringLiteral(entry.getKey()));
            staticsBuilder.add((Object)entry.getValue());
        }
        if (!staticAttributes.isEmpty()) {
            String id = "_statics_" + this.alias + this.staticsCounter++;
            Expression idExpr = Expressions.id(this.alias + id);
            Expression lazyAssignment = idExpr.or(idExpr.assign(Expressions.arrayLiteral((Iterable<? extends Expression>)staticsBuilder.build())), null);
            this.staticVarDeclarations.add(VariableDeclaration.builder(this.alias + id).build());
            return Optional.of(IncrementalDomRuntime.INCREMENTAL_DOM_APPLY_STATICS.call(lazyAssignment));
        }
        return Optional.empty();
    }

    private Expression getApplyAttrs(HtmlOpenTagNode node) {
        ArrayList<Statement> statements = new ArrayList<Statement>();
        for (int i = 1; i < node.numChildren(); ++i) {
            statements.add(this.visit((SoyNode)node.getChild(i)));
        }
        return IncrementalDomRuntime.INCREMENTAL_DOM_APPLY_ATTRS.call(new Expression[0]).withInitialStatements(statements);
    }

    @Override
    protected Statement visitHtmlOpenTagNode(HtmlOpenTagNode node) {
        ArrayList<Statement> statements = new ArrayList<Statement>();
        String tagName = node.getTagName().getTagString();
        if (tagName != null && Ascii.equalsIgnoreCase((CharSequence)tagName, (CharSequence)"script")) {
            this.scriptOutputVar = "script_" + this.staticsCounter++;
            this.outputVars.pushOutputVar(this.scriptOutputVar);
            this.outputVars.setOutputVarInited();
            statements.add(VariableDeclaration.builder(this.scriptOutputVar).setMutable().setRhs(Expressions.LITERAL_EMPTY_STRING).build());
            this.contentKind.push(SanitizedContentKind.JS);
        }
        if (node.isSkipRoot()) {
            return Statements.of(statements);
        }
        statements.add(LineComment.create(node.getSourceLocation().toString()).asStatement());
        if (node.getKeyNode() != null) {
            Expression key = this.translateExpr(node.getKeyNode().getExpr());
            statements.add(IncrementalDomRuntime.INCREMENTAL_DOM_PUSH_MANUAL_KEY.call(key).asStatement());
        }
        Expression openTagExpr = this.getOpenCall(node);
        statements.add(openTagExpr.asStatement());
        statements.add(this.getAttributes(node));
        this.getClose(node).ifPresent(statements::add);
        return Statements.of(statements);
    }

    private Optional<Statement> getClose(HtmlOpenTagNode node) {
        boolean isSelfClosing;
        Expression close = node.isElementRoot() ? IncrementalDomRuntime.INCREMENTAL_DOM_ELEMENT_CLOSE : IncrementalDomRuntime.INCREMENTAL_DOM_CLOSE;
        boolean bl = isSelfClosing = node.isSelfClosing() || node.getTagName().isDefinitelyVoid();
        if (isSelfClosing) {
            return Optional.of(close.call(new Expression[0]).asStatement());
        }
        return Optional.empty();
    }

    private Statement getAttributes(HtmlOpenTagNode node) {
        ArrayList<Statement> statements = new ArrayList<Statement>();
        ImmutableMap<String, Expression> staticAttributes = this.getStaticAttributes(node);
        Optional<Expression> maybeApplyStatics = this.getApplyStaticAttributes((Map<String, Expression>)staticAttributes);
        if (maybeApplyStatics.isPresent()) {
            statements.add(maybeApplyStatics.get().asStatement());
        }
        statements.add(this.getApplyAttrs(node).asStatement());
        return Statements.of(statements);
    }

    @Override
    protected Statement visitHtmlCloseTagNode(HtmlCloseTagNode node) {
        HtmlOpenTagNode openTag;
        ArrayList<Statement> statements = new ArrayList<Statement>();
        statements.add(LineComment.create(node.getSourceLocation().toString()).asStatement());
        String tagName = node.getTagName().getTagString();
        if (tagName != null && Ascii.equalsIgnoreCase((CharSequence)tagName, (CharSequence)"script")) {
            this.outputVars.popOutputVar();
            Expression ordainer = Expressions.id("soy").dotAccess("VERY_UNSAFE").dotAccess("ordainSanitizedJs");
            Expression safeScript = ordainer.call(Expressions.id(this.scriptOutputVar)).dotAccess("toSafeScript").call(new Expression[0]);
            GoogRequire require = GoogRequire.create("safevalues");
            Expression unwrapped = require.dotAccess("unwrapScript").call(safeScript);
            Expression currentElement = IncrementalDomRuntime.INCREMENTAL_DOM.dotAccess("currentElement").call(new Expression[0]);
            Expression textContentAssignment = currentElement.dotAccess("textContent").assign(unwrapped);
            ConditionalBuilder ifCurrentElementExists = Statements.ifStatement(currentElement, textContentAssignment.asStatement());
            statements.add(ifCurrentElementExists.build());
            statements.add(IncrementalDomRuntime.INCREMENTAL_DOM.dotAccess("skipNode").call(new Expression[0]).asStatement());
            if (!this.contentKind.peek().isHtml()) {
                this.contentKind.pop();
                Preconditions.checkState((boolean)this.contentKind.peek().isHtml(), (String)"unexpected contentKind: %s", this.contentKind);
            }
        }
        if (node.getTaggedPairs().size() == 1 && (openTag = (HtmlOpenTagNode)node.getTaggedPairs().get(0)).getKeyNode() != null && !(openTag.getParent() instanceof SkipNode)) {
            statements.add(IncrementalDomRuntime.INCREMENTAL_DOM_POP_MANUAL_KEY.call(new Expression[0]).asStatement());
        }
        Expression close = IncrementalDomRuntime.INCREMENTAL_DOM_CLOSE;
        if (node.getTaggedPairs().size() == 1 && ((HtmlOpenTagNode)node.getTaggedPairs().get(0)).isElementRoot()) {
            close = IncrementalDomRuntime.INCREMENTAL_DOM_ELEMENT_CLOSE;
        }
        if (!node.getTagName().isDefinitelyVoid()) {
            statements.add(close.call(new Expression[0]).asStatement());
        }
        return Statements.of(statements);
    }

    @Override
    protected Statement visitRawTextNode(RawTextNode node) {
        Expression textArg = Expressions.stringLiteral(node.getRawText());
        switch (node.getHtmlContext()) {
            case CSS: 
            case HTML_RCDATA: 
            case HTML_PCDATA: {
                return IncrementalDomRuntime.INCREMENTAL_DOM_TEXT.call(textArg).asStatement();
            }
            case HTML_TAG: {
                return IncrementalDomRuntime.INCREMENTAL_DOM_ATTR.call(textArg, Expressions.stringLiteral("")).asStatement();
            }
        }
        return this.outputVars.addChunkToOutputVar(textArg);
    }

    @Override
    protected Statement visitPrintNode(PrintNode node) {
        List<Expression> chunks = this.genJsExprsVisitor.exec(node);
        switch (node.getHtmlContext()) {
            case HTML_TAG: {
                return IncrementalDomRuntime.SOY_IDOM_PRINT_DYNAMIC_ATTR.call(IncrementalDomRuntime.INCREMENTAL_DOM, Expressions.concat(chunks)).asStatement();
            }
            case JS: {
                return this.outputVars.addChunkToOutputVar(Expressions.concat(chunks));
            }
            case CSS: 
            case HTML_PCDATA: {
                if (node.numChildren() > 0 && ((PrintDirectiveNode)node.getChild(node.numChildren() - 1)).getPrintDirective() instanceof SanitizedContentOperator && ((SanitizedContentOperator)((Object)((PrintDirectiveNode)node.getChild(node.numChildren() - 1)).getPrintDirective())).getContentKind() == SanitizedContent.ContentKind.HTML) {
                    return IncrementalDomRuntime.INCREMENTAL_DOM_PRINT.call(Expressions.concat(chunks), Expressions.LITERAL_TRUE).asStatement();
                }
                return IncrementalDomRuntime.INCREMENTAL_DOM_PRINT.call(Expressions.concat(chunks)).asStatement();
            }
            case HTML_RCDATA: {
                return IncrementalDomRuntime.INCREMENTAL_DOM_TEXT.call(Expressions.id("String").call(Expressions.concat(chunks))).asStatement();
            }
        }
        return super.visitPrintNode(node);
    }

    @Override
    protected Statement visitSkipNode(SkipNode node) {
        Optional<Statement> maybeClose;
        ImmutableList.Builder statements = new ImmutableList.Builder();
        HtmlOpenTagNode openTag = (HtmlOpenTagNode)node.getChild(0);
        statements.add((Object)this.getOpenCall(openTag).asStatement());
        Statement attributes = this.getAttributes(openTag);
        if (node.skipOnlyChildren()) {
            statements.add((Object)attributes);
        }
        Statement childStatements = (maybeClose = this.getClose(openTag)).isPresent() ? Statements.of(Statements.of(this.visitChildren(node)), maybeClose.get()) : Statements.of(this.visitChildren(node));
        Expression maybeSkip = this.getMaybeSkip(openTag, node.skipOnlyChildren() ? childStatements : Statements.of(attributes, childStatements));
        statements.add((Object)maybeSkip.asStatement());
        return Statements.of((Iterable<Statement>)statements.build());
    }

    @Override
    protected Statement visitVeLogNode(VeLogNode node) {
        ArrayList<Statement> statements = new ArrayList<Statement>();
        VeLogStateHolder state = this.openVeLogNode(node);
        statements.add(state.enterStatement);
        statements.addAll(this.visitChildren(node));
        statements.add(this.exitVeLogNode(node, state.logOnlyConditional));
        return Statements.of(statements);
    }

    VeLogStateHolder openVeLogNode(VeLogNode node) {
        Expression isLogOnly = Expressions.LITERAL_FALSE;
        Expression isLogOnlyReference = null;
        ArrayList<Statement> stmts = new ArrayList<Statement>();
        if (node.getLogonlyExpression() != null) {
            String idName = "velog_" + this.staticsCounter++;
            isLogOnlyReference = Expressions.id(idName);
            isLogOnly = (Expression)this.getExprTranslator().exec(node.getLogonlyExpression());
            VariableDeclaration isLogOnlyVar = VariableDeclaration.builder(idName).setRhs(isLogOnly).build();
            stmts.add(isLogOnlyVar);
            stmts.add(Statements.ifStatement(IncrementalDomRuntime.INCREMENTAL_DOM_VERIFY_LOGONLY.call(isLogOnlyVar.ref()), Statements.assign(IncrementalDomRuntime.INCREMENTAL_DOM, IncrementalDomRuntime.INCREMENTAL_DOM_TONULL.call(new Expression[0]))).build());
        }
        Expression veData = (Expression)this.getExprTranslator().exec(node.getVeDataExpression());
        stmts.add(IncrementalDomRuntime.INCREMENTAL_DOM_ENTER.call(veData, isLogOnly).asStatement());
        return new VeLogStateHolder(isLogOnlyReference, Statements.of(stmts));
    }

    Statement exitVeLogNode(VeLogNode node, @Nullable Expression isLogOnly) {
        Statement exit = IncrementalDomRuntime.INCREMENTAL_DOM_EXIT.call(new Expression[0]).asStatement();
        if (isLogOnly != null) {
            return Statements.of(exit, Statements.ifStatement(isLogOnly, Statements.assign(IncrementalDomRuntime.INCREMENTAL_DOM, IncrementalDomRuntime.INCREMENTAL_DOM_TODEFAULT.call(new Expression[0]))).build());
        }
        return exit;
    }

    @Override
    protected Statement visitMsgFallbackGroupNode(MsgFallbackGroupNode node) {
        switch (node.getHtmlContext()) {
            case HTML_PCDATA: {
                String id = "_msg_" + this.alias + "_" + this.staticsCounter++;
                VariableDeclaration staticDecl = VariableDeclaration.builder(id).setRhs(Expressions.objectLiteral((Map<String, Expression>)ImmutableMap.of())).build();
                this.staticVarDeclarations.add(staticDecl);
                return new AssistantForHtmlMsgs(this, this.jsSrcOptions, this.genCallCodeUtils, this.isComputableAsJsExprsVisitor, this.templateAliases, this.genJsExprsVisitor, this.templateTranslationContext, this.errorReporter, id, this.outputVars).generateMsgGroupCode(node);
            }
            case HTML_NORMAL_ATTR_VALUE: {
                Expression msgExpression = new AssistantForAttributeMsgs(this, this.jsSrcOptions, this.genCallCodeUtils, this.isComputableAsJsExprsVisitor, this.templateAliases, this.genJsExprsVisitor, this.templateTranslationContext, this.errorReporter, this.outputVars).generateMsgGroupVariable(node);
                return this.outputVars.addChunkToOutputVar(JsRuntime.GOOG_STRING_UNESCAPE_ENTITIES.call(msgExpression));
            }
            case CSS: 
            case HTML_RCDATA: {
                Expression msgExpression = this.getAssistantForMsgs().generateMsgGroupVariable(node);
                return IncrementalDomRuntime.INCREMENTAL_DOM_TEXT.call(Expressions.id("String").call(msgExpression)).asStatement();
            }
        }
        Expression msgExpression = this.getAssistantForMsgs().generateMsgGroupVariable(node);
        return this.outputVars.addChunkToOutputVar(msgExpression);
    }

    @Override
    protected Statement visitMsgHtmlTagNode(MsgHtmlTagNode node) {
        return Statements.of(this.visitChildren(node));
    }

    private Expression getTagNameCodeChunk(TagName tagName) {
        return this.genJsExprsVisitor.exec(tagName.getNode()).get(0);
    }

    private static final class AssistantForAttributeMsgs
    extends GenJsCodeVisitorAssistantForMsgs {
        AssistantForAttributeMsgs(GenIncrementalDomTemplateBodyVisitor master, SoyJsSrcOptions jsSrcOptions, GenCallCodeUtils genCallCodeUtils, IsComputableAsJsExprsVisitor isComputableAsJsExprsVisitor, TemplateAliases functionAliases, GenJsExprsVisitor genJsExprsVisitor, TranslationContext translationContext, ErrorReporter errorReporter, OutputVarHandler outputVars) {
            super(master, jsSrcOptions, genCallCodeUtils, isComputableAsJsExprsVisitor, functionAliases, genJsExprsVisitor, translationContext, errorReporter, outputVars);
        }

        @Override
        protected Expression genGoogMsgPlaceholder(MsgPlaceholderNode msgPhNode) {
            Expression toEscape = super.genGoogMsgPlaceholder(msgPhNode);
            return JsRuntime.SOY_ESCAPE_HTML.call(toEscape);
        }
    }

    static class VeLogStateHolder {
        Expression logOnlyConditional;
        Statement enterStatement;

        public VeLogStateHolder(Expression logOnlyConditional, Statement enterStatement) {
            this.logOnlyConditional = logOnlyConditional;
            this.enterStatement = enterStatement;
        }
    }
}

