/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.javagencode;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Utf8;
import com.google.protobuf.Message;
import com.google.template.soy.base.SourceFilePath;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.IndentedLinesBuilder;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.defn.TemplateParam;
import com.google.template.soy.types.TemplateType;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class KytheHelper {
    private final String kytheCorpus;
    private final SourceFilePath sourceFilePath;

    public KytheHelper(SourceFilePath sourceFilePath) {
        this("", sourceFilePath);
    }

    public KytheHelper(String kytheCorpus, SourceFilePath sourceFilePath) {
        this.kytheCorpus = kytheCorpus;
        this.sourceFilePath = (SourceFilePath)Preconditions.checkNotNull((Object)sourceFilePath);
    }

    @Nullable
    public Message getGeneratedCodeInfo() {
        return null;
    }

    public void addKytheLinkTo(SourceLocation.ByteSpan classNameSpan, SoyFileNode file) {
    }

    public void addKytheLinkTo(SourceLocation.ByteSpan templateNameSpan, TemplateNode template) {
        this.addKytheLinkTo(templateNameSpan, template.getTemplateNameLocation(), template);
    }

    private void addKytheLinkTo(SourceLocation.ByteSpan templateNameSpan, SourceLocation sourceLocation, TemplateNode template) {
    }

    public void addKytheLinkTo(SourceLocation.ByteSpan paramSpan, TemplateType.Parameter paramInfo, TemplateNode template) {
        this.addKytheLinkTo(paramSpan, template.getTemplateNameLocation(), template, paramInfo.getName());
    }

    public void addKytheLinkTo(SourceLocation.ByteSpan paramSpan, TemplateNode template, TemplateParam param) {
        this.addKytheLinkTo(paramSpan, param.nameLocation(), template, param.name());
    }

    public void addKytheLinkTo(int sourceStart, int sourceEnd, int targetStart, int targetEnd) {
    }

    private void addKytheLinkTo(SourceLocation.ByteSpan paramSpan, SourceLocation location, TemplateNode template, String paramName) {
    }

    public List<SourceLocation.ByteSpan> appendLineStartAndGetSpans(IndentedLinesBuilder ilb, String ... parts) {
        return this.appendAndGetSpans(ilb, false, parts);
    }

    public List<SourceLocation.ByteSpan> appendLineAndGetSpans(IndentedLinesBuilder ilb, String ... parts) {
        return this.appendAndGetSpans(ilb, true, parts);
    }

    private List<SourceLocation.ByteSpan> appendAndGetSpans(IndentedLinesBuilder ilb, boolean fullLine, String ... parts) {
        String line = Joiner.on((String)"").join((Object[])parts);
        if (fullLine) {
            ilb.appendLine(line);
        } else {
            ilb.appendLineStart(line);
        }
        int endingLength = ilb.getByteLength();
        int partStart = endingLength - Utf8.encodedLength((CharSequence)line) - (fullLine ? 1 : 0);
        ArrayList<SourceLocation.ByteSpan> spans = new ArrayList<SourceLocation.ByteSpan>(parts.length);
        for (String part : parts) {
            int partEnd = partStart + Utf8.encodedLength((CharSequence)part);
            spans.add(SourceLocation.ByteSpan.create(partStart, partEnd));
            partStart = partEnd;
        }
        return spans;
    }
}

