/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.javagencode;

import com.google.auto.value.AutoValue;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.template.soy.base.SourceFilePath;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.javagencode.AutoValue_SoyFileNodeTransformer_FileInfo;
import com.google.template.soy.javagencode.AutoValue_SoyFileNodeTransformer_ParamInfo;
import com.google.template.soy.javagencode.AutoValue_SoyFileNodeTransformer_TemplateInfo;
import com.google.template.soy.javagencode.javatypes.JavaType;
import com.google.template.soy.javagencode.javatypes.JavaTypeUtils;
import com.google.template.soy.passes.IndirectParamsCalculator;
import com.google.template.soy.shared.internal.gencode.JavaGenerationUtils;
import com.google.template.soy.soytree.FileSetMetadata;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateMetadata;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.Visibility;
import com.google.template.soy.soytree.defn.TemplateParam;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeRegistry;
import com.google.template.soy.types.SoyTypes;
import com.google.template.soy.types.TemplateType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class SoyFileNodeTransformer {
    public static final ImmutableList<String> RESERVED_IDENTIFIERS = ImmutableList.of((Object)"Builder");
    private static final ImmutableSet<SoyType.Kind> UNSUPPORTED_SOY_TYPES = ImmutableSet.of((Object)((Object)SoyType.Kind.VE), (Object)((Object)SoyType.Kind.VE_DATA));
    private final String javaPackage;
    private final FileSetMetadata registry;

    public SoyFileNodeTransformer(String javaPackage, FileSetMetadata registry) {
        this.javaPackage = javaPackage;
        this.registry = registry;
    }

    public FileInfo transform(SoyFileNode node) {
        String fqClassName = this.javaPackage + "." + SoyFileNodeTransformer.convertSoyFileNameToJavaClassName(node);
        ArrayList<TemplateInfo> templates = new ArrayList<TemplateInfo>();
        HashSet<String> uniqueTemplateClassNames = new HashSet<String>();
        for (TemplateNode template : node.getTemplates()) {
            if (template.getVisibility() != Visibility.PUBLIC || template.getKind() == SoyNode.Kind.TEMPLATE_DELEGATE_NODE) continue;
            String templateClassName = SoyFileNodeTransformer.generateTemplateClassName(template);
            if (!RESERVED_IDENTIFIERS.contains((Object)templateClassName) && uniqueTemplateClassNames.add(templateClassName)) {
                templates.add(this.transform(template, fqClassName + "." + templateClassName));
                continue;
            }
            templates.add(TemplateInfo.error(template, TemplateStatus.NAME_COLLISION));
        }
        return new AutoValue_SoyFileNodeTransformer_FileInfo(node, node.getFilePath(), fqClassName, (ImmutableList<TemplateInfo>)ImmutableList.copyOf(templates));
    }

    private TemplateInfo transform(TemplateNode template, String className) {
        List<ParamInfo> params = this.getAllParams(template);
        return new AutoValue_SoyFileNodeTransformer_TemplateInfo(className, (ImmutableList<ParamInfo>)ImmutableList.copyOf(params), TemplateStatus.HANDLED, template, template.getTemplateNameLocation());
    }

    private List<ParamInfo> getAllParams(TemplateNode template) {
        LinkedHashMap<String, ParamInfo> params = new LinkedHashMap<String, ParamInfo>();
        for (TemplateParam param : template.getAllParams()) {
            if (param.isImplicit()) continue;
            params.put(param.name(), ParamInfo.of(param, ParamStatus.HANDLED));
        }
        this.addIndirectParams(template, params);
        SoyFileNodeTransformer.updateParamStatuses(params);
        SoyFileNodeTransformer.updateParamFutureStatuses(params);
        return ImmutableList.copyOf(params.values());
    }

    private void addIndirectParams(TemplateNode template, Map<String, ParamInfo> params) {
        ImmutableSet directParamNames = ImmutableSet.copyOf(params.keySet());
        IndirectParamsCalculator.IndirectParamsInfo idi = new IndirectParamsCalculator(this.registry).calculateIndirectParams(TemplateMetadata.fromTemplate(template).getTemplateType());
        for (Map.Entry entry : idi.indirectParams.entrySet()) {
            String paramName = (String)entry.getKey();
            if (directParamNames.contains(paramName)) continue;
            TemplateType.Parameter param = (TemplateType.Parameter)entry.getValue();
            Optional<SoyType> superType = JavaTypeUtils.upcastTypesForIndirectParams((Set<SoyType>)idi.indirectParamTypes.get((Object)paramName));
            if (!superType.isPresent()) {
                params.put(paramName, ParamInfo.of(param, ParamStatus.INDIRECT_INCOMPATIBLE_TYPES, true));
                continue;
            }
            if (SoyTypes.hasProtoDep(superType.get())) {
                params.put(paramName, ParamInfo.of(param, ParamStatus.INDIRECT_PROTO, true));
                continue;
            }
            params.put(paramName, ParamInfo.of(param.toBuilder().setType(superType.get()).setDescription(SoyFileNodeTransformer.modifyIndirectDesc(param.getDescription(), (Collection<TemplateMetadata>)idi.paramKeyToCalleesMultimap.get((Object)paramName))).build(), ParamStatus.HANDLED, true));
        }
    }

    private static void updateParamStatuses(Map<String, ParamInfo> params) {
        HashSet<String> setterNames = new HashSet<String>();
        for (Map.Entry<String, ParamInfo> entry : params.entrySet()) {
            String paramName = entry.getKey();
            ParamInfo param = entry.getValue();
            if (JavaTypeUtils.isJavaIncompatible(param.type())) {
                SoyFileNodeTransformer.changeParamStatus(params, paramName, ParamStatus.JAVA_INCOMPATIBLE);
                continue;
            }
            String setterName = SoyFileNodeTransformer.getParamSetterSuffix(paramName);
            if (RESERVED_IDENTIFIERS.contains((Object)paramName) || !setterNames.add(setterName)) {
                SoyFileNodeTransformer.changeParamStatus(params, paramName, ParamStatus.NAME_COLLISION);
                continue;
            }
            if (!param.javaTypes().isEmpty()) continue;
            SoyFileNodeTransformer.changeParamStatus(params, paramName, ParamStatus.UNHANDLED_TYPE);
        }
    }

    private static void updateParamFutureStatuses(Map<String, ParamInfo> params) {
        Set allSetters = params.values().stream().map(ParamInfo::setterName).collect(Collectors.toSet());
        for (Map.Entry<String, ParamInfo> entry : params.entrySet()) {
            String paramName = entry.getKey();
            ParamInfo param = entry.getValue();
            if (param.status() != ParamStatus.HANDLED) continue;
            if (allSetters.contains(param.futureSetterName())) {
                SoyFileNodeTransformer.changeParamFutureStatus(params, paramName, ParamFutureStatus.NAME_COLLISION);
                continue;
            }
            List<JavaType> javaTypes = param.javaTypes();
            if (javaTypes.size() == 1 && javaTypes.get(0).isGenericsTypeSupported()) {
                SoyFileNodeTransformer.changeParamFutureStatus(params, paramName, ParamFutureStatus.HANDLED);
                continue;
            }
            SoyFileNodeTransformer.changeParamFutureStatus(params, paramName, ParamFutureStatus.UNHANDLED);
        }
    }

    private static void changeParamFutureStatus(Map<String, ParamInfo> params, String paramName, ParamFutureStatus futureStatus) {
        ParamInfo previous = params.get(paramName);
        params.put(paramName, ParamInfo.of(previous.param(), previous.status(), previous.indirect(), previous.injected(), futureStatus, previous.sourceLocation()));
    }

    private static void changeParamStatus(Map<String, ParamInfo> params, String paramName, ParamStatus newStatus) {
        ParamInfo previous = params.get(paramName);
        params.put(paramName, ParamInfo.of(previous.param(), newStatus, previous.indirect(), previous.injected(), previous.futureStatus(), previous.sourceLocation()));
    }

    private static String modifyIndirectDesc(String description, Collection<TemplateMetadata> callees) {
        StringBuilder sb = new StringBuilder();
        if (description != null) {
            sb.append(description);
            sb.append(" ");
        }
        sb.append("[From template");
        if (callees.size() > 1) {
            sb.append("s");
        }
        sb.append(": ");
        Joiner.on((String)", ").appendTo(sb, callees.stream().map(TemplateMetadata::getTemplateName).sorted().iterator());
        sb.append("]");
        return sb.toString();
    }

    private static String convertSoyFileNameToJavaClassName(SoyFileNode soyFile) {
        if (soyFile.getFileName() == null) {
            throw new IllegalArgumentException("Trying to generate Java class name based on Soy file name, but Soy file name was not provided.");
        }
        return JavaGenerationUtils.buildTemplatesClassName(soyFile.getFileName());
    }

    private static String generateTemplateClassName(TemplateNode template) {
        return JavaGenerationUtils.buildTemplateClassName(template.getTemplateName());
    }

    private static String getParamSetterSuffix(String paramName) {
        return JavaGenerationUtils.makeUpperCamelCase(paramName);
    }

    @AutoValue
    public static abstract class ParamInfo {
        private int uniqueSerial = 0;

        static ParamInfo of(TemplateParam param, ParamStatus status) {
            return ParamInfo.of(TemplateMetadata.parameterFromTemplateParam(param), status, false, param.isInjected(), ParamFutureStatus.HANDLED, param.getSourceLocation());
        }

        static ParamInfo of(TemplateParam param, ParamStatus status, boolean indirect) {
            return ParamInfo.of(TemplateMetadata.parameterFromTemplateParam(param), status, indirect, param.isInjected(), ParamFutureStatus.HANDLED, param.getSourceLocation());
        }

        static ParamInfo of(TemplateType.Parameter param, ParamStatus status, boolean indirect) {
            return ParamInfo.of(param, status, indirect, false, ParamFutureStatus.HANDLED, SourceLocation.UNKNOWN);
        }

        static ParamInfo of(TemplateType.Parameter param, ParamStatus status, boolean indirect, boolean injected, ParamFutureStatus futureStatus, SourceLocation sourceLocation) {
            return new AutoValue_SoyFileNodeTransformer_ParamInfo(param, status, indirect, injected, futureStatus, sourceLocation);
        }

        public abstract TemplateType.Parameter param();

        public abstract ParamStatus status();

        public abstract boolean indirect();

        public abstract boolean injected();

        public abstract ParamFutureStatus futureStatus();

        public abstract SourceLocation sourceLocation();

        public String name() {
            return this.param().getName();
        }

        public String constantFieldName() {
            String baseName = BaseUtils.convertToUpperUnderscore(this.name());
            return this.uniqueSerial == 0 ? baseName : baseName + "__" + this.uniqueSerial;
        }

        public void updateConstantFieldName() {
            ++this.uniqueSerial;
        }

        public String setterName() {
            return "set" + JavaGenerationUtils.makeUpperCamelCase(this.name());
        }

        public String adderName() {
            return "add" + JavaGenerationUtils.makeUpperCamelCase(this.name());
        }

        public String futureSetterName() {
            Preconditions.checkState((this.futureStatus() == ParamFutureStatus.HANDLED ? 1 : 0) != 0);
            return "set" + JavaGenerationUtils.makeUpperCamelCase(this.name()) + "Future";
        }

        public SoyType type() {
            return this.param().getType();
        }

        public Iterable<JavaType> futureTypes() {
            Preconditions.checkState((this.futureStatus() == ParamFutureStatus.HANDLED ? 1 : 0) != 0);
            return this.javaTypes();
        }

        public List<JavaType> javaTypes() {
            return JavaTypeUtils.getJavaTypes(this.type(), UNSUPPORTED_SOY_TYPES);
        }

        public boolean required() {
            return this.param().isRequired();
        }

        public boolean requiredAndNotIndirect() {
            return this.required() && !this.indirect();
        }
    }

    public static enum ParamFutureStatus {
        HANDLED,
        NAME_COLLISION,
        UNHANDLED;

    }

    public static enum ParamStatus {
        HANDLED,
        NAME_COLLISION,
        INDIRECT_INCOMPATIBLE_TYPES,
        INDIRECT_PROTO,
        UNHANDLED_TYPE,
        JAVA_INCOMPATIBLE;

    }

    @AutoValue
    public static abstract class TemplateInfo {
        static TemplateInfo error(TemplateNode template, TemplateStatus status) {
            return new AutoValue_SoyFileNodeTransformer_TemplateInfo(SoyFileNodeTransformer.generateTemplateClassName(template), (ImmutableList<ParamInfo>)ImmutableList.of(), status, template, template.getTemplateNameLocation());
        }

        public abstract String fqClassName();

        public abstract ImmutableList<ParamInfo> params();

        public abstract TemplateStatus status();

        protected abstract TemplateNode template();

        public abstract SourceLocation sourceLocation();

        public boolean complete() {
            return this.status() == TemplateStatus.HANDLED && this.params().stream().allMatch(p -> p.status() == ParamStatus.HANDLED || p.status() == ParamStatus.JAVA_INCOMPATIBLE);
        }

        public String templateName() {
            return this.template().getTemplateName();
        }

        public String soyDocDesc() {
            return this.template().getSoyDocDesc();
        }

        public String templateNameForUserMsgs() {
            return this.template().getTemplateNameForUserMsgs();
        }

        public String className() {
            String className = this.fqClassName();
            return className.substring(className.lastIndexOf(".") + 1);
        }
    }

    public static enum TemplateStatus {
        HANDLED,
        NAME_COLLISION;

    }

    @AutoValue
    public static abstract class FileInfo {
        abstract SoyFileNode fileNode();

        abstract SourceFilePath soyFilePath();

        public abstract String fqClassName();

        public abstract ImmutableList<TemplateInfo> templates();

        public boolean complete() {
            return this.templates().stream().allMatch(TemplateInfo::complete);
        }

        public String soyFileName() {
            return this.soyFilePath().fileName();
        }

        public String packageName() {
            String className = this.fqClassName();
            return className.substring(0, className.lastIndexOf("."));
        }

        public String className() {
            String className = this.fqClassName();
            return className.substring(className.lastIndexOf(".") + 1);
        }

        public TemplateInfo findTemplate(TemplateNode node) {
            return this.templates().stream().filter(t -> t.template().equals(node)).findFirst().get();
        }

        public Set<String> getProtoTypes(SoyTypeRegistry typeRegistry) {
            return JavaGenerationUtils.getProtoTypes(this.fileNode(), typeRegistry);
        }
    }
}

