/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.javagencode.javatypes;

import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.data.BaseSoyTemplateImpl;
import com.google.template.soy.data.SoyTemplateParam;
import java.lang.reflect.Method;

public final class CodeGenUtils {
    public static final Member SET_PARAM_INTERNAL = MethodImpl.method(BaseSoyTemplateImpl.AbstractBuilder.class, "setParamInternal");
    public static final Member ADD_TO_LIST_PARAM = MethodImpl.method(BaseSoyTemplateImpl.AbstractBuilderWithAccumulatorParameters.class, "addToListParam");
    public static final Member INIT_LIST_PARAM = MethodImpl.method(BaseSoyTemplateImpl.AbstractBuilderWithAccumulatorParameters.class, "initListParam");
    public static final Member AS_RECORD = CodeGenUtils.castFunction("asRecord");
    public static final Member STANDARD_P = MethodImpl.fullyQualifiedMethod(SoyTemplateParam.class, "standard");
    public static final Member INDIRECT_P = MethodImpl.fullyQualifiedMethod(SoyTemplateParam.class, "indirect");
    public static final Member INJECTED_P = MethodImpl.fullyQualifiedMethod(SoyTemplateParam.class, "injected");

    private CodeGenUtils() {
    }

    static Member castFunction(String name) {
        return MethodImpl.method(BaseSoyTemplateImpl.AbstractBuilder.class, name);
    }

    private static Method findAnyMethod(Class<?> type, String methodName) {
        for (Method method : type.getDeclaredMethods()) {
            if (!methodName.equals(method.getName())) continue;
            return method;
        }
        throw new IllegalArgumentException("Can't find a method named: " + methodName + " in: " + String.valueOf(type));
    }

    @Immutable
    private static class MethodImpl
    implements Member {
        private final String name;

        private MethodImpl(Method method, boolean qualified) {
            this.name = (String)(qualified ? method.getDeclaringClass().getName() + "." : "") + method.getName();
        }

        private static MethodImpl method(Class<?> type, String methodName) {
            return new MethodImpl(CodeGenUtils.findAnyMethod(type, methodName), false);
        }

        private static MethodImpl fullyQualifiedMethod(Class<?> type, String methodName) {
            return new MethodImpl(CodeGenUtils.findAnyMethod(type, methodName), true);
        }

        @Override
        public String toString() {
            return this.name;
        }
    }

    @Immutable
    public static interface Member {
        public String toString();
    }
}

