/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.javagencode.javatypes;

import com.google.template.soy.javagencode.javatypes.CodeGenUtils;
import com.google.template.soy.javagencode.javatypes.JavaType;

public class SimpleJavaType
extends JavaType {
    public static final SimpleJavaType BOOLEAN = new PrimitiveJavaType("java.lang.Boolean", "boolean", "java.lang.Boolean", false, CodeGenUtils.castFunction("asBool"), CodeGenUtils.castFunction("asBool"), CodeGenUtils.castFunction("asNullableBool"));
    public static final SimpleJavaType INT = new PrimitiveJavaType("java.lang.Long", "long", "? extends java.lang.Number", false, CodeGenUtils.castFunction("asInt"), CodeGenUtils.castFunction("asBoxedInt"), CodeGenUtils.castFunction("asNullableInt"));
    public static final SimpleJavaType FLOAT = new PrimitiveJavaType("java.lang.Double", "double", "? extends java.lang.Number", false, CodeGenUtils.castFunction("asFloat"), CodeGenUtils.castFunction("asBoxedFloat"), CodeGenUtils.castFunction("asNullableFloat"));
    public static final SimpleJavaType NUMBER = new SimpleJavaType("java.lang.Number", "? extends java.lang.Number", false, CodeGenUtils.castFunction("asNumber"), CodeGenUtils.castFunction("asNullableNumber"));
    public static final SimpleJavaType HTML = new SimpleJavaType("com.google.common.html.types.SafeHtml", CodeGenUtils.castFunction("asHtml"), CodeGenUtils.castFunction("asNullableHtml"));
    public static final SimpleJavaType JS = new SimpleJavaType("com.google.common.html.types.SafeScript", CodeGenUtils.castFunction("asJs"), CodeGenUtils.castFunction("asNullableJs"));
    public static final SimpleJavaType URL = new SimpleJavaType("com.google.common.html.types.SafeUrl", CodeGenUtils.castFunction("asUri"), CodeGenUtils.castFunction("asNullableUri"));
    public static final SimpleJavaType TRUSTED_RESOURCE_URL = new SimpleJavaType("com.google.common.html.types.TrustedResourceUrl", CodeGenUtils.castFunction("asTrustedResourceUri"), CodeGenUtils.castFunction("asNullableTrustedResourceUri"));
    public static final SimpleJavaType STRING = new SimpleJavaType("java.lang.String", CodeGenUtils.castFunction("asString"), CodeGenUtils.castFunction("asNullableString"));
    private static final CodeGenUtils.Member AS_SOY_VALUE = CodeGenUtils.castFunction("asSoyValue");
    public static final SimpleJavaType OBJECT = new SimpleJavaType("java.lang.Object", "?", false, AS_SOY_VALUE, AS_SOY_VALUE);
    public static final SimpleJavaType ATTRIBUTES = new SimpleJavaType("com.google.template.soy.data.SanitizedContent", CodeGenUtils.castFunction("asAttributes"), CodeGenUtils.castFunction("asNullableAttributes"));
    public static final SimpleJavaType CSS = new SimpleJavaType("com.google.template.soy.data.CssParam", CodeGenUtils.castFunction("asCss"), CodeGenUtils.castFunction("asNullableCss"));
    public static final SimpleJavaType MESSAGE = new SimpleJavaType("com.google.protobuf.Message", CodeGenUtils.castFunction("asProto"), CodeGenUtils.castFunction("asNullableProto"));
    private final String javaTypeString;
    private final String genericsTypeArgumentString;
    final CodeGenUtils.Member asReference;
    final CodeGenUtils.Member asNullableReference;

    private SimpleJavaType(String javaTypeString, CodeGenUtils.Member asReference, CodeGenUtils.Member asNullableReference) {
        this(javaTypeString, javaTypeString, false, asReference, asNullableReference);
    }

    private SimpleJavaType(String javaTypeString, String genericsTypeArgumentString, boolean isNullable, CodeGenUtils.Member asReference, CodeGenUtils.Member asNullableReference) {
        super(isNullable);
        this.javaTypeString = javaTypeString;
        this.genericsTypeArgumentString = genericsTypeArgumentString;
        this.asReference = asReference;
        this.asNullableReference = asNullableReference;
    }

    @Override
    public String toJavaTypeString() {
        return this.javaTypeString;
    }

    @Override
    String asGenericsTypeArgumentString() {
        return this.genericsTypeArgumentString;
    }

    @Override
    public SimpleJavaType asNullable() {
        return new SimpleJavaType(this.javaTypeString, this.genericsTypeArgumentString, true, this.asReference, this.asNullableReference);
    }

    @Override
    public String getAsInlineCastFunction(int depth) {
        return "AbstractBuilder::" + String.valueOf(this.getMapperFunction());
    }

    CodeGenUtils.Member getMapperFunction() {
        return this.isNullable() ? this.asNullableReference : this.asReference;
    }

    @Override
    public String asInlineCast(String variable, int depth) {
        return String.valueOf(this.getMapperFunction()) + "(" + variable + ")";
    }

    private static final class PrimitiveJavaType
    extends SimpleJavaType {
        final String primitiveType;
        final String boxedType;
        final String genericType;
        final CodeGenUtils.Member asFunctionBoxed;

        PrimitiveJavaType(String boxedType, String primitiveType, String genericType, boolean isNullable, CodeGenUtils.Member asFunctionUnboxed, CodeGenUtils.Member asFunctionBoxed, CodeGenUtils.Member asNullableFunction) {
            super(isNullable ? boxedType : primitiveType, boxedType, isNullable, asFunctionUnboxed, asNullableFunction);
            this.genericType = genericType;
            this.asFunctionBoxed = asFunctionBoxed;
            this.primitiveType = primitiveType;
            this.boxedType = boxedType;
        }

        @Override
        public String asTypeLiteralString() {
            return this.boxedType;
        }

        @Override
        String asGenericsTypeArgumentString() {
            return this.genericType;
        }

        @Override
        public PrimitiveJavaType asNullable() {
            return new PrimitiveJavaType(this.boxedType, this.primitiveType, this.genericType, true, this.asReference, this.asFunctionBoxed, this.asNullableReference);
        }

        @Override
        public String getAsInlineCastFunction(int depth) {
            return "AbstractBuilder::" + String.valueOf(this.isNullable() ? this.asNullableReference : this.asFunctionBoxed);
        }
    }
}

