/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.io.ByteSink;
import com.google.common.io.ByteSource;
import com.google.template.soy.base.SourceLogicalPath;
import com.google.template.soy.base.internal.SoyFileSupplier;
import com.google.template.soy.base.internal.SoyJarFileWriter;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.internal.exemptions.NamespaceExemptions;
import com.google.template.soy.jbcsrc.CompilingClassLoader;
import com.google.template.soy.jbcsrc.JavaSourceFunctionCompiler;
import com.google.template.soy.jbcsrc.SoyFileCompiler;
import com.google.template.soy.jbcsrc.api.PluginRuntimeInstanceInfo;
import com.google.template.soy.jbcsrc.internal.ClassData;
import com.google.template.soy.jbcsrc.restricted.Flags;
import com.google.template.soy.jbcsrc.shared.CompiledTemplates;
import com.google.template.soy.jbcsrc.shared.Names;
import com.google.template.soy.plugin.java.internal.PluginAnalyzer;
import com.google.template.soy.plugin.java.restricted.SoyJavaSourceFunction;
import com.google.template.soy.soytree.FileSetMetadata;
import com.google.template.soy.soytree.PartialFileSetMetadata;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.TemplateMetadata;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.types.SoyTypeRegistry;
import com.google.template.soy.types.TemplateType;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.TreeMap;
import java.util.TreeSet;

public final class BytecodeCompiler {
    public static Optional<CompiledTemplates> compile(FileSetMetadata registry, SoyFileSetNode fileSet, ErrorReporter reporter, ImmutableMap<SourceLogicalPath, SoyFileSupplier> filePathsToSuppliers, SoyTypeRegistry typeRegistry) {
        ErrorReporter.Checkpoint checkpoint = reporter.checkpoint();
        CompiledTemplates templates = new CompiledTemplates((ImmutableSet<String>)((ImmutableSet)registry.getAllTemplates().stream().filter(BytecodeCompiler::isModTemplate).map(BytecodeCompiler::modImplName).collect(ImmutableSet.toImmutableSet())), new CompilingClassLoader(fileSet, filePathsToSuppliers, typeRegistry, registry));
        if (reporter.errorsSince(checkpoint)) {
            return Optional.empty();
        }
        return Optional.of(templates);
    }

    static boolean isModTemplate(TemplateMetadata template) {
        if (template.getTemplateType().getTemplateKind() == TemplateType.TemplateKind.DELTEMPLATE) {
            return true;
        }
        return template.getTemplateType().isModifiable() || template.getTemplateType().isModifying();
    }

    private static String namespaceFromTemplateName(String templateName) {
        return templateName.substring(0, templateName.lastIndexOf("."));
    }

    private static String modImplName(TemplateMetadata template) {
        return template.getTemplateName() + (!template.getTemplateType().isModifiable() ? "" : (NamespaceExemptions.isKnownDuplicateNamespace(BytecodeCompiler.namespaceFromTemplateName(template.getTemplateName())) ? ".render__modifiable_default_impl__" : "__modifiable_default_impl__"));
    }

    public static void compileToJar(SoyFileSetNode fileSet, ErrorReporter reporter, SoyTypeRegistry typeRegistry, ByteSink sink, PartialFileSetMetadata fileSetMetadata) throws IOException {
        try (final SoyJarFileWriter writer = new SoyJarFileWriter(sink.openStream());){
            final TreeSet modTemplates = new TreeSet();
            final TreeMap mergedInstanceIndex = new TreeMap();
            BytecodeCompiler.compileTemplates(fileSet, reporter, typeRegistry, new CompilerListener<Void, IOException>(){

                @Override
                void onCompile(ClassData clazz) throws IOException {
                    writer.writeEntry(clazz.type().internalName() + ".class", ByteSource.wrap((byte[])clazz.data()));
                }

                @Override
                void onCompileModifiableTemplate(String name) {
                    modTemplates.add(name);
                }

                @Override
                void onFunctionCallFound(FunctionNode fnNode) {
                    ImmutableSet<String> instances;
                    if (fnNode.getSoyFunction() instanceof SoyJavaSourceFunction && !(instances = PluginAnalyzer.analyze((SoyJavaSourceFunction)fnNode.getSoyFunction(), fnNode.numParams()).pluginInstanceNames()).isEmpty()) {
                        mergedInstanceIndex.merge(fnNode.getStaticFunctionName(), PluginRuntimeInstanceInfo.builder().setPluginName(fnNode.getStaticFunctionName()).setInstanceClassName((String)Iterables.getOnlyElement(instances)).addSourceLocation(fnNode.getSourceLocation().toString()).build(), PluginRuntimeInstanceInfo::merge);
                    }
                }
            }, fileSetMetadata);
            if (!modTemplates.isEmpty()) {
                String delData = Joiner.on((char)'\n').join(modTemplates);
                writer.writeEntry("META-INF/services/com.google.template.soy.deltemplates", ByteSource.wrap((byte[])delData.getBytes(StandardCharsets.UTF_8)));
            }
            fileSet.getChildren().stream().flatMap(f -> f.getExterns().stream()).filter(e -> e.getJavaImpl().isPresent()).map(e -> e.getJavaImpl().get()).filter(j -> !j.isStatic()).map(j -> PluginRuntimeInstanceInfo.builder().setPluginName(j.className()).setInstanceClassName(j.className()).addSourceLocation(j.getSourceLocation().toString()).build()).forEach(i -> mergedInstanceIndex.merge(i.pluginName(), i, PluginRuntimeInstanceInfo::merge));
            if (!mergedInstanceIndex.isEmpty()) {
                writer.writeEntry("META-INF/services/com.google.template.soy.plugins", PluginRuntimeInstanceInfo.serialize(mergedInstanceIndex.values()));
            }
        }
    }

    public static void writeSrcJar(SoyFileSetNode soyFileSet, ImmutableMap<SourceLogicalPath, SoyFileSupplier> files, ByteSink sink) throws IOException {
        try (SoyJarFileWriter writer = new SoyJarFileWriter(sink.openStream());){
            for (SoyFileNode file : soyFileSet.getChildren()) {
                String namespace = file.getNamespace();
                String fileName = file.getFileName();
                writer.writeEntry(Names.javaFileName(namespace, fileName), ((SoyFileSupplier)files.get((Object)file.getFilePath().asLogicalPath())).asCharSource().asByteSource(StandardCharsets.UTF_8));
            }
        }
    }

    private static <T, E extends Throwable> T compileTemplates(SoyFileSetNode fileSet, ErrorReporter errorReporter, SoyTypeRegistry typeRegistry, CompilerListener<T, E> listener, PartialFileSetMetadata fileSetMetadata) throws E {
        JavaSourceFunctionCompiler javaSourceFunctionCompiler = new JavaSourceFunctionCompiler(typeRegistry, errorReporter);
        for (SoyFileNode file : fileSet.getChildren()) {
            for (ClassData clazz : new SoyFileCompiler(file, javaSourceFunctionCompiler, fileSetMetadata).compile()) {
                if (Flags.DEBUG) {
                    clazz.checkClass();
                }
                listener.onCompile(clazz);
            }
            for (TemplateNode template : file.getTemplates()) {
                TemplateMetadata metadata = TemplateMetadata.fromTemplate(template);
                if (BytecodeCompiler.isModTemplate(metadata)) {
                    listener.onCompileModifiableTemplate(BytecodeCompiler.modImplName(metadata));
                } else {
                    listener.onCompileTemplate(template.getTemplateName());
                }
                for (FunctionNode fnNode : SoyTreeUtils.getAllNodesOfType(template, FunctionNode.class)) {
                    listener.onFunctionCallFound(fnNode);
                }
            }
        }
        return listener.getResult();
    }

    private BytecodeCompiler() {
    }

    private static abstract class CompilerListener<T, E extends Throwable> {
        private CompilerListener() {
        }

        abstract void onCompile(ClassData var1) throws E;

        void onCompileModifiableTemplate(String name) {
        }

        void onCompileTemplate(String name) {
        }

        void onFunctionCallFound(FunctionNode function) {
        }

        T getResult() {
            return null;
        }
    }
}

