/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.data.LoggingAdvisingAppendable;
import com.google.template.soy.data.RecordProperty;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.internal.ParamStore;
import com.google.template.soy.jbcsrc.restricted.BytecodeUtils;
import com.google.template.soy.jbcsrc.restricted.CodeBuilder;
import com.google.template.soy.jbcsrc.restricted.Expression;
import com.google.template.soy.jbcsrc.restricted.JbcSrcPluginContext;
import com.google.template.soy.jbcsrc.restricted.MethodRef;
import com.google.template.soy.jbcsrc.restricted.MethodRefs;
import com.google.template.soy.jbcsrc.restricted.SoyExpression;
import com.google.template.soy.jbcsrc.restricted.SoyJbcSrcPrintDirective;
import com.google.template.soy.jbcsrc.restricted.Statement;
import com.google.template.soy.jbcsrc.shared.RenderContext;
import com.google.template.soy.shared.restricted.SoyPrintDirective;
import com.google.template.soy.types.UnknownType;
import java.util.List;
import javax.annotation.Nullable;

final class RenderContextExpression
extends Expression
implements JbcSrcPluginContext {
    private static final MethodRef GET_DELTEMPLATE = MethodRef.createNonPure(RenderContext.class, "getDelTemplate", String.class, String.class);
    private static final MethodRef RENDER_MODIFIABLE = MethodRef.createNonPure(RenderContext.class, "renderModifiable", String.class, ParamStore.class, LoggingAdvisingAppendable.class);
    private static final MethodRef GET_PLUGIN_INSTANCE = MethodRef.createNonPure(RenderContext.class, "getPluginInstance", String.class);
    private static final MethodRef GET_LOCALE = MethodRef.createNonPure(RenderContext.class, "getLocale", new Class[0]);
    private static final MethodRef GET_PRINT_DIRECTIVE = MethodRef.createNonPure(RenderContext.class, "getPrintDirective", String.class);
    private static final MethodRef GET_SOY_MSG_PARTS = MethodRef.createNonPure(RenderContext.class, "getSoyMsgParts", Long.TYPE, ImmutableList.class).asNonJavaNullable();
    private static final MethodRef GET_SOY_MSG_PARTS_NO_DEFAULT = MethodRef.createNonPure(RenderContext.class, "getSoyMsgParts", Long.TYPE).asNonJavaNullable();
    private static final MethodRef GET_SOY_MSG_PARTS_WITH_ALTERNATE_ID = MethodRef.createNonPure(RenderContext.class, "getSoyMsgPartsWithAlternateId", Long.TYPE, ImmutableList.class, Long.TYPE).asNonJavaNullable();
    private static final MethodRef GET_SOY_MSG_PARTS_WITH_ALTERNATE_ID_NO_DEFAULT = MethodRef.createNonPure(RenderContext.class, "getSoyMsgPartsWithAlternateId", Long.TYPE, Long.TYPE).asNonJavaNullable();
    private static final MethodRef GET_BASIC_SOY_MSG_PART = MethodRef.createNonPure(RenderContext.class, "getBasicSoyMsgPart", Long.TYPE, String.class).asNonJavaNullable();
    private static final MethodRef GET_BASIC_SOY_MSG_PART_NO_DEFAULT = MethodRef.createNonPure(RenderContext.class, "getBasicSoyMsgPart", Long.TYPE).asNonJavaNullable();
    private static final MethodRef GET_BASIC_SOY_MSG_PART_WITH_ALTERNATE_ID = MethodRef.createNonPure(RenderContext.class, "getBasicSoyMsgPartWithAlternateId", Long.TYPE, String.class, Long.TYPE).asNonJavaNullable();
    private static final MethodRef GET_BASIC_SOY_MSG_PART_NO_DEFAULT_WITH_ALTERNATE_ID = MethodRef.createNonPure(RenderContext.class, "getBasicSoyMsgPartWithAlternateId", Long.TYPE, Long.TYPE).asNonJavaNullable();
    private static final MethodRef RENAME_CSS_SELECTOR = MethodRef.createNonPure(RenderContext.class, "renameCssSelector", String.class).asNonJavaNullable();
    private static final MethodRef EVAL_TOGGLE = MethodRef.createNonPure(RenderContext.class, "evalToggle", String.class);
    private static final MethodRef RENAME_XID = MethodRef.createNonPure(RenderContext.class, "renameXid", String.class).asNonJavaNullable();
    private static final MethodRef USE_PRIMARY_MSG_IF_FALLBACK = MethodRef.createNonPure(RenderContext.class, "usePrimaryMsgIfFallback", Long.TYPE, Long.TYPE);
    private static final MethodRef USE_PRIMARY_OR_ALTERNATE_IF_FALLBACK = MethodRef.createNonPure(RenderContext.class, "usePrimaryOrAlternateIfFallback", Long.TYPE, Long.TYPE, Long.TYPE);
    private static final MethodRef USE_PRIMARY_IF_FALLBACK_OR_FALLBACK_ALTERNATE = MethodRef.createNonPure(RenderContext.class, "usePrimaryIfFallbackOrFallbackAlternate", Long.TYPE, Long.TYPE, Long.TYPE);
    private static final MethodRef USE_PRIMARY_OR_ALTERNATE_IF_FALLBACK_OR_FALLBACK_ALTERNATE = MethodRef.createNonPure(RenderContext.class, "usePrimaryOrAlternateIfFallbackOrFallbackAlternate", Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE);
    private static final MethodRef GET_DEBUG_SOY_TEMPLATE_INFO = MethodRef.createNonPure(RenderContext.class, "getDebugSoyTemplateInfo", new Class[0]);
    private static final MethodRef GET_BIDI_GLOBAL_DIR = MethodRef.createNonPure(RenderContext.class, "getBidiGlobalDir", new Class[0]);
    private static final MethodRef GET_BIDI_GLOBAL_DIR_DIR = MethodRef.createNonPure(RenderContext.class, "getBidiGlobalDirDir", new Class[0]);
    private static final MethodRef GET_ALL_REQUIRED_CSS_NAMESPACES = MethodRef.createNonPure(RenderContext.class, "getAllRequiredCssNamespaces", String.class);
    private static final MethodRef GET_ALL_REQUIRED_CSS_PATHS = MethodRef.createNonPure(RenderContext.class, "getAllRequiredCssPaths", String.class);
    private static final MethodRef GET_ESCAPING_DIRECTIVE_AS_FUNCTION = MethodRef.createNonPure(RenderContext.class, "getEscapingDirectiveAsFunction", String.class);
    private static final MethodRef HAS_LOGGER = MethodRef.createNonPure(RenderContext.class, "hasLogger", new Class[0]).asCheap();
    private static final MethodRef GET_LOGGER = MethodRef.createNonPure(RenderContext.class, "getLogger", new Class[0]);
    private static final MethodRef POP_FRAME = MethodRef.createNonPure(RenderContext.class, "popFrame", new Class[0]);
    private static final MethodRef GET_RENDER_CSS_HELPER = MethodRef.createNonPure(RenderContext.class, "getRenderCssHelper", new Class[0]);
    private static final MethodRef GET_CONST = MethodRef.createNonPure(RenderContext.class, "getConst", String.class);
    private static final MethodRef STORE_CONST = MethodRef.createNonPure(RenderContext.class, "storeConst", String.class, Object.class);
    private static final MethodRef TRACK_REQUIRED_CSS_PATH = MethodRef.createNonPure(RenderContext.class, "trackRequiredCssPath", String.class);
    private static final MethodRef TRACK_REQUIRED_CSS_NAMESPACE = MethodRef.createNonPure(RenderContext.class, "trackRequiredCssNamespace", String.class);
    private static final MethodRef GET_INJECTED_PARAMETER = MethodRef.createPure(RenderContext.class, "getInjectedValue", RecordProperty.class);
    private static final MethodRef GET_INJECTED_PARAMETER_DEFAULT = MethodRef.createPure(RenderContext.class, "getInjectedValue", RecordProperty.class, SoyValue.class);
    private final Expression delegate;

    RenderContextExpression(Expression renderContext) {
        super(renderContext.resultType(), renderContext.features());
        this.delegate = renderContext;
    }

    @Override
    protected void doGen(CodeBuilder adapter) {
        this.delegate.gen(adapter);
    }

    @Override
    public Expression getBidiGlobalDir() {
        return this.delegate.invoke(GET_BIDI_GLOBAL_DIR, new Expression[0]);
    }

    public Expression getBidiGlobalDirDir() {
        return this.delegate.invoke(GET_BIDI_GLOBAL_DIR_DIR, new Expression[0]);
    }

    @Override
    public Expression getAllRequiredCssNamespaces(SoyExpression template) {
        return this.delegate.invoke(GET_ALL_REQUIRED_CSS_NAMESPACES, template.unboxAsStringUnchecked());
    }

    @Override
    public Expression getAllRequiredCssPaths(SoyExpression template) {
        return this.delegate.invoke(GET_ALL_REQUIRED_CSS_PATHS, template.unboxAsStringUnchecked());
    }

    Expression getRenderCssHelper() {
        return this.delegate.invoke(GET_RENDER_CSS_HELPER, new Expression[0]);
    }

    Expression getDebugSoyTemplateInfo() {
        return this.delegate.invoke(GET_DEBUG_SOY_TEMPLATE_INFO, new Expression[0]);
    }

    Expression getPluginInstance(String pluginName) {
        return this.delegate.invoke(GET_PLUGIN_INSTANCE, BytecodeUtils.constant(pluginName));
    }

    Expression renameXid(String value) {
        return this.delegate.invoke(RENAME_XID, BytecodeUtils.constant(value));
    }

    Expression renameCss(String value) {
        return this.delegate.invoke(RENAME_CSS_SELECTOR, BytecodeUtils.constant(value));
    }

    Expression evalToggle(String toggleName) {
        return this.delegate.invoke(EVAL_TOGGLE, BytecodeUtils.constant(toggleName));
    }

    Expression getDeltemplate(String delCalleeName, Expression variantExpr) {
        return this.delegate.invoke(GET_DELTEMPLATE, BytecodeUtils.constant(delCalleeName), variantExpr);
    }

    Expression renderModifiable(String delCalleeName, Expression params, Expression appendableExpression) {
        return this.delegate.invoke(RENDER_MODIFIABLE, BytecodeUtils.constant(delCalleeName), params, appendableExpression);
    }

    @Override
    public Expression getULocale() {
        return this.delegate.invoke(GET_LOCALE, new Expression[0]);
    }

    Expression getSoyMsgParts(long id, @Nullable Expression defaultParts) {
        return defaultParts == null ? this.delegate.invoke(GET_SOY_MSG_PARTS_NO_DEFAULT, BytecodeUtils.constant(id)) : this.delegate.invoke(GET_SOY_MSG_PARTS, BytecodeUtils.constant(id), defaultParts);
    }

    Expression getSoyMsgPartsWithAlternateId(long id, @Nullable Expression defaultParts, long alternateId) {
        return defaultParts == null ? this.delegate.invoke(GET_SOY_MSG_PARTS_WITH_ALTERNATE_ID_NO_DEFAULT, BytecodeUtils.constant(id), BytecodeUtils.constant(alternateId)) : this.delegate.invoke(GET_SOY_MSG_PARTS_WITH_ALTERNATE_ID, BytecodeUtils.constant(id), defaultParts, BytecodeUtils.constant(alternateId));
    }

    Expression getBasicSoyMsgPart(long id, @Nullable Expression defaultPart) {
        return defaultPart == null ? this.delegate.invoke(GET_BASIC_SOY_MSG_PART_NO_DEFAULT, BytecodeUtils.constant(id)) : this.delegate.invoke(GET_BASIC_SOY_MSG_PART, BytecodeUtils.constant(id), defaultPart);
    }

    Expression getBasicSoyMsgPartWithAlternateId(long id, @Nullable Expression defaultPart, long alternateId) {
        return defaultPart == null ? this.delegate.invoke(GET_BASIC_SOY_MSG_PART_NO_DEFAULT_WITH_ALTERNATE_ID, BytecodeUtils.constant(id), BytecodeUtils.constant(alternateId)) : this.delegate.invoke(GET_BASIC_SOY_MSG_PART_WITH_ALTERNATE_ID, BytecodeUtils.constant(id), defaultPart, BytecodeUtils.constant(alternateId));
    }

    Expression getPrintDirective(String name) {
        return this.delegate.invoke(GET_PRINT_DIRECTIVE, BytecodeUtils.constant(name));
    }

    Expression getEscapingDirectiveAsFunction(String name) {
        return this.delegate.invoke(GET_ESCAPING_DIRECTIVE_AS_FUNCTION, BytecodeUtils.constant(name));
    }

    Expression getConst(String name) {
        return this.delegate.invoke(GET_CONST, BytecodeUtils.constant(name));
    }

    Statement storeConst(String name, Expression value) {
        return this.delegate.invokeVoid(STORE_CONST, BytecodeUtils.constant(name), value);
    }

    Statement trackRequiredCssPath(String cssPath) {
        return this.delegate.invokeVoid(TRACK_REQUIRED_CSS_PATH, BytecodeUtils.constant(cssPath));
    }

    Statement trackRequiredCssNamespace(String cssNamespace) {
        return this.delegate.invokeVoid(TRACK_REQUIRED_CSS_NAMESPACE, BytecodeUtils.constant(cssNamespace));
    }

    SoyExpression applyPrintDirective(SoyPrintDirective directive, SoyExpression value) {
        return this.applyPrintDirective(directive, value, (List<SoyExpression>)ImmutableList.of());
    }

    SoyExpression applyPrintDirective(SoyPrintDirective directive, SoyExpression value, List<SoyExpression> args) {
        value = directive instanceof SoyJbcSrcPrintDirective ? ((SoyJbcSrcPrintDirective)directive).applyForJbcSrc(this, value, args) : SoyExpression.forSoyValue(UnknownType.getInstance(), MethodRefs.SOY_JAVA_PRINT_DIRECTIVE_APPLY_FOR_JAVA.invoke(this.getPrintDirective(directive.getName()), value.box(), SoyExpression.asBoxedValueProviderList(args)));
        return value;
    }

    Expression usePrimaryMsgIfFallback(long msgId, long fallbackId) {
        return this.delegate.invoke(USE_PRIMARY_MSG_IF_FALLBACK, BytecodeUtils.constant(msgId), BytecodeUtils.constant(fallbackId));
    }

    Expression usePrimaryOrAlternateIfFallback(long msgId, long alternateId, long fallbackId) {
        return this.delegate.invoke(USE_PRIMARY_OR_ALTERNATE_IF_FALLBACK, BytecodeUtils.constant(msgId), BytecodeUtils.constant(alternateId), BytecodeUtils.constant(fallbackId));
    }

    Expression usePrimaryIfFallbackOrFallbackAlternate(long msgId, long fallbackId, long fallbackAlternateId) {
        return this.delegate.invoke(USE_PRIMARY_IF_FALLBACK_OR_FALLBACK_ALTERNATE, BytecodeUtils.constant(msgId), BytecodeUtils.constant(fallbackId), BytecodeUtils.constant(fallbackAlternateId));
    }

    Expression usePrimaryOrAlternateIfFallbackOrFallbackAlternate(long msgId, long alternateId, long fallbackId, long fallbackAlternateId) {
        return this.delegate.invoke(USE_PRIMARY_OR_ALTERNATE_IF_FALLBACK_OR_FALLBACK_ALTERNATE, BytecodeUtils.constant(msgId), BytecodeUtils.constant(alternateId), BytecodeUtils.constant(fallbackId), BytecodeUtils.constant(fallbackAlternateId));
    }

    public Expression hasLogger() {
        return this.delegate.invoke(HAS_LOGGER, new Expression[0]);
    }

    public Expression getLogger() {
        return this.delegate.invoke(GET_LOGGER, new Expression[0]);
    }

    public Expression popFrame() {
        return this.delegate.invoke(POP_FRAME, new Expression[0]);
    }

    public Expression getInjectedValue(String property, @Nullable SoyExpression value) {
        Expression prop = BytecodeUtils.constantRecordProperty(property);
        if (value == null) {
            return this.delegate.invoke(GET_INJECTED_PARAMETER, prop);
        }
        return this.delegate.invoke(GET_INJECTED_PARAMETER_DEFAULT, prop, value);
    }
}

