/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.template.soy.base.internal.UniqueNameGenerator;
import com.google.template.soy.jbcsrc.LocalVariableManager;
import com.google.template.soy.jbcsrc.internal.JbcSrcNameGenerators;
import com.google.template.soy.jbcsrc.restricted.CodeBuilder;
import com.google.template.soy.jbcsrc.restricted.Expression;
import com.google.template.soy.jbcsrc.restricted.LocalVariable;
import com.google.template.soy.jbcsrc.restricted.Statement;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;

final class SimpleLocalVariableManager
implements LocalVariableManager {
    private final ArrayDeque<UniqueNameGenerator> localNames = new ArrayDeque();
    private final List<LocalVariable> allVariables = new ArrayList<LocalVariable>();
    private final BitSet availableSlots = new BitSet();
    private final Map<String, LocalVariable> activeVariables = new LinkedHashMap<String, LocalVariable>();
    private boolean generated;
    private final boolean isStatic;
    private Type[] parameterTypes;
    private final Label methodBegin;
    private final Label methodEnd;

    SimpleLocalVariableManager(Type ownerType, boolean isStatic) {
        this(ownerType, new Type[0], (List<String>)ImmutableList.of(), null, null, isStatic);
    }

    SimpleLocalVariableManager(Type ownerType, Type[] argumentTypes, List<String> parameterNames, Label methodBegin, Label methodEnd, boolean isStatic) {
        Preconditions.checkArgument((argumentTypes.length == parameterNames.size() ? 1 : 0) != 0, (String)"expected %s args, got %s paramNames: %s", (Object)argumentTypes.length, (Object)parameterNames.size(), parameterNames);
        this.localNames.addLast(JbcSrcNameGenerators.forFieldNames());
        this.isStatic = isStatic;
        this.parameterTypes = argumentTypes;
        this.methodBegin = methodBegin;
        this.methodEnd = methodEnd;
        if (!isStatic) {
            this.reserveParameter("this", ownerType);
        }
        int parameterIndex = 0;
        for (Type type : argumentTypes) {
            this.reserveParameter(parameterNames.get(parameterIndex), type);
            ++parameterIndex;
        }
    }

    public void updateParameterTypes(Type[] parameterTypes, List<String> parameterNames) {
        Set allAllocatedVariableNames = this.allVariables.stream().map(v -> v.variableName()).collect(Collectors.toCollection(HashSet::new));
        Preconditions.checkArgument((this.parameterTypes.length == 0 && this.isStatic ? 1 : 0) != 0, (Object)"Can only change parameters if the variable manager original had no parameters and was static.");
        this.parameterTypes = parameterTypes;
        int spaceForParameters = 0;
        for (Type type : parameterTypes) {
            spaceForParameters += type.getSize();
        }
        int i = this.availableSlots.size() - 1;
        while ((i = this.availableSlots.previousSetBit(i)) >= 0) {
            this.availableSlots.set(i + spaceForParameters);
            this.availableSlots.clear(i);
        }
        for (LocalVariable var : this.allVariables) {
            var.shiftIndex(spaceForParameters);
        }
        int parameterIndex = 0;
        for (Type type : parameterTypes) {
            Object name = parameterNames.get(parameterIndex);
            while (!allAllocatedVariableNames.add(name)) {
                name = "$" + (String)name;
            }
            this.reserveParameter((String)name, type);
            ++parameterIndex;
        }
    }

    private void reserveParameter(String name, Type type) {
        int slot = this.reserveSlotFor(type);
        this.localNames.peek().exact(name);
        LocalVariable var = LocalVariable.createLocal(name, slot, type, this.methodBegin, this.methodEnd);
        this.allVariables.add(var);
        this.activeVariables.put(name, var);
    }

    @Override
    public Expression getVariable(String name) {
        LocalVariable var = this.activeVariables.get(name);
        if (var == null) {
            throw new IllegalArgumentException("Can't find variable: " + name + " among the active variables: " + String.valueOf(this.activeVariables.keySet()));
        }
        return var;
    }

    ImmutableMap<String, LocalVariable> allActiveVariables() {
        return ImmutableMap.copyOf(this.activeVariables);
    }

    @Override
    public void generateTableEntries(CodeBuilder cb) {
        this.generated = true;
        for (LocalVariable var : this.allVariables) {
            try {
                var.tableEntry(cb);
            }
            catch (Throwable t) {
                throw new RuntimeException("unable to write table entry for: " + String.valueOf(var), t);
            }
        }
    }

    @Override
    public LocalVariableManager.Scope enterScope() {
        Preconditions.checkState((!this.generated ? 1 : 0) != 0);
        final ArrayList frame = new ArrayList();
        final UniqueNameGenerator scopeNames = this.localNames.peekLast().branch();
        this.localNames.addLast(scopeNames);
        return new LocalVariableManager.Scope(){
            final Label scopeExit = new Label();
            boolean exited;

            @Override
            public LocalVariable createNamedLocal(String name, Type type) {
                LocalVariable var = this.createTemporary(name, type);
                SimpleLocalVariableManager.this.activeVariables.put(name, var);
                return var;
            }

            @Override
            public LocalVariable createTemporary(String proposedName, Type type) {
                Preconditions.checkState((!SimpleLocalVariableManager.this.generated ? 1 : 0) != 0);
                Preconditions.checkState((!this.exited ? 1 : 0) != 0);
                String name = scopeNames.generate(proposedName);
                int slot = SimpleLocalVariableManager.this.reserveSlotFor(type);
                LocalVariable var = LocalVariable.createLocal(name, slot, type, new Label(), this.scopeExit);
                SimpleLocalVariableManager.this.allVariables.add(var);
                frame.add(var);
                return var;
            }

            @Override
            public Statement exitScope() {
                Preconditions.checkState((!SimpleLocalVariableManager.this.generated ? 1 : 0) != 0);
                Preconditions.checkState((!this.exited ? 1 : 0) != 0);
                this.exited = true;
                for (LocalVariable var : frame) {
                    SimpleLocalVariableManager.this.returnSlotFor(var);
                    SimpleLocalVariableManager.this.activeVariables.remove(var.variableName());
                }
                SimpleLocalVariableManager.this.localNames.removeLast();
                return Statement.NULL_STATEMENT.labelStart(this.scopeExit);
            }
        };
    }

    private void returnSlotFor(LocalVariable var) {
        this.availableSlots.clear(var.index(), var.index() + var.resultType().getSize());
    }

    private int reserveSlotFor(Type type) {
        int size = type.getSize();
        Preconditions.checkArgument((size == 1 || size == 2 ? 1 : 0) != 0);
        int start = 0;
        while (start < 65536) {
            int nextClear = this.availableSlots.nextClearBit(start);
            if (size == 1 || size == 2 && !this.availableSlots.get(nextClear + 1)) {
                this.availableSlots.set(nextClear, nextClear + size);
                return nextClear;
            }
            start = nextClear + 1;
        }
        throw new RuntimeException("too many local variables");
    }
}

