/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Ints;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.basetree.Node;
import com.google.template.soy.data.SoyRecord;
import com.google.template.soy.exprtree.BooleanNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.FloatNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.IntegerNode;
import com.google.template.soy.exprtree.NullNode;
import com.google.template.soy.exprtree.ProtoEnumValueNode;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.exprtree.UndefinedNode;
import com.google.template.soy.jbcsrc.AppendableExpression;
import com.google.template.soy.jbcsrc.AutoValue_SoyNodeCompiler_CompiledForeachRangeArgs;
import com.google.template.soy.jbcsrc.AutoValue_SoyNodeCompiler_ExpressionAndInitializer;
import com.google.template.soy.jbcsrc.AutoValue_SoyNodeCompiler_ListOfExpressionsAndInitializer;
import com.google.template.soy.jbcsrc.AutoValue_SoyNodeCompiler_RecordOrPositional;
import com.google.template.soy.jbcsrc.CompiledTemplateMetadata;
import com.google.template.soy.jbcsrc.ControlFlow;
import com.google.template.soy.jbcsrc.DetachState;
import com.google.template.soy.jbcsrc.ExpressionCompiler;
import com.google.template.soy.jbcsrc.ExpressionDetacher;
import com.google.template.soy.jbcsrc.ExpressionToSoyValueProviderCompiler;
import com.google.template.soy.jbcsrc.ExtraCodeCompiler;
import com.google.template.soy.jbcsrc.FieldManager;
import com.google.template.soy.jbcsrc.JavaSourceFunctionCompiler;
import com.google.template.soy.jbcsrc.LazyClosureCompiler;
import com.google.template.soy.jbcsrc.MsgCompiler;
import com.google.template.soy.jbcsrc.PrintDirectives;
import com.google.template.soy.jbcsrc.RenderContextExpression;
import com.google.template.soy.jbcsrc.SyntheticVarName;
import com.google.template.soy.jbcsrc.TemplateAnalysis;
import com.google.template.soy.jbcsrc.TemplateParameterLookup;
import com.google.template.soy.jbcsrc.TemplateVariableManager;
import com.google.template.soy.jbcsrc.UnexpectedCompilerFailureException;
import com.google.template.soy.jbcsrc.internal.InnerClasses;
import com.google.template.soy.jbcsrc.restricted.Branch;
import com.google.template.soy.jbcsrc.restricted.BytecodeUtils;
import com.google.template.soy.jbcsrc.restricted.CodeBuilder;
import com.google.template.soy.jbcsrc.restricted.Expression;
import com.google.template.soy.jbcsrc.restricted.FieldRef;
import com.google.template.soy.jbcsrc.restricted.MethodRef;
import com.google.template.soy.jbcsrc.restricted.MethodRefs;
import com.google.template.soy.jbcsrc.restricted.SoyExpression;
import com.google.template.soy.jbcsrc.restricted.Statement;
import com.google.template.soy.jbcsrc.shared.ClassLoaderFallbackCallFactory;
import com.google.template.soy.jbcsrc.shared.SwitchFactory;
import com.google.template.soy.logging.LoggingFunction;
import com.google.template.soy.msgs.internal.MsgUtils;
import com.google.template.soy.shared.RangeArgs;
import com.google.template.soy.shared.restricted.SoyFunctionSignature;
import com.google.template.soy.shared.restricted.SoyPrintDirective;
import com.google.template.soy.soytree.AbstractReturningSoyNodeVisitor;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallDelegateNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.CallParamValueNode;
import com.google.template.soy.soytree.ConstNode;
import com.google.template.soy.soytree.DebuggerNode;
import com.google.template.soy.soytree.ForNode;
import com.google.template.soy.soytree.ForNonemptyNode;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfElseNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.KeyNode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.LetValueNode;
import com.google.template.soy.soytree.LogNode;
import com.google.template.soy.soytree.MsgFallbackGroupNode;
import com.google.template.soy.soytree.MsgHtmlTagNode;
import com.google.template.soy.soytree.MsgNode;
import com.google.template.soy.soytree.MsgPlaceholderNode;
import com.google.template.soy.soytree.PartialFileSetMetadata;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.SwitchCaseNode;
import com.google.template.soy.soytree.SwitchDefaultNode;
import com.google.template.soy.soytree.SwitchNode;
import com.google.template.soy.soytree.TemplateBasicNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.VeLogNode;
import com.google.template.soy.soytree.Visibility;
import com.google.template.soy.soytree.defn.TemplateParam;
import com.google.template.soy.types.TemplateType;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;

final class SoyNodeCompiler
extends AbstractReturningSoyNodeVisitor<Statement> {
    final TemplateAnalysis analysis;
    final InnerClasses innerClasses;
    final DetachState detachState;
    final TemplateVariableManager variables;
    final TemplateParameterLookup parameterLookup;
    final FieldManager fields;
    final AppendableExpression appendableExpression;
    final ExpressionCompiler exprCompiler;
    final ExpressionToSoyValueProviderCompiler expressionToSoyValueProviderCompiler;
    final ExpressionCompiler.BasicExpressionCompiler constantCompiler;
    final JavaSourceFunctionCompiler javaSourceFunctionCompiler;
    final PartialFileSetMetadata fileSetMetadata;
    private TemplateVariableManager.Scope currentScope;
    private static final Handle STRING_SWITCH_FACTORY_HANDLE = MethodRef.createPure(SwitchFactory.class, "bootstrapSwitch", MethodHandles.Lookup.class, String.class, MethodType.class, Object[].class).asHandle();
    private static final Type STRING_SWITCH_DESCRIPTOR_OBJECT = Type.getMethodType((Type)Type.INT_TYPE, (Type[])new Type[]{BytecodeUtils.OBJECT.type()});
    private static final Type STRING_SWITCH_DESCRIPTOR_SOY_VALUE = Type.getMethodType((Type)Type.INT_TYPE, (Type[])new Type[]{BytecodeUtils.SOY_VALUE_TYPE});
    private static final Handle STATIC_CALL_HANDLE = MethodRef.createPure(ClassLoaderFallbackCallFactory.class, "bootstrapCall", MethodHandles.Lookup.class, String.class, MethodType.class, String.class).asHandle();
    private static final Handle STATIC_TEMPLATE_HANDLE = MethodRef.createPure(ClassLoaderFallbackCallFactory.class, "bootstrapTemplateLookup", MethodHandles.Lookup.class, String.class, MethodType.class, String.class).asHandle();
    private static final String TEMPLATE_METHOD_DESCRIPTOR = Type.getMethodDescriptor((Type)BytecodeUtils.COMPILED_TEMPLATE_TYPE, (Type[])new Type[]{BytecodeUtils.RENDER_CONTEXT_TYPE});

    static SoyNodeCompiler create(SoyNode context, TemplateAnalysis analysis, InnerClasses innerClasses, AppendableExpression appendableVar, TemplateVariableManager variables, TemplateParameterLookup parameterLookup, FieldManager fields, ExpressionCompiler.BasicExpressionCompiler constantCompiler, JavaSourceFunctionCompiler javaSourceFunctionCompiler, PartialFileSetMetadata fileSetMetadata) {
        DetachState detachState = new DetachState(variables, parameterLookup::getRenderContext);
        ExpressionCompiler expressionCompiler = ExpressionCompiler.create(context, analysis, parameterLookup, variables, javaSourceFunctionCompiler, fileSetMetadata);
        ExpressionToSoyValueProviderCompiler soyValueProviderCompiler = ExpressionToSoyValueProviderCompiler.create(analysis, expressionCompiler, parameterLookup);
        return new SoyNodeCompiler(analysis, innerClasses, detachState, variables, parameterLookup, fields, appendableVar, expressionCompiler, soyValueProviderCompiler, constantCompiler, javaSourceFunctionCompiler, fileSetMetadata);
    }

    SoyNodeCompiler(TemplateAnalysis analysis, InnerClasses innerClasses, DetachState detachState, TemplateVariableManager variables, TemplateParameterLookup parameterLookup, FieldManager fields, AppendableExpression appendableExpression, ExpressionCompiler exprCompiler, ExpressionToSoyValueProviderCompiler expressionToSoyValueProviderCompiler, ExpressionCompiler.BasicExpressionCompiler constantCompiler, JavaSourceFunctionCompiler javaSourceFunctionCompiler, PartialFileSetMetadata fileSetMetadata) {
        this.analysis = (TemplateAnalysis)Preconditions.checkNotNull((Object)analysis);
        this.innerClasses = innerClasses;
        this.detachState = (DetachState)Preconditions.checkNotNull((Object)detachState);
        this.variables = (TemplateVariableManager)Preconditions.checkNotNull((Object)variables);
        this.parameterLookup = (TemplateParameterLookup)Preconditions.checkNotNull((Object)parameterLookup);
        this.fields = (FieldManager)Preconditions.checkNotNull((Object)fields);
        this.appendableExpression = (AppendableExpression)Preconditions.checkNotNull((Object)appendableExpression);
        this.exprCompiler = (ExpressionCompiler)Preconditions.checkNotNull((Object)exprCompiler);
        this.expressionToSoyValueProviderCompiler = (ExpressionToSoyValueProviderCompiler)Preconditions.checkNotNull((Object)expressionToSoyValueProviderCompiler);
        this.constantCompiler = constantCompiler;
        this.javaSourceFunctionCompiler = javaSourceFunctionCompiler;
        this.fileSetMetadata = fileSetMetadata;
    }

    Statement compile(SoyNode.RenderUnitNode node, ExtraCodeCompiler prefix, ExtraCodeCompiler suffix) {
        ArrayList<Statement> statements = new ArrayList<Statement>();
        if (SoyNodeCompiler.shouldCheckForSoftLimit(node)) {
            statements.add(this.detachState.detachLimited(this.appendableExpression));
        }
        statements.add(this.trackRequiredCssPathStatements(node));
        statements.add(this.doCompile(node, prefix, suffix));
        statements.add(0, this.detachState.generateReattachTable());
        return Statement.concat(statements);
    }

    Statement compileWithoutDetaches(SoyNode.RenderUnitNode node, ExtraCodeCompiler prefix, ExtraCodeCompiler suffix) {
        try (DetachState.NoNewDetaches noNewDetaches = this.detachState.expectNoNewDetaches();){
            Statement statement = this.doCompile(node, prefix, suffix);
            return statement;
        }
    }

    private Statement trackRequiredCssPathStatements(SoyNode.RenderUnitNode node) {
        SoyFileNode fileNode = node.getNearestAncestor(SoyFileNode.class);
        if (!(!(node instanceof TemplateNode) || ((TemplateNode)node).getVisibility() != Visibility.PUBLIC && (!(node instanceof TemplateBasicNode) || ((TemplateBasicNode)node).getModifiesExpr() == null) || fileNode.getAllRequiredCssPaths().isEmpty() && fileNode.getRequiredCssNamespaces().isEmpty() || this.definitelyCallsPublicTemplateInSameFile((TemplateNode)node))) {
            return Statement.concat((Iterable)Stream.concat(fileNode.getAllRequiredCssPaths().stream().map(css -> css.resolvedPath().orElseThrow()).map(cssPath -> this.parameterLookup.getRenderContext().trackRequiredCssPath((String)cssPath)), fileNode.getRequiredCssNamespaces().stream().map(cssNamespace -> this.parameterLookup.getRenderContext().trackRequiredCssNamespace((String)cssNamespace))).collect(ImmutableList.toImmutableList()));
        }
        return Statement.NULL_STATEMENT;
    }

    private boolean definitelyCallsPublicTemplateInSameFile(TemplateNode node) {
        ImmutableSet publicTemplateNames = (ImmutableSet)node.getNearestAncestor(SoyFileNode.class).getTemplates().stream().filter(t -> t.getVisibility() == Visibility.PUBLIC).map(TemplateNode::getTemplateName).collect(ImmutableSet.toImmutableSet());
        return node.getChildren().stream().anyMatch(child -> child.getKind() == SoyNode.Kind.CALL_BASIC_NODE && ((CallBasicNode)child).isStaticCall() && publicTemplateNames.contains((Object)((CallBasicNode)child).getCalleeName()));
    }

    private Statement doCompile(SoyNode.RenderUnitNode node, ExtraCodeCompiler prefix, ExtraCodeCompiler suffix) {
        return Statement.concat(this.appendableExpression.setSanitizedContentKindAndDirectionality(node.getContentKind()).toStatement(), prefix.compile(this.exprCompiler, this.appendableExpression, this.detachState), this.visitChildrenInNewScope(node), suffix.compile(this.exprCompiler, this.appendableExpression, this.detachState));
    }

    @Override
    protected Statement visit(SoyNode node) {
        try {
            return ((Statement)super.visit(node)).withSourceLocation(node.getSourceLocation());
        }
        catch (UnexpectedCompilerFailureException e) {
            e.addLocation(node);
            throw e;
        }
        catch (Throwable t) {
            throw new UnexpectedCompilerFailureException(node, t);
        }
    }

    private static boolean kindRequiresDetach(SanitizedContentKind kind) {
        switch (kind) {
            case TEXT: 
            case HTML: 
            case HTML_ELEMENT: 
            case CSS: 
            case JS: {
                return true;
            }
            case TRUSTED_RESOURCE_URI: 
            case URI: 
            case ATTRIBUTES: {
                return false;
            }
        }
        throw new AssertionError((Object)("invalid kind: " + String.valueOf((Object)kind)));
    }

    private static boolean directlyPrintingNode(Node node) {
        if (node instanceof SoyNode) {
            SoyNode.Kind kind = ((SoyNode)node).getKind();
            return kind == SoyNode.Kind.RAW_TEXT_NODE || kind == SoyNode.Kind.PRINT_NODE;
        }
        return false;
    }

    private static boolean shouldCheckForSoftLimit(SoyNode.RenderUnitNode node) {
        if (!(node instanceof TemplateNode)) {
            return false;
        }
        if (!SoyNodeCompiler.kindRequiresDetach(node.getContentKind())) {
            return false;
        }
        return SoyTreeUtils.allNodes(node, n -> {
            if (!(n instanceof SoyNode) || n instanceof LetContentNode || n instanceof CallParamContentNode) {
                return SoyTreeUtils.VisitDirective.SKIP_CHILDREN;
            }
            return SoyTreeUtils.VisitDirective.CONTINUE;
        }).anyMatch(SoyNodeCompiler::directlyPrintingNode);
    }

    @Override
    protected Statement visitTemplateNode(TemplateNode node) {
        throw new AssertionError((Object)"should not be called");
    }

    @Override
    protected Statement visitConstNode(ConstNode node) {
        throw new AssertionError((Object)"should not be called");
    }

    private Statement visitChildrenInNewScope(SoyNode.BlockNode node) {
        TemplateVariableManager.Scope prev = this.currentScope;
        this.currentScope = this.variables.enterScope();
        List children = this.visitChildren(node);
        Statement leave = this.currentScope.exitScope();
        children.add(leave);
        this.currentScope = prev;
        return Statement.concat(children);
    }

    @Override
    protected Statement visitIfNode(IfNode node) {
        ArrayList<ControlFlow.IfBlock> ifs = new ArrayList<ControlFlow.IfBlock>();
        Optional<Statement> elseBlock = Optional.empty();
        for (SoyNode child : node.getChildren()) {
            if (child instanceof IfCondNode) {
                IfCondNode icn = (IfCondNode)child;
                Branch cond = this.exprCompiler.compileRootExpression(icn.getExpr(), this.detachState).compileToBranch();
                Statement block = this.visitChildrenInNewScope(icn);
                ifs.add(ControlFlow.IfBlock.create(cond, block));
                continue;
            }
            IfElseNode ien = (IfElseNode)child;
            elseBlock = Optional.of(this.visitChildrenInNewScope(ien));
        }
        return ControlFlow.ifElseChain(ifs, elseBlock);
    }

    private static int getUnusedKey(NavigableSet<Integer> sortedKeys) {
        Integer min = sortedKeys.higher(Integer.MIN_VALUE);
        if (min != null) {
            return min - 1;
        }
        Integer max = sortedKeys.lower(Integer.MAX_VALUE);
        if (max != null) {
            return max + 1;
        }
        int candidate = min + 1;
        for (Integer i : sortedKeys) {
            if (candidate < i) break;
            candidate = i + 1;
        }
        return candidate;
    }

    private static Expression asSwitchableInt(SoyExpression switchExpr, NavigableSet<Integer> switchKeys) {
        int unusedKey = SoyNodeCompiler.getUnusedKey(switchKeys);
        if (switchExpr.resultType().equals((Object)Type.LONG_TYPE)) {
            return MethodRefs.AS_SWITCHABLE_VALUE_LONG.invoke(switchExpr, BytecodeUtils.constant(unusedKey));
        }
        if (switchExpr.resultType().equals((Object)Type.DOUBLE_TYPE)) {
            return MethodRefs.AS_SWITCHABLE_VALUE_DOUBLE.invoke(switchExpr, BytecodeUtils.constant(unusedKey));
        }
        return MethodRefs.AS_SWITCHABLE_VALUE_SOY_VALUE.invoke(switchExpr.box(), BytecodeUtils.constant(unusedKey));
    }

    private static Expression asSwitchableInt(SoyExpression switchExpr, final Object[] switchKeys) {
        final SoyExpression stringKey = switchExpr.soyRuntimeType().assignableToNullableString() ? switchExpr.unboxAsStringOrJavaNull() : switchExpr.box();
        return new Expression(Type.INT_TYPE){

            @Override
            protected void doGen(CodeBuilder adapter) {
                stringKey.gen(adapter);
                adapter.visitInvokeDynamicInsn("switchCase", (stringKey.isBoxed() ? STRING_SWITCH_DESCRIPTOR_SOY_VALUE : STRING_SWITCH_DESCRIPTOR_OBJECT).getDescriptor(), STRING_SWITCH_FACTORY_HANDLE, switchKeys);
            }
        };
    }

    private Optional<Statement> tryCompileSwitchToSwitchInstruction(SoyExpression switchExpr, SwitchNode node) {
        LinkedHashMap<Object, SwitchCaseNode> cases = new LinkedHashMap<Object, SwitchCaseNode>();
        SwitchDefaultNode dfltNode = null;
        for (SoyNode child : node.getChildren()) {
            if (child instanceof SwitchCaseNode) {
                SwitchCaseNode caseNode = (SwitchCaseNode)child;
                for (ExprRootNode caseExpr : caseNode.getExprList()) {
                    ExprNode root = caseExpr.getRoot();
                    if (root instanceof IntegerNode) {
                        long intValue = ((IntegerNode)root).getValue();
                        if (intValue == (long)((int)intValue)) {
                            cases.putIfAbsent((int)intValue, caseNode);
                            continue;
                        }
                        cases.putIfAbsent(intValue, caseNode);
                        continue;
                    }
                    if (root instanceof ProtoEnumValueNode) {
                        cases.putIfAbsent(((ProtoEnumValueNode)root).getValueAsInt(), caseNode);
                        continue;
                    }
                    if (root instanceof BooleanNode) {
                        cases.putIfAbsent(BytecodeUtils.constant(((BooleanNode)root).getValue()).constantBytecodeValue(), caseNode);
                        continue;
                    }
                    if (root instanceof FloatNode) {
                        double floatValue = ((FloatNode)root).getValue();
                        if (floatValue == (double)((int)floatValue)) {
                            cases.putIfAbsent((int)floatValue, caseNode);
                            continue;
                        }
                        if (floatValue == (double)((long)floatValue)) {
                            cases.putIfAbsent((long)floatValue, caseNode);
                            continue;
                        }
                        cases.putIfAbsent(floatValue, caseNode);
                        continue;
                    }
                    if (root instanceof StringNode) {
                        cases.putIfAbsent(((StringNode)root).getValue(), caseNode);
                        continue;
                    }
                    if (root instanceof NullNode) {
                        cases.putIfAbsent(BytecodeUtils.soyNull().constantBytecodeValue(), caseNode);
                        continue;
                    }
                    if (root instanceof UndefinedNode) {
                        cases.putIfAbsent(BytecodeUtils.soyUndefined().constantBytecodeValue(), caseNode);
                        continue;
                    }
                    return Optional.empty();
                }
                continue;
            }
            dfltNode = (SwitchDefaultNode)child;
        }
        LinkedHashMap<SwitchCaseNode, StatementAndStartLabel> caseToStatement = new LinkedHashMap<SwitchCaseNode, StatementAndStartLabel>();
        Statement defaultBlock = dfltNode == null ? null : this.visitChildrenInNewScope(dfltNode);
        TreeMap<Integer, StatementAndStartLabel> casesByKey = new TreeMap<Integer, StatementAndStartLabel>();
        if (cases.keySet().stream().allMatch(key -> key instanceof Integer)) {
            for (Map.Entry entry : cases.entrySet()) {
                casesByKey.put((int)((Integer)entry.getKey()), caseToStatement.computeIfAbsent((SwitchCaseNode)entry.getValue(), x$0 -> new StatementAndStartLabel(this, (SwitchCaseNode)x$0)));
            }
            return Optional.of(SoyNodeCompiler.asNativeSwitch(SoyNodeCompiler.asSwitchableInt(switchExpr, casesByKey.navigableKeySet()), casesByKey, defaultBlock));
        }
        Object[] keys = cases.keySet().toArray();
        int i = 0;
        for (SwitchCaseNode caseNode : cases.values()) {
            casesByKey.put(i, caseToStatement.computeIfAbsent(caseNode, x$0 -> new StatementAndStartLabel(this, (SwitchCaseNode)x$0)));
            ++i;
        }
        return Optional.of(SoyNodeCompiler.asNativeSwitch(SoyNodeCompiler.asSwitchableInt(switchExpr, keys), casesByKey, defaultBlock));
    }

    private static Statement asNativeSwitch(final Expression switchExpr, final TreeMap<Integer, StatementAndStartLabel> casesByKey, final Statement defaultBlock) {
        final int min = casesByKey.firstKey();
        final int max = casesByKey.lastKey();
        final int range = max - min + 1;
        final boolean isDense = (float)casesByKey.size() / (float)range >= 0.5f;
        return new Statement(){

            @Override
            protected void doGen(CodeBuilder adapter) {
                Label end = new Label();
                Label dflt = defaultBlock == null ? end : new Label();
                switchExpr.gen(adapter);
                if (isDense) {
                    Object[] labels = new Label[range];
                    Arrays.fill(labels, dflt);
                    for (Map.Entry entry : casesByKey.entrySet()) {
                        Integer key = (Integer)entry.getKey();
                        int labelIndex = key - min;
                        labels[labelIndex] = ((StatementAndStartLabel)entry.getValue()).startLabel;
                    }
                    adapter.visitTableSwitchInsn(min, max, dflt, (Label[])labels);
                } else {
                    adapter.visitLookupSwitchInsn(dflt, casesByKey.keySet().stream().mapToInt(Integer::intValue).toArray(), (Label[])casesByKey.values().stream().map(s -> s.startLabel).toArray(Label[]::new));
                }
                boolean isFirst = true;
                for (StatementAndStartLabel caseStatement : new LinkedHashSet(casesByKey.values())) {
                    if (!isFirst) {
                        adapter.goTo(end);
                    }
                    caseStatement.statement.gen(adapter);
                    isFirst = false;
                }
                if (defaultBlock != null) {
                    adapter.goTo(end);
                    adapter.mark(dflt);
                    defaultBlock.gen(adapter);
                }
                adapter.mark(end);
            }
        };
    }

    @Override
    protected Statement visitSwitchNode(SwitchNode node) {
        List children = node.getChildren();
        if (children.isEmpty()) {
            return Statement.NULL_STATEMENT;
        }
        if (children.size() == 1 && children.get(0) instanceof SwitchDefaultNode) {
            return this.visitChildrenInNewScope((SoyNode.BlockNode)children.get(0));
        }
        SoyExpression switchVar = this.exprCompiler.compileRootExpression(node.getExpr(), this.detachState);
        Optional<Statement> maybeNativeSwitch = this.tryCompileSwitchToSwitchInstruction(switchVar, node);
        if (maybeNativeSwitch.isPresent()) {
            return maybeNativeSwitch.get();
        }
        TemplateVariableManager.Scope scope = this.variables.enterScope();
        TemplateVariableManager.Variable variable = scope.createSynthetic(SyntheticVarName.forSwitch(node), switchVar, TemplateVariableManager.SaveStrategy.STORE);
        Statement initializer = variable.initializer();
        switchVar = switchVar.withSource(variable.local());
        ArrayList<ControlFlow.IfBlock> cases = new ArrayList<ControlFlow.IfBlock>();
        Optional<Statement> defaultBlock = Optional.empty();
        for (SoyNode child : children) {
            if (child instanceof SwitchCaseNode) {
                SwitchCaseNode caseNode = (SwitchCaseNode)child;
                Label reattachPoint = null;
                ArrayList<Branch> comparisons = new ArrayList<Branch>();
                for (ExprRootNode caseExpr : caseNode.getExprList()) {
                    boolean isFirst;
                    boolean bl = isFirst = reattachPoint == null;
                    if (isFirst) {
                        reattachPoint = new Label();
                    }
                    Expression compiledCase = BytecodeUtils.compareSoySwitchCaseEquals(switchVar, this.exprCompiler.compileSubExpression(caseExpr, this.detachState.createExpressionDetacher(reattachPoint)));
                    if (isFirst) {
                        compiledCase = compiledCase.labelStart(reattachPoint);
                    }
                    comparisons.add(Branch.ifTrue(compiledCase));
                }
                Statement block = this.visitChildrenInNewScope(caseNode);
                cases.add(ControlFlow.IfBlock.create(Branch.or(comparisons), block));
                continue;
            }
            SwitchDefaultNode defaultNode = (SwitchDefaultNode)child;
            defaultBlock = Optional.of(this.visitChildrenInNewScope(defaultNode));
        }
        Statement exitScope = scope.exitScope();
        return Statement.concat(initializer, ControlFlow.ifElseChain(cases, defaultBlock), exitScope);
    }

    @Override
    protected Statement visitForNode(ForNode node) {
        TemplateVariableManager.Variable itemVar;
        TemplateVariableManager.Variable userIndexVar;
        TemplateVariableManager.Variable indexVar;
        TemplateVariableManager.Variable sizeVar;
        ForNonemptyNode nonEmptyNode = (ForNonemptyNode)node.getChild(0);
        Optional<RangeArgs> exprAsRangeArgs = RangeArgs.createFromNode(node);
        TemplateVariableManager.Scope scope = this.variables.enterScope();
        final ArrayList<Statement> initializers = new ArrayList<Statement>();
        if (exprAsRangeArgs.isPresent()) {
            final CompiledForeachRangeArgs compiledArgs = this.calculateRangeArgs(node, scope);
            initializers.addAll((Collection<Statement>)compiledArgs.initStatements());
            sizeVar = scope.createSynthetic(SyntheticVarName.foreachLoopLength(nonEmptyNode), MethodRefs.RUNTIME_RANGE_LOOP_LENGTH.invoke(compiledArgs.start(), compiledArgs.end(), compiledArgs.step()), TemplateVariableManager.SaveStrategy.DERIVED);
            indexVar = scope.createSynthetic(SyntheticVarName.foreachLoopIndex(nonEmptyNode), BytecodeUtils.constant(0), TemplateVariableManager.SaveStrategy.STORE);
            userIndexVar = nonEmptyNode.getIndexVar() == null ? null : scope.create(nonEmptyNode.getIndexVarName(), SoyExpression.forInt(BytecodeUtils.numericConversion(indexVar.local(), Type.LONG_TYPE)), TemplateVariableManager.SaveStrategy.DERIVED);
            itemVar = scope.create(nonEmptyNode.getVarName(), new Expression(this, Type.LONG_TYPE, Expression.Feature.CHEAP.asFeatures()){

                @Override
                protected void doGen(CodeBuilder adapter) {
                    compiledArgs.start().gen(adapter);
                    compiledArgs.step().gen(adapter);
                    indexVar.local().gen(adapter);
                    adapter.visitInsn(104);
                    adapter.visitInsn(96);
                    adapter.cast(Type.INT_TYPE, Type.LONG_TYPE);
                }
            }, TemplateVariableManager.SaveStrategy.DERIVED);
        } else {
            SoyExpression expr = this.exprCompiler.compileRootExpression(node.getExpr(), this.detachState).unboxAsListUnchecked();
            TemplateVariableManager.Variable listVar = scope.createSynthetic(SyntheticVarName.foreachLoopList(nonEmptyNode), expr, TemplateVariableManager.SaveStrategy.STORE);
            initializers.add(listVar.initializer());
            sizeVar = scope.createSynthetic(SyntheticVarName.foreachLoopLength(nonEmptyNode), MethodRefs.LIST_SIZE.invoke(listVar.local()), TemplateVariableManager.SaveStrategy.DERIVED);
            indexVar = scope.createSynthetic(SyntheticVarName.foreachLoopIndex(nonEmptyNode), BytecodeUtils.constant(0), TemplateVariableManager.SaveStrategy.STORE);
            userIndexVar = nonEmptyNode.getIndexVar() == null ? null : scope.create(nonEmptyNode.getIndexVarName(), BytecodeUtils.numericConversion(indexVar.local(), Type.LONG_TYPE), TemplateVariableManager.SaveStrategy.DERIVED);
            itemVar = scope.create(nonEmptyNode.getVarName(), MethodRefs.LIST_GET.invoke(listVar.local(), indexVar.local()).checkedCast(BytecodeUtils.SOY_VALUE_PROVIDER_TYPE), TemplateVariableManager.SaveStrategy.DERIVED);
        }
        initializers.add(sizeVar.initializer());
        final Statement loopBody = this.visitChildrenInNewScope(nonEmptyNode);
        final Statement exitScope = scope.exitScope();
        return new Statement(this){

            @Override
            protected void doGen(CodeBuilder adapter) {
                for (Statement initializer : initializers) {
                    initializer.gen(adapter);
                }
                sizeVar.local().gen(adapter);
                Label emptyListLabel = new Label();
                adapter.ifZCmp(153, emptyListLabel);
                indexVar.initializer().gen(adapter);
                Label loopStart = adapter.mark();
                itemVar.initializer().gen(adapter);
                if (userIndexVar != null) {
                    userIndexVar.initializer().gen(adapter);
                }
                loopBody.gen(adapter);
                adapter.iinc(indexVar.local().index(), 1);
                indexVar.local().gen(adapter);
                sizeVar.local().gen(adapter);
                adapter.ifICmp(155, loopStart);
                exitScope.gen(adapter);
                adapter.mark(emptyListLabel);
            }
        };
    }

    private CompiledForeachRangeArgs calculateRangeArgs(ForNode forNode, TemplateVariableManager.Scope scope) {
        RangeArgs rangeArgs = RangeArgs.createFromNode(forNode).get();
        ForNonemptyNode nonEmptyNode = (ForNonemptyNode)forNode.getChild(0);
        ImmutableList.Builder initStatements = ImmutableList.builder();
        Expression startExpression = this.computeRangeValue(SyntheticVarName.foreachLoopRangeStart(nonEmptyNode), rangeArgs.start(), 0, scope, (ImmutableList.Builder<Statement>)initStatements);
        Expression stepExpression = this.computeRangeValue(SyntheticVarName.foreachLoopRangeStep(nonEmptyNode), rangeArgs.increment(), 1, scope, (ImmutableList.Builder<Statement>)initStatements);
        Expression endExpression = this.computeRangeValue(SyntheticVarName.foreachLoopRangeEnd(nonEmptyNode), Optional.of(rangeArgs.limit()), Integer.MAX_VALUE, scope, (ImmutableList.Builder<Statement>)initStatements);
        return new AutoValue_SoyNodeCompiler_CompiledForeachRangeArgs(startExpression, endExpression, stepExpression, (ImmutableList<Statement>)initStatements.build());
    }

    private Expression computeRangeValue(SyntheticVarName varName, Optional<ExprNode> expression, int defaultValue, TemplateVariableManager.Scope scope, ImmutableList.Builder<Statement> initStatements) {
        if (!expression.isPresent()) {
            return BytecodeUtils.constant(defaultValue);
        }
        if (expression.get() instanceof IntegerNode && ((IntegerNode)expression.get()).isInt()) {
            int value = Ints.checkedCast((long)((IntegerNode)expression.get()).getValue());
            return BytecodeUtils.constant(value);
        }
        Label startDetachPoint = new Label();
        SoyExpression compiledExpression = this.exprCompiler.compileSubExpression(expression.get(), this.detachState.createExpressionDetacher(startDetachPoint));
        Expression rangeValue = compiledExpression.coerceToInt();
        if (!rangeValue.isCheap()) {
            TemplateVariableManager.Variable startVar = scope.createSynthetic(varName, rangeValue, TemplateVariableManager.SaveStrategy.STORE);
            initStatements.add((Object)startVar.initializer().labelStart(startDetachPoint));
            rangeValue = startVar.local();
        }
        return rangeValue;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected Statement visitPrintNode(PrintNode node) {
        block3: {
            if (node.getExpr().getRoot() instanceof FunctionNode && (fn = (FunctionNode)node.getExpr().getRoot()).getSoyFunction() instanceof LoggingFunction) {
                return this.visitLoggingFunction(node, fn, (LoggingFunction)fn.getSoyFunction());
            }
            if (!PrintDirectives.areAllPrintDirectivesStreamable(node)) break block3;
            reattachPoint = new Label();
            expr = node.getExpr();
            asSoyValueProvider = this.expressionToSoyValueProviderCompiler.compileToSoyValueProviderIfUsefulToPreserveStreaming(expr, this.detachState.createExpressionDetacher(reattachPoint));
            if (!asSoyValueProvider.isPresent()) break block3;
            if (this.exprCompiler.requiresDetach(expr)) ** GOTO lbl-1000
            if (node.getChildren().stream().flatMap((Function<PrintDirectiveNode, Stream>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$visitPrintNode$9(com.google.template.soy.soytree.PrintDirectiveNode ), (Lcom/google/template/soy/soytree/PrintDirectiveNode;)Ljava/util/stream/Stream;)()).anyMatch((Predicate<ExprRootNode>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, requiresDetach(com.google.template.soy.exprtree.ExprNode ), (Lcom/google/template/soy/exprtree/ExprRootNode;)Z)((ExpressionCompiler)this.exprCompiler))) lbl-1000:
            // 2 sources

            {
                v0 = true;
            } else {
                v0 = false;
            }
            requiresDetachLogic = v0;
            return this.renderIncrementally(asSoyValueProvider.get(), node.getChildren(), reattachPoint, requiresDetachLogic);
        }
        reattachPoint = new Label();
        value = this.compilePrintNodeAsExpression(node, reattachPoint);
        renderSoyValue = this.appendableExpression.appendString(value.coerceToString()).labelStart(reattachPoint);
        return renderSoyValue.toStatement();
    }

    private Statement visitLoggingFunction(PrintNode node, FunctionNode fn, LoggingFunction loggingFunction) {
        ArrayList<Expression> printDirectives = new ArrayList<Expression>(node.numChildren());
        for (PrintDirectiveNode child : node.getChildren()) {
            Preconditions.checkState((boolean)child.getArgs().isEmpty());
            printDirectives.add(this.parameterLookup.getRenderContext().getEscapingDirectiveAsFunction(child.getName()));
        }
        Label reattachPoint = new Label();
        SoyFunctionSignature functionSignature = loggingFunction.getClass().getAnnotation(SoyFunctionSignature.class);
        Preconditions.checkNotNull((Object)functionSignature, (String)"LoggingFunction %s must be annotated with @SoyFunctionSignature", (Object)loggingFunction.getClass().getName());
        return this.appendableExpression.appendLoggingFunctionInvocation(functionSignature.name(), loggingFunction.getPlaceholder(), this.exprCompiler.asBasicCompiler(this.detachState.createExpressionDetacher(reattachPoint)).compileToList(fn.getParams()), printDirectives).labelStart(reattachPoint).toStatement();
    }

    private SoyExpression compilePrintNodeAsExpression(PrintNode node, Label reattachPoint) {
        ExpressionCompiler.BasicExpressionCompiler basic = this.exprCompiler.asBasicCompiler(this.detachState.createExpressionDetacher(reattachPoint));
        SoyExpression value = basic.compile(node.getExpr());
        for (PrintDirectiveNode printDirective : node.getChildren()) {
            value = this.parameterLookup.getRenderContext().applyPrintDirective(printDirective.getPrintDirective(), value, basic.compileToList((List<? extends ExprNode>)printDirective.getArgs()));
        }
        return value;
    }

    private Statement renderIncrementally(Expression soyValueProvider, List<PrintDirectiveNode> directives, Label reattachPoint, boolean requiresDetachLogic) {
        Statement initRenderee = Statement.NULL_STATEMENT;
        TemplateVariableManager.Scope renderScope = this.variables.enterScope();
        if (!soyValueProvider.isCheap()) {
            TemplateVariableManager.Variable variable = renderScope.createSynthetic(SyntheticVarName.renderee(), soyValueProvider, TemplateVariableManager.SaveStrategy.STORE);
            initRenderee = variable.initializer();
            soyValueProvider = variable.accessor();
        }
        initRenderee = initRenderee.labelStart(reattachPoint);
        Statement initAppendable = Statement.NULL_STATEMENT;
        Statement clearAppendable = Statement.NULL_STATEMENT;
        AppendableExpression appendable = this.appendableExpression;
        if (!directives.isEmpty()) {
            Label printDirectiveArgumentReattachPoint = new Label();
            PrintDirectives.AppendableAndFlushBuffersDepth wrappedAppendable = PrintDirectives.applyStreamingPrintDirectives(directives, appendable, this.exprCompiler.asBasicCompiler(this.detachState.createExpressionDetacher(printDirectiveArgumentReattachPoint)), this.parameterLookup.getPluginContext());
            TemplateVariableManager.Variable variable = renderScope.createSynthetic(SyntheticVarName.appendable(), wrappedAppendable.appendable(), TemplateVariableManager.SaveStrategy.STORE);
            initAppendable = variable.initializer().labelStart(printDirectiveArgumentReattachPoint);
            appendable = AppendableExpression.forExpression(variable.accessor());
            if (wrappedAppendable.flushBuffersDepth() >= 0) {
                clearAppendable = appendable.flushBuffers(wrappedAppendable.flushBuffersDepth());
            }
        }
        Expression callRenderAndResolve = soyValueProvider.invoke(MethodRefs.SOY_VALUE_PROVIDER_RENDER_AND_RESOLVE, appendable);
        Statement doCall = requiresDetachLogic ? this.detachState.detachForRender(callRenderAndResolve) : this.detachState.assertFullyRenderered(callRenderAndResolve);
        return Statement.concat(initRenderee, initAppendable, doCall, clearAppendable, renderScope.exitScope());
    }

    @Override
    protected Statement visitRawTextNode(RawTextNode node) {
        AppendableExpression render = node.getRawText().length() == 1 ? this.appendableExpression.appendChar(BytecodeUtils.constant(node.getRawText().charAt(0))) : this.appendableExpression.appendString(BytecodeUtils.constant(node.getRawText()));
        return render.toStatement();
    }

    @Override
    protected Statement visitDebuggerNode(DebuggerNode node) {
        return MethodRefs.RUNTIME_DEBUGGER.invokeVoid(BytecodeUtils.constant(node.getSourceLocation().getFilePath().path()), BytecodeUtils.constant(node.getSourceLocation().getBeginLine()));
    }

    @Override
    protected Statement visitKeyNode(KeyNode node) {
        return Statement.NULL_STATEMENT;
    }

    @Override
    protected Statement visitMsgFallbackGroupNode(MsgFallbackGroupNode node) {
        MsgNode msg = node.getMsg();
        MsgUtils.MsgPartsAndIds idAndParts = MsgUtils.buildMsgPartsAndComputeMsgIdForDualFormat(msg);
        ImmutableList<SoyPrintDirective> escapingDirectives = node.getEscapingDirectives();
        Statement renderDefault = this.getMsgCompiler().compileMessage(idAndParts, msg, escapingDirectives, false);
        if (node.hasFallbackMsg()) {
            MsgNode fallback = node.getFallbackMsg();
            MsgUtils.MsgPartsAndIds fallbackIdAndParts = MsgUtils.buildMsgPartsAndComputeMsgIdForDualFormat(fallback);
            Expression cond = msg.getAlternateId().isPresent() ? (fallback.getAlternateId().isPresent() ? this.parameterLookup.getRenderContext().usePrimaryOrAlternateIfFallbackOrFallbackAlternate(idAndParts.id, msg.getAlternateId().getAsLong(), fallbackIdAndParts.id, fallback.getAlternateId().getAsLong()) : this.parameterLookup.getRenderContext().usePrimaryOrAlternateIfFallback(idAndParts.id, msg.getAlternateId().getAsLong(), fallbackIdAndParts.id)) : (fallback.getAlternateId().isPresent() ? this.parameterLookup.getRenderContext().usePrimaryIfFallbackOrFallbackAlternate(idAndParts.id, fallbackIdAndParts.id, fallback.getAlternateId().getAsLong()) : this.parameterLookup.getRenderContext().usePrimaryMsgIfFallback(idAndParts.id, fallbackIdAndParts.id));
            ControlFlow.IfBlock ifAvailableRenderDefault = ControlFlow.IfBlock.create(Branch.ifTrue(cond), renderDefault);
            return ControlFlow.ifElseChain((List<ControlFlow.IfBlock>)ImmutableList.of((Object)ifAvailableRenderDefault), Optional.of(this.getMsgCompiler().compileMessage(fallbackIdAndParts, fallback, escapingDirectives, true)));
        }
        return renderDefault;
    }

    @Override
    protected Statement visitVeLogNode(VeLogNode node) {
        final Label restartPoint = new Label();
        final SoyExpression veData = this.exprCompiler.compileSubExpression(node.getVeDataExpression(), this.detachState.createExpressionDetacher(restartPoint));
        final Expression hasLogger = this.parameterLookup.getRenderContext().hasLogger();
        final Statement exitStatement = ControlFlow.IfBlock.create(Branch.ifTrue(hasLogger), this.appendableExpression.exitLoggableElement().toStatement()).asStatement();
        if (node.getLogonlyExpression() != null) {
            final SoyExpression logonlyExpression = this.exprCompiler.compileSubExpression(node.getLogonlyExpression(), this.detachState.createExpressionDetacher(restartPoint)).unboxAsBoolean();
            final Statement body = Statement.concat(this.visitChildrenInNewScope(node));
            return new Statement(){

                @Override
                protected void doGen(CodeBuilder cb) {
                    cb.mark(restartPoint);
                    logonlyExpression.gen(cb);
                    Label noLogger = new Label();
                    hasLogger.gen(cb);
                    cb.ifZCmp(153, noLogger);
                    veData.gen(cb);
                    MethodRefs.CREATE_LOG_STATEMENT.invokeUnchecked(cb);
                    SoyNodeCompiler.this.appendableExpression.gen(cb);
                    cb.swap();
                    AppendableExpression.ENTER_LOGGABLE_STATEMENT.invokeUnchecked(cb);
                    cb.pop();
                    Label bodyLabel = new Label();
                    cb.goTo(bodyLabel);
                    cb.mark(noLogger);
                    cb.ifZCmp(153, bodyLabel);
                    cb.throwException(BytecodeUtils.ILLEGAL_STATE_EXCEPTION_TYPE, "Cannot set logonly=\"true\" unless there is a logger configured");
                    cb.mark(bodyLabel);
                    body.gen(cb);
                    exitStatement.gen(cb);
                }
            };
        }
        Statement enterStatement = ControlFlow.IfBlock.create(Branch.ifTrue(hasLogger), this.appendableExpression.enterLoggableElement(MethodRefs.CREATE_LOG_STATEMENT.invoke(BytecodeUtils.constant(false), veData)).toStatement().labelStart(restartPoint)).asStatement();
        return Statement.concat(enterStatement, Statement.concat(this.visitChildrenInNewScope(node)), exitStatement);
    }

    @Override
    protected Statement visitCallDelegateNode(CallDelegateNode node) {
        return this.renderCallNode(node, () -> {
            Label reattachPoint = new Label();
            Expression variantExpr = node.getDelCalleeVariantExpr() == null ? BytecodeUtils.constant("") : this.exprCompiler.compileSubExpression(node.getDelCalleeVariantExpr(), this.detachState.createExpressionDetacher(reattachPoint)).coerceToString();
            return this.parameterLookup.getRenderContext().getDeltemplate(node.getDelCalleeName(), variantExpr).labelStart(reattachPoint);
        });
    }

    @Override
    protected Statement visitCallBasicNode(final CallBasicNode node) {
        if (node.isStaticCall()) {
            final CompiledTemplateMetadata metadata = CompiledTemplateMetadata.create(node);
            final boolean isPrivateCall = CompiledTemplateMetadata.isPrivateCall(node);
            return this.renderCallNode(node, new CallGenerator(){

                @Override
                public Expression asCompiledTemplate() {
                    if (isPrivateCall) {
                        return metadata.templateMethod().invoke(new Expression[0]);
                    }
                    final RenderContextExpression renderContext = SoyNodeCompiler.this.parameterLookup.getRenderContext();
                    return new Expression(BytecodeUtils.COMPILED_TEMPLATE_TYPE, Expression.Feature.NON_JAVA_NULLABLE.asFeatures()){

                        @Override
                        protected void doGen(CodeBuilder adapter) {
                            renderContext.gen(adapter);
                            adapter.visitInvokeDynamicInsn("template", TEMPLATE_METHOD_DESCRIPTOR, STATIC_TEMPLATE_HANDLE, new Object[]{node.getCalleeName()});
                        }
                    };
                }

                @Override
                public Optional<DirectPositionalCallGenerator> asDirectPositionalCall() {
                    if (metadata.hasPositionalSignature()) {
                        final MethodRef positionalRenderMethod = metadata.positionalRenderMethod().get();
                        return Optional.of(new DirectPositionalCallGenerator(){

                            @Override
                            public TemplateType calleeType() {
                                return metadata.templateType();
                            }

                            @Override
                            public Expression call(final List<Expression> params, final AppendableExpression appendable, final RenderContextExpression renderContext) {
                                if (isPrivateCall) {
                                    return positionalRenderMethod.invoke(Iterables.concat(params, (Iterable)ImmutableList.of((Object)appendable, (Object)renderContext)));
                                }
                                return new Expression(BytecodeUtils.RENDER_RESULT_TYPE){

                                    @Override
                                    protected void doGen(CodeBuilder adapter) {
                                        params.forEach(p -> p.gen(adapter));
                                        appendable.gen(adapter);
                                        renderContext.gen(adapter);
                                        adapter.visitInvokeDynamicInsn("call", positionalRenderMethod.method().getDescriptor(), STATIC_CALL_HANDLE, new Object[]{node.getCalleeName()});
                                    }
                                };
                            }
                        });
                    }
                    return Optional.empty();
                }

                @Override
                public Optional<DirectCallGenerator> asDirectCall() {
                    return Optional.of((params, appendable, renderContext) -> {
                        if (isPrivateCall) {
                            return metadata.renderMethod().invoke(params, appendable, renderContext);
                        }
                        return new Expression(this, BytecodeUtils.RENDER_RESULT_TYPE){

                            @Override
                            protected void doGen(CodeBuilder adapter) {
                                params.gen(adapter);
                                appendable.gen(adapter);
                                renderContext.gen(adapter);
                                adapter.visitInvokeDynamicInsn("call", metadata.renderMethod().method().getDescriptor(), STATIC_CALL_HANDLE, new Object[]{node.getCalleeName()});
                            }
                        };
                    });
                }
            });
        }
        return this.renderCallNode(node, () -> this.exprCompiler.compileRootExpression(node.getCalleeExpr(), this.detachState).checkedCast(BytecodeUtils.TEMPLATE_VALUE_TYPE).invoke(MethodRefs.GET_COMPILED_TEMPLATE_FROM_VALUE, new Expression[0]).checkedCast(BytecodeUtils.COMPILED_TEMPLATE_TYPE));
    }

    private static DirectCallGenerator directCallFromTemplateExpression(Expression compiledTemplateExpression) {
        return (params, output, context) -> compiledTemplateExpression.invoke(MethodRefs.COMPILED_TEMPLATE_RENDER, params, output, context);
    }

    private static BoundCallGenerator simpleCall(Expression compiledTemplateExpression, Expression params) {
        return SoyNodeCompiler.simpleCall(SoyNodeCompiler.directCallFromTemplateExpression(compiledTemplateExpression), params);
    }

    private static BoundCallGenerator simpleCall(DirectCallGenerator callGenerator, Expression params) {
        return (output, context) -> callGenerator.call(params, output, context);
    }

    private Statement renderCallNode(CallNode node, CallGenerator callGenerator) {
        BoundCallGenerator boundCall;
        Statement initParams;
        Statement initAppendable = Statement.NULL_STATEMENT;
        Statement flushAppendable = Statement.NULL_STATEMENT;
        AppendableExpression appendable = this.appendableExpression;
        TemplateVariableManager.Scope renderScope = this.variables.enterScope();
        RecordOrPositional paramsExpression = this.prepareParamsHelper(node);
        Statement initCallee = Statement.NULL_STATEMENT;
        if (!PrintDirectives.areAllPrintDirectivesStreamable(node) || node.isErrorFallbackSkip()) {
            ExpressionAndInitializer expressionAndInitializer = paramsExpression.asRecord(renderScope);
            initParams = expressionAndInitializer.initializer();
            Expression calleeExpression = MethodRefs.BUFFER_TEMPLATE.invoke(callGenerator.asCompiledTemplate(), BytecodeUtils.constant(node.isErrorFallbackSkip()), !PrintDirectives.areAllPrintDirectivesStreamable(node) ? MethodRefs.ESCAPING_BUFFERED_RENDER_DONE_FN.invoke(this.getEscapingDirectivesList(node)) : MethodRefs.REPLAYING_BUFFERED_RENDER_DONE_FN.invoke(new Expression[0]));
            TemplateVariableManager.Variable calleeVariable = renderScope.createSynthetic(SyntheticVarName.renderee(), calleeExpression, TemplateVariableManager.SaveStrategy.STORE);
            initCallee = calleeVariable.initializer();
            boundCall = SoyNodeCompiler.simpleCall(calleeVariable.accessor(), expressionAndInitializer.expression());
        } else {
            Optional<ListOfExpressionsAndInitializer> explicitParams;
            Optional<DirectPositionalCallGenerator> asDirectPositionalCall = callGenerator.asDirectPositionalCall();
            if (asDirectPositionalCall.isPresent() && (explicitParams = paramsExpression.asPositionalParams(node, renderScope, asDirectPositionalCall.get().calleeType())).isPresent()) {
                initParams = explicitParams.get().initializer();
                boundCall = (output, context) -> ((DirectPositionalCallGenerator)asDirectPositionalCall.get()).call((List<Expression>)((ListOfExpressionsAndInitializer)explicitParams.get()).expressions(), output, context);
            } else {
                Optional<DirectCallGenerator> asDirectCall = callGenerator.asDirectCall();
                ExpressionAndInitializer expressionAndInitializer = paramsExpression.asRecord(renderScope);
                initParams = expressionAndInitializer.initializer();
                if (asDirectCall.isPresent()) {
                    boundCall = SoyNodeCompiler.simpleCall(asDirectCall.get(), expressionAndInitializer.expression());
                } else {
                    TemplateVariableManager.Variable calleeVariable = renderScope.createSynthetic(SyntheticVarName.renderee(), callGenerator.asCompiledTemplate(), TemplateVariableManager.SaveStrategy.STORE);
                    initCallee = calleeVariable.initializer();
                    boundCall = SoyNodeCompiler.simpleCall(calleeVariable.accessor(), expressionAndInitializer.expression());
                }
            }
        }
        if (!node.getEscapingDirectives().isEmpty() && PrintDirectives.areAllPrintDirectivesStreamable(node)) {
            PrintDirectives.AppendableAndFlushBuffersDepth wrappedAppendable = PrintDirectives.applyStreamingEscapingDirectives(node.getEscapingDirectives(), appendable, this.parameterLookup.getPluginContext());
            TemplateVariableManager.Variable variable = renderScope.createSynthetic(SyntheticVarName.appendable(), wrappedAppendable.appendable(), TemplateVariableManager.SaveStrategy.STORE);
            initAppendable = variable.initializer();
            appendable = AppendableExpression.forExpression(variable.accessor());
            if (wrappedAppendable.flushBuffersDepth() >= 0) {
                flushAppendable = appendable.flushBuffers(wrappedAppendable.flushBuffersDepth());
            }
        }
        Expression callRender = boundCall.call(appendable, this.parameterLookup.getRenderContext()).withSourceLocation(node.getSourceLocation());
        Statement callCallee = this.detachState.detachForRender(callRender);
        return Statement.concat(initParams, initCallee, initAppendable, callCallee, flushAppendable, renderScope.exitScope());
    }

    private Expression getEscapingDirectivesList(CallNode node) {
        ImmutableList<SoyPrintDirective> escapingDirectives = node.getEscapingDirectives();
        ArrayList<Expression> directiveExprs = new ArrayList<Expression>(escapingDirectives.size());
        for (SoyPrintDirective directive : escapingDirectives) {
            directiveExprs.add(this.parameterLookup.getRenderContext().getPrintDirective(directive.getName()));
        }
        return BytecodeUtils.asImmutableList(directiveExprs);
    }

    private RecordOrPositional prepareParamsHelper(CallNode node) {
        if (node instanceof CallBasicNode && ((CallBasicNode)node).getVariantExpr() != null) {
            CallBasicNode callBasicNode = (CallBasicNode)node;
            node.addChild(new CallParamValueNode(0, callBasicNode.getVariantExpr().getSourceLocation(), Identifier.create("__modifiable_variant__", SourceLocation.UNKNOWN), callBasicNode.getVariantExpr().getRoot()));
        }
        ImmutableMap<String, Supplier<Expression>> explicitParams = this.compileExplicitParams(node);
        Supplier<Expression> recordExpression = () -> this.getParamStoreExpression(node, (Map<String, Supplier<Expression>>)explicitParams);
        return RecordOrPositional.create(recordExpression, node.isPassingData() ? Optional.empty() : Optional.of(explicitParams));
    }

    private ImmutableMap<String, Supplier<Expression>> compileExplicitParams(CallNode node) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (CallParamNode child : node.getChildren()) {
            String paramKey = child.getKey().identifier();
            Supplier<Expression> valueExpr = child instanceof CallParamContentNode ? () -> new LazyClosureCompiler(this).compileLazyContent("param", (CallParamContentNode)child, paramKey).soyValueProvider() : () -> new LazyClosureCompiler(this).compileLazyExpression("param", child, paramKey, ((CallParamValueNode)child).getExpr()).soyValueProvider();
            builder.put((Object)child.getKey().identifier(), valueExpr);
        }
        return builder.buildOrThrow();
    }

    private Expression getParamStoreExpression(CallNode node, Map<String, Supplier<Expression>> params) {
        LinkedHashMap<String, Expression> paramsMap = new LinkedHashMap<String, Expression>();
        params.forEach((k, v) -> paramsMap.put((String)k, (Expression)v.get()));
        if (node.isPassingAllData()) {
            this.maybeAddDefaultParams(node, paramsMap);
        }
        Label reattachDataLabel = new Label();
        Optional<Expression> baseRecord = node.isPassingAllData() ? Optional.of(this.parameterLookup.getParamsRecord()) : (node.isPassingData() ? Optional.of(this.getDataRecordExpression(node, reattachDataLabel)) : Optional.empty());
        return BytecodeUtils.newParamStore(baseRecord, paramsMap).labelStart(reattachDataLabel);
    }

    private void maybeAddDefaultParams(CallNode node, Map<String, Expression> paramsMap) {
        for (TemplateParam param : node.getNearestAncestor(TemplateNode.class).getParams()) {
            if (!param.hasDefault() || paramsMap.containsKey(param.name())) continue;
            paramsMap.put(param.name(), this.parameterLookup.getParam(param));
        }
    }

    private Expression getDataRecordExpression(CallNode node, Label reattachPoint) {
        return MethodRefs.PARAM_STORE_FROM_RECORD.invoke(this.exprCompiler.compileSubExpression(node.getDataExpr(), this.detachState.createExpressionDetacher(reattachPoint)).box().checkedCast(SoyRecord.class).toMaybeConstant());
    }

    @Override
    protected Statement visitLogNode(LogNode node) {
        return this.compilerWithNewAppendable(AppendableExpression.logger()).visitChildrenInNewScope(node);
    }

    @Override
    protected Statement visitLetValueNode(LetValueNode node) {
        return this.storeClosure(new LazyClosureCompiler(this).compileLazyExpression("let", node, node.getVarName(), node.getExpr()));
    }

    @Override
    protected Statement visitLetContentNode(LetContentNode node) {
        return this.storeClosure(new LazyClosureCompiler(this).compileLazyContent("let", node, node.getVarName()));
    }

    Statement storeClosure(LazyClosureCompiler.LazyClosure newLetValue) {
        if (newLetValue.isTrivial()) {
            this.currentScope.createTrivial(newLetValue.name(), newLetValue.soyValueProvider());
            return Statement.NULL_STATEMENT;
        }
        return this.currentScope.create(newLetValue.name(), newLetValue.soyValueProvider(), TemplateVariableManager.SaveStrategy.STORE).initializer();
    }

    @Override
    protected Statement visitMsgHtmlTagNode(MsgHtmlTagNode node) {
        return Statement.concat(this.visitChildren(node));
    }

    @Override
    protected Statement visitSoyNode(SoyNode node) {
        throw new UnsupportedOperationException("The jbcsrc backend doesn't support: " + String.valueOf((Object)node.getKind()) + " nodes yet.");
    }

    private MsgCompiler getMsgCompiler() {
        return new MsgCompiler(this.detachState, this.parameterLookup, this.variables, this.appendableExpression, new MsgCompiler.PlaceholderCompiler(){

            @Override
            public MsgCompiler.PlaceholderCompiler.Placeholder compile(ExprRootNode node, ExpressionDetacher expressionDetatcher) {
                return MsgCompiler.PlaceholderCompiler.Placeholder.create(SoyNodeCompiler.this.expressionToSoyValueProviderCompiler.compile(node, expressionDetatcher), SoyNodeCompiler.this.exprCompiler.requiresDetach(node));
            }

            @Override
            public MsgCompiler.PlaceholderCompiler.Placeholder compile(String phname, SoyNode.StandaloneNode node, ExtraCodeCompiler prefix, ExtraCodeCompiler suffix) {
                LetContentNode fakeLet = LetContentNode.forVariable(-1, node.getSourceLocation(), "$" + phname, node.getSourceLocation(), SanitizedContentKind.TEXT);
                MsgPlaceholderNode placeholderParent = (MsgPlaceholderNode)node.getParent();
                Preconditions.checkState((placeholderParent.numChildren() == 1 ? 1 : 0) != 0, (String)"expected placeholder %s (%s) to be the only child of our parent: %s", (Object)phname, (Object)node, (Object)placeholderParent);
                fakeLet.addChild(node);
                placeholderParent.addChild(fakeLet);
                LazyClosureCompiler.LazyClosure closure = new LazyClosureCompiler(SoyNodeCompiler.this).compileLazyContent("ph", fakeLet, phname, prefix, suffix);
                placeholderParent.removeChild(fakeLet);
                placeholderParent.addChild(node);
                return MsgCompiler.PlaceholderCompiler.Placeholder.create(closure.soyValueProvider(), closure.requiresDetachLogicToResolve());
            }
        });
    }

    SoyNodeCompiler compilerWithNewAppendable(AppendableExpression appendable) {
        return new SoyNodeCompiler(this.analysis, this.innerClasses, this.detachState, this.variables, this.parameterLookup, this.fields, appendable, this.exprCompiler, this.expressionToSoyValueProviderCompiler, this.constantCompiler, this.javaSourceFunctionCompiler, this.fileSetMetadata);
    }

    private static /* synthetic */ Stream lambda$visitPrintNode$9(PrintDirectiveNode pdn) {
        return pdn.getExprList().stream();
    }

    @AutoValue
    static abstract class RecordOrPositional {
        RecordOrPositional() {
        }

        static RecordOrPositional create(Expression record) {
            return RecordOrPositional.create((Supplier<Expression>)Suppliers.ofInstance((Object)record), Optional.empty());
        }

        static RecordOrPositional create(Supplier<Expression> record, Optional<ImmutableMap<String, Supplier<Expression>>> explicit) {
            return new AutoValue_SoyNodeCompiler_RecordOrPositional(record, explicit);
        }

        ExpressionAndInitializer asRecord(TemplateVariableManager.Scope scope) {
            Expression record = this.record().get();
            Statement initialize = Statement.NULL_STATEMENT;
            if (!record.isCheap()) {
                TemplateVariableManager.Variable paramsVariable = scope.createSynthetic(SyntheticVarName.params(), record, TemplateVariableManager.SaveStrategy.STORE);
                record = paramsVariable.accessor();
                initialize = paramsVariable.initializer();
            }
            return ExpressionAndInitializer.create(record, initialize);
        }

        Optional<ListOfExpressionsAndInitializer> asPositionalParams(CallNode node, TemplateVariableManager.Scope scope, TemplateType calleeType) {
            if (!this.explicit().isPresent()) {
                return Optional.empty();
            }
            ArrayList<Statement> initStatements = new ArrayList<Statement>();
            ImmutableList.Builder builder = ImmutableList.builder();
            HashMap explicit = new HashMap((Map)this.explicit().get());
            ImmutableMap keyToParam = null;
            for (TemplateType.Parameter param : calleeType.getActualParameters()) {
                Expression value;
                Supplier supplier = (Supplier)explicit.remove(param.getName());
                Expression expression = value = supplier == null ? FieldRef.UNDEFINED_DATA.accessor() : (Expression)supplier.get();
                if (!value.isCheap()) {
                    if (keyToParam == null) {
                        keyToParam = (ImmutableMap)node.getChildren().stream().collect(ImmutableMap.toImmutableMap(n -> n.getKey().identifier(), child -> child));
                    }
                    TemplateVariableManager.Variable variable = scope.createSynthetic(SyntheticVarName.forParam((CallParamNode)keyToParam.get((Object)param.getName())), value, TemplateVariableManager.SaveStrategy.STORE);
                    value = variable.accessor();
                    initStatements.add(variable.initializer());
                }
                builder.add((Object)value);
            }
            if (!explicit.isEmpty()) {
                throw new AssertionError((Object)("failed to use: " + String.valueOf(explicit)));
            }
            return Optional.of(ListOfExpressionsAndInitializer.create((ImmutableList<Expression>)builder.build(), Statement.concat(initStatements)));
        }

        abstract Supplier<Expression> record();

        abstract Optional<ImmutableMap<String, Supplier<Expression>>> explicit();
    }

    @AutoValue
    static abstract class ListOfExpressionsAndInitializer {
        ListOfExpressionsAndInitializer() {
        }

        static ListOfExpressionsAndInitializer create(ImmutableList<Expression> expressions, Statement initializer) {
            return new AutoValue_SoyNodeCompiler_ListOfExpressionsAndInitializer(expressions, initializer);
        }

        abstract ImmutableList<Expression> expressions();

        abstract Statement initializer();
    }

    @AutoValue
    static abstract class ExpressionAndInitializer {
        ExpressionAndInitializer() {
        }

        static ExpressionAndInitializer create(Expression expression, Statement initializer) {
            return new AutoValue_SoyNodeCompiler_ExpressionAndInitializer(expression, initializer);
        }

        abstract Expression expression();

        abstract Statement initializer();
    }

    private static interface DirectPositionalCallGenerator {
        public Expression call(List<Expression> var1, AppendableExpression var2, RenderContextExpression var3);

        public TemplateType calleeType();
    }

    @FunctionalInterface
    private static interface DirectCallGenerator {
        public Expression call(Expression var1, AppendableExpression var2, RenderContextExpression var3);
    }

    @FunctionalInterface
    private static interface BoundCallGenerator {
        public Expression call(AppendableExpression var1, RenderContextExpression var2);
    }

    @FunctionalInterface
    private static interface CallGenerator {
        public Expression asCompiledTemplate();

        default public Optional<DirectCallGenerator> asDirectCall() {
            return Optional.empty();
        }

        default public Optional<DirectPositionalCallGenerator> asDirectPositionalCall() {
            return Optional.empty();
        }
    }

    @AutoValue
    static abstract class CompiledForeachRangeArgs {
        CompiledForeachRangeArgs() {
        }

        abstract Expression start();

        abstract Expression end();

        abstract Expression step();

        abstract ImmutableList<Statement> initStatements();
    }

    class StatementAndStartLabel {
        final Statement statement;
        final Label startLabel = new Label();

        StatementAndStartLabel(SoyNodeCompiler this$0, SwitchCaseNode caseNode) {
            this.statement = this$0.visitChildrenInNewScope(caseNode).labelStart(this.startLabel);
        }
    }
}

