/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc.api;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SoyInjector;
import com.google.template.soy.data.SoyTemplate;
import com.google.template.soy.data.SoyTemplateData;
import com.google.template.soy.data.internal.ParamStore;
import com.google.template.soy.jbcsrc.api.AdvisingAppendable;
import com.google.template.soy.jbcsrc.api.AppendableAsAdvisingAppendable;
import com.google.template.soy.jbcsrc.api.RenderResult;
import com.google.template.soy.logging.SoyLogger;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.parseinfo.TemplateName;
import com.google.template.soy.shared.SoyCssRenamingMap;
import com.google.template.soy.shared.SoyCssTracker;
import com.google.template.soy.shared.SoyIdRenamingMap;
import java.io.IOException;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;

public interface SoySauce {
    @Deprecated
    public Renderer renderTemplate(String var1);

    default public Renderer renderTemplate(TemplateName template) {
        return this.renderTemplate(template.name());
    }

    default public Renderer newRenderer(SoyTemplate params) {
        return this.renderTemplate(params.getTemplateName()).setData(params.getParamsAsMap());
    }

    public ImmutableSet<String> getTransitiveIjParamsForTemplate(String var1);

    public ImmutableList<String> getAllRequiredCssNamespaces(String var1, Predicate<String> var2, boolean var3);

    default public ImmutableList<String> getAllRequiredCssNamespaces(SoyTemplate template, Predicate<String> enabledMods, boolean collectCssFromDelvariants) {
        return this.getAllRequiredCssNamespaces(template.getTemplateName(), enabledMods, collectCssFromDelvariants);
    }

    public ImmutableList<String> getAllRequiredCssPaths(String var1, Predicate<String> var2, boolean var3);

    default public ImmutableList<String> getAllRequiredCssPaths(SoyTemplate template, Predicate<String> enabledMods, boolean collectCssFromDelvariants) {
        return this.getAllRequiredCssPaths(template.getTemplateName(), enabledMods, collectCssFromDelvariants);
    }

    public boolean hasTemplate(String var1);

    public static interface Continuation<T> {
        public RenderResult result();

        public T get();

        @CheckReturnValue
        public Continuation<T> continueRender();

        @Deprecated
        public String toString();
    }

    public static interface WriteContinuation {
        public RenderResult result();

        @CheckReturnValue
        public WriteContinuation continueRender() throws IOException;

        default public void assertDone() {
            Preconditions.checkState((boolean)this.result().isDone(), (String)"Expected to be done, got: %s", (Object)this.result());
        }
    }

    public static interface Renderer {
        @CanIgnoreReturnValue
        public Renderer setData(Map<String, ?> var1);

        @CanIgnoreReturnValue
        default public Renderer setIj(Map<String, ?> record) {
            return this.setIj(SoyInjector.fromStringMap(record));
        }

        @CanIgnoreReturnValue
        default public Renderer setIj(SoyTemplateData data) {
            return this.setIj(SoyInjector.fromParamStore((ParamStore)data.getParamsAsRecord()));
        }

        @CanIgnoreReturnValue
        public Renderer setIj(SoyInjector var1);

        @CanIgnoreReturnValue
        public Renderer setPluginInstances(Map<String, ? extends Supplier<Object>> var1);

        @CanIgnoreReturnValue
        public Renderer setCssRenamingMap(SoyCssRenamingMap var1);

        @CanIgnoreReturnValue
        public Renderer setXidRenamingMap(SoyIdRenamingMap var1);

        @CanIgnoreReturnValue
        public Renderer setActiveModSelector(Predicate<String> var1);

        @CanIgnoreReturnValue
        public Renderer setMsgBundle(SoyMsgBundle var1);

        @CanIgnoreReturnValue
        public Renderer setDebugSoyTemplateInfo(boolean var1);

        @CanIgnoreReturnValue
        public Renderer setSoyLogger(SoyLogger var1);

        @CanIgnoreReturnValue
        public Renderer setCssTracker(SoyCssTracker var1);

        @CheckReturnValue
        public WriteContinuation renderHtml(AdvisingAppendable var1) throws IOException;

        @CheckReturnValue
        default public WriteContinuation renderHtml(Appendable out) throws IOException {
            return this.renderHtml(AppendableAsAdvisingAppendable.asAdvisingAppendable(out));
        }

        @CheckReturnValue
        public Continuation<SanitizedContent> renderHtml();

        @CheckReturnValue
        public WriteContinuation renderJs(AdvisingAppendable var1) throws IOException;

        @CheckReturnValue
        default public WriteContinuation renderJs(Appendable out) throws IOException {
            return this.renderJs(AppendableAsAdvisingAppendable.asAdvisingAppendable(out));
        }

        @CheckReturnValue
        public Continuation<SanitizedContent> renderJs();

        @CheckReturnValue
        public WriteContinuation renderUri(AdvisingAppendable var1) throws IOException;

        @CheckReturnValue
        default public WriteContinuation renderUri(Appendable out) throws IOException {
            return this.renderUri(AppendableAsAdvisingAppendable.asAdvisingAppendable(out));
        }

        @CheckReturnValue
        public Continuation<SanitizedContent> renderUri();

        @CheckReturnValue
        public WriteContinuation renderTrustedResourceUri(AdvisingAppendable var1) throws IOException;

        @CheckReturnValue
        default public WriteContinuation renderTrustedResourceUri(Appendable out) throws IOException {
            return this.renderTrustedResourceUri(AppendableAsAdvisingAppendable.asAdvisingAppendable(out));
        }

        @CheckReturnValue
        public Continuation<SanitizedContent> renderTrustedResourceUri();

        @CheckReturnValue
        public WriteContinuation renderAttributes(AdvisingAppendable var1) throws IOException;

        @CheckReturnValue
        default public WriteContinuation renderAttributes(Appendable out) throws IOException {
            return this.renderAttributes(AppendableAsAdvisingAppendable.asAdvisingAppendable(out));
        }

        @CheckReturnValue
        public Continuation<SanitizedContent> renderAttributes();

        @CheckReturnValue
        public WriteContinuation renderCss(AdvisingAppendable var1) throws IOException;

        @CheckReturnValue
        default public WriteContinuation renderCss(Appendable out) throws IOException {
            return this.renderCss(AppendableAsAdvisingAppendable.asAdvisingAppendable(out));
        }

        @CheckReturnValue
        public Continuation<SanitizedContent> renderCss();

        @CheckReturnValue
        public WriteContinuation renderText(AdvisingAppendable var1) throws IOException;

        @CheckReturnValue
        default public WriteContinuation renderText(Appendable out) throws IOException {
            return this.renderText(AppendableAsAdvisingAppendable.asAdvisingAppendable(out));
        }

        @CheckReturnValue
        public Continuation<String> renderText();
    }
}

