/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc.api;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.template.soy.jbcsrc.api.SoySauce;
import com.google.template.soy.jbcsrc.api.SoySauceImpl;
import com.google.template.soy.jbcsrc.shared.CompiledTemplates;
import com.google.template.soy.plugin.java.PluginInstances;
import com.google.template.soy.shared.internal.InternalPlugins;
import com.google.template.soy.shared.internal.NoOpScopedData;
import com.google.template.soy.shared.restricted.SoyFunction;
import com.google.template.soy.shared.restricted.SoyPrintDirective;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.Map;
import java.util.function.Supplier;

public final class SoySauceBuilder {
    private ImmutableList<SoyFunction> userFunctions = ImmutableList.of();
    private ImmutableList<SoyPrintDirective> userDirectives = ImmutableList.of();
    private PluginInstances userPluginInstances = PluginInstances.empty();
    private CompiledTemplates.Factory compiledTemplatesFactory = CompiledTemplates::new;
    private ClassLoader loader;

    @CanIgnoreReturnValue
    public SoySauceBuilder withPluginInstances(Map<String, ? extends Supplier<Object>> pluginInstances) {
        this.userPluginInstances = PluginInstances.of(pluginInstances);
        return this;
    }

    @CanIgnoreReturnValue
    public SoySauceBuilder withClassLoader(ClassLoader loader) {
        this.loader = loader;
        return this;
    }

    @CanIgnoreReturnValue
    SoySauceBuilder withFunctions(Iterable<? extends SoyFunction> userFunctions) {
        this.userFunctions = InternalPlugins.filterDuplicateFunctions(userFunctions);
        return this;
    }

    @CanIgnoreReturnValue
    SoySauceBuilder withDirectives(Iterable<? extends SoyPrintDirective> userDirectives) {
        this.userDirectives = InternalPlugins.filterDuplicateDirectives(userDirectives);
        return this;
    }

    @CanIgnoreReturnValue
    SoySauceBuilder withCustomCompiledTemplatesFactory(CompiledTemplates.Factory compiledTemplatesFactory) {
        this.compiledTemplatesFactory = compiledTemplatesFactory;
        return this;
    }

    public SoySauce build() {
        if (this.loader == null) {
            this.loader = SoySauceBuilder.class.getClassLoader();
        }
        return new SoySauceImpl(this.compiledTemplatesFactory.create(SoySauceBuilder.readDelTemplatesFromMetaInf(this.loader), this.loader), this.userFunctions, (ImmutableList<? extends SoyPrintDirective>)ImmutableList.builder().addAll(InternalPlugins.internalDirectives(NoOpScopedData.INSTANCE)).addAll(this.userDirectives).build(), this.userPluginInstances);
    }

    private static ImmutableSet<String> readDelTemplatesFromMetaInf(ClassLoader loader) {
        URL url = null;
        try {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            Enumeration<URL> resources = loader.getResources("META-INF/services/com.google.template.soy.deltemplates");
            while (resources.hasMoreElements()) {
                url = resources.nextElement();
                InputStream in = url.openStream();
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
                    String line = reader.readLine();
                    while (line != null) {
                        builder.add((Object)line);
                        line = reader.readLine();
                    }
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
            return builder.build();
        }
        catch (IOException iox) {
            throw new RuntimeException("Unable to read deltemplate listing in " + String.valueOf(url), iox);
        }
    }
}

