/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc.internal;

import com.google.common.collect.ImmutableMap;
import com.google.template.soy.jbcsrc.internal.AbstractMemoryClassLoader;
import com.google.template.soy.jbcsrc.internal.ClassData;

public final class MemoryClassLoader
extends AbstractMemoryClassLoader {
    private final ImmutableMap<String, ClassData> classesByName;

    public MemoryClassLoader(Iterable<ClassData> classes) {
        this.classesByName = MemoryClassLoader.indexByClassname(classes);
    }

    public MemoryClassLoader(ClassLoader parent, Iterable<ClassData> classes) {
        super(parent);
        this.classesByName = MemoryClassLoader.indexByClassname(classes);
    }

    @Override
    protected ClassData getClassData(String name) {
        return (ClassData)this.classesByName.get((Object)name);
    }

    private static ImmutableMap<String, ClassData> indexByClassname(Iterable<ClassData> classes) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ClassData classData : classes) {
            builder.put((Object)classData.type().className(), (Object)classData);
        }
        return builder.build();
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

