/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc.restricted;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public final class AnnotationRef<T extends Annotation> {
    private final Class<T> annType;
    private final String typeDescriptor;
    private final boolean isRuntimeVisible;
    private final ImmutableMap<Method, FieldWriter> writers;

    public static <T extends Annotation> AnnotationRef<T> forType(Class<T> annType) {
        Preconditions.checkArgument((boolean)annType.isAnnotation());
        return new AnnotationRef<T>(annType);
    }

    private AnnotationRef(Class<T> annType) {
        this.annType = annType;
        Retention retention = annType.getAnnotation(Retention.class);
        this.isRuntimeVisible = retention != null && retention.value() == RetentionPolicy.RUNTIME;
        this.typeDescriptor = Type.getDescriptor(annType);
        ImmutableMap.Builder writersBuilder = ImmutableMap.builder();
        Method[] methods = annType.getDeclaredMethods();
        Arrays.sort(methods, Comparator.comparing(Method::toGenericString));
        for (Method method : methods) {
            AnnotationRef<?> forType;
            if (method.getParameterTypes().length != 0 || Modifier.isStatic(method.getModifiers())) continue;
            Class<?> returnType = method.getReturnType();
            if (returnType.isArray()) {
                if (returnType.getComponentType().isAnnotation()) {
                    forType = AnnotationRef.forType(returnType.getComponentType());
                    writersBuilder.put((Object)method, (Object)AnnotationRef.annotationArrayFieldWriter(method.getName(), forType));
                    continue;
                }
                writersBuilder.put((Object)method, (Object)AnnotationRef.simpleArrayFieldWriter(method.getName()));
                continue;
            }
            if (returnType.isAnnotation()) {
                forType = AnnotationRef.forType(returnType);
                writersBuilder.put((Object)method, (Object)AnnotationRef.annotationFieldWriter(method.getName(), forType));
                continue;
            }
            if (returnType.isEnum()) {
                writersBuilder.put((Object)method, (Object)AnnotationRef.simpleEumFieldWriter(method.getName(), returnType));
                continue;
            }
            writersBuilder.put((Object)method, (Object)AnnotationRef.simpleFieldWriter(method.getName()));
        }
        this.writers = writersBuilder.build();
    }

    public void write(T instance, ClassVisitor visitor) {
        this.doWrite(instance, visitor.visitAnnotation(this.typeDescriptor, this.isRuntimeVisible));
    }

    public void write(T instance, MethodVisitor visitor) {
        this.doWrite(instance, visitor.visitAnnotation(this.typeDescriptor, this.isRuntimeVisible));
    }

    private void doWrite(T instance, AnnotationVisitor annVisitor) {
        for (Map.Entry entry : this.writers.entrySet()) {
            ((FieldWriter)entry.getValue()).write(annVisitor, this.invokeExplosively(instance, (Method)entry.getKey()), ((Method)entry.getKey()).getDefaultValue());
        }
        annVisitor.visitEnd();
    }

    private Object invokeExplosively(T instance, Method key) {
        Object invoke;
        try {
            invoke = key.invoke(instance, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
        return invoke;
    }

    private static <T extends Annotation> FieldWriter annotationFieldWriter(String name, AnnotationRef<T> ref) {
        return (visitor, value, defaultValue) -> {
            if (!Objects.equals(value, defaultValue)) {
                ref.doWrite((Annotation)ref.annType.cast(value), visitor.visitAnnotation(name, ref.typeDescriptor));
            }
        };
    }

    private static FieldWriter simpleFieldWriter(String name) {
        return (visitor, value, defaultValue) -> {
            if (!Objects.equals(value, defaultValue)) {
                visitor.visit(name, value);
            }
        };
    }

    private static FieldWriter simpleEumFieldWriter(String name, Class<?> enumType) {
        String descriptor = Type.getDescriptor(enumType);
        return (visitor, value, defaultValue) -> {
            if (!Objects.equals(value, defaultValue)) {
                visitor.visitEnum(name, descriptor, ((Enum)value).name());
            }
        };
    }

    private static boolean areEqualGenericArrays(Object a, Object b) {
        int len;
        int defaultLen = Array.getLength(a);
        if (defaultLen == (len = Array.getLength(b))) {
            for (int i = 0; i < len; ++i) {
                if (Objects.equals(Array.get(a, i), Array.get(b, i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static FieldWriter simpleArrayFieldWriter(String name) {
        return (visitor, value, defaultValue) -> {
            if (!AnnotationRef.areEqualGenericArrays(value, defaultValue)) {
                int len = Array.getLength(value);
                AnnotationVisitor arrayVisitor = visitor.visitArray(name);
                for (int i = 0; i < len; ++i) {
                    arrayVisitor.visit(null, Array.get(value, i));
                }
                arrayVisitor.visitEnd();
            }
        };
    }

    private static <T extends Annotation> FieldWriter annotationArrayFieldWriter(String name, AnnotationRef<T> ref) {
        return (visitor, value, defaultValue) -> {
            if (!AnnotationRef.areEqualGenericArrays(value, defaultValue)) {
                int len = Array.getLength(value);
                AnnotationVisitor arrayVisitor = visitor.visitArray(name);
                for (int i = 0; i < len; ++i) {
                    ref.doWrite((Annotation)ref.annType.cast(Array.get(value, i)), arrayVisitor.visitAnnotation(null, ref.typeDescriptor));
                }
                arrayVisitor.visitEnd();
            }
        };
    }

    private static interface FieldWriter {
        public void write(AnnotationVisitor var1, Object var2, Object var3);
    }
}

