/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc.restricted;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.DoNotCall;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.internal.Converters;
import com.google.template.soy.data.internal.RuntimeMapTypeTracker;
import com.google.template.soy.jbcsrc.restricted.Branch;
import com.google.template.soy.jbcsrc.restricted.BytecodeUtils;
import com.google.template.soy.jbcsrc.restricted.CodeBuilder;
import com.google.template.soy.jbcsrc.restricted.Expression;
import com.google.template.soy.jbcsrc.restricted.FieldRef;
import com.google.template.soy.jbcsrc.restricted.MethodRefs;
import com.google.template.soy.jbcsrc.restricted.SoyRuntimeType;
import com.google.template.soy.types.BoolType;
import com.google.template.soy.types.FloatType;
import com.google.template.soy.types.IntType;
import com.google.template.soy.types.LegacyObjectMapType;
import com.google.template.soy.types.ListType;
import com.google.template.soy.types.MapType;
import com.google.template.soy.types.NullType;
import com.google.template.soy.types.SanitizedType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypes;
import com.google.template.soy.types.StringType;
import com.google.template.soy.types.UndefinedType;
import com.google.template.soy.types.UnknownType;
import java.util.List;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;

public final class SoyExpression
extends Expression {
    public static final SoyExpression SOY_NULL = new SoyExpression(SoyRuntimeType.getBoxedType(NullType.getInstance()), BytecodeUtils.soyNull());
    public static final SoyExpression SOY_UNDEFINED = new SoyExpression(SoyRuntimeType.getBoxedType(UndefinedType.getInstance()), BytecodeUtils.soyUndefined());
    public static final SoyExpression TRUE = SoyExpression.forBool(BytecodeUtils.constant(true));
    public static final SoyExpression FALSE = SoyExpression.forBool(BytecodeUtils.constant(false));
    private final SoyRuntimeType soyRuntimeType;
    final Expression delegate;

    public static SoyExpression forSoyValue(SoyType type, Expression delegate) {
        if (delegate instanceof SoyExpression) {
            return SoyExpression.forSoyValue(type, ((SoyExpression)delegate).delegate);
        }
        return new SoyExpression(SoyRuntimeType.getBoxedType(type), delegate);
    }

    public static SoyExpression forBool(Expression delegate) {
        return new SoyExpression(SoyExpression.getUnboxedType(BoolType.getInstance()), delegate);
    }

    @DoNotCall
    public static SoyExpression forBool(SoyExpression delegate) {
        throw new UnsupportedOperationException();
    }

    public static SoyExpression forFloat(Expression delegate) {
        return new SoyExpression(SoyExpression.getUnboxedType(FloatType.getInstance()), delegate);
    }

    @DoNotCall
    public static SoyExpression forFloat(SoyExpression delegate) {
        throw new UnsupportedOperationException();
    }

    public static SoyExpression forInt(Expression delegate) {
        return new SoyExpression(SoyExpression.getUnboxedType(IntType.getInstance()), delegate);
    }

    @DoNotCall
    public static SoyExpression forInt(SoyExpression delegate) {
        throw new UnsupportedOperationException();
    }

    public static SoyExpression forString(Expression delegate) {
        return new SoyExpression(SoyExpression.getUnboxedType(StringType.getInstance()), delegate);
    }

    @DoNotCall
    public static SoyExpression forString(SoyExpression delegate) {
        throw new UnsupportedOperationException();
    }

    public static SoyExpression forList(ListType listType, Expression delegate) {
        return new SoyExpression(SoyExpression.getUnboxedType(listType), delegate);
    }

    @DoNotCall
    public static SoyExpression forList(ListType listType, SoyExpression delegate) {
        throw new UnsupportedOperationException();
    }

    public static SoyExpression forBoxedList(SoyType listType, Expression delegate) {
        Preconditions.checkArgument((boolean)SoyTypes.isKindOrUnionOfKind(listType, SoyType.Kind.LIST));
        return new SoyExpression(SoyRuntimeType.getBoxedType(listType), delegate);
    }

    @DoNotCall
    public static SoyExpression forBoxedList(ListType listType, SoyExpression delegate) {
        throw new UnsupportedOperationException();
    }

    public static SoyExpression forLegacyObjectMap(LegacyObjectMapType mapType, Expression delegate) {
        return new SoyExpression(SoyRuntimeType.getBoxedType(mapType), delegate);
    }

    @DoNotCall
    public static SoyExpression forLegacyObjectMap(LegacyObjectMapType mapType, SoyExpression delegate) {
        throw new UnsupportedOperationException();
    }

    public static SoyExpression forMap(MapType mapType, Expression delegate) {
        return new SoyExpression(SoyRuntimeType.getBoxedType(mapType), delegate);
    }

    @DoNotCall
    public static SoyExpression forMap(MapType mapType, SoyExpression delegate) {
        throw new UnsupportedOperationException();
    }

    public static SoyExpression forProto(SoyRuntimeType type, Expression delegate) {
        Preconditions.checkArgument((type.soyType().getKind() == SoyType.Kind.PROTO ? 1 : 0) != 0);
        return new SoyExpression(type, delegate);
    }

    @DoNotCall
    public static SoyExpression forProto(SoyRuntimeType type, SoyExpression delegate) {
        throw new UnsupportedOperationException();
    }

    public static SoyExpression forRuntimeType(SoyRuntimeType type, Expression delegate) {
        return new SoyExpression(type, delegate);
    }

    @DoNotCall
    public static SoyExpression forRuntimeType(SoyRuntimeType type, SoyExpression delegate) {
        throw new UnsupportedOperationException();
    }

    public static SoyExpression resolveSoyValueProvider(SoyType type, Expression delegate) {
        Preconditions.checkArgument((boolean)BytecodeUtils.isPossiblyAssignableFrom(BytecodeUtils.SOY_VALUE_PROVIDER_TYPE, delegate.resultType()));
        if (delegate.isNonJavaNullable() || !BytecodeUtils.isDefinitelyAssignableFrom(BytecodeUtils.SOY_VALUE_TYPE, delegate.resultType())) {
            delegate = delegate.invoke(MethodRefs.SOY_VALUE_PROVIDER_RESOLVE, new Expression[0]).checkedSoyCast(type);
        }
        return SoyExpression.forSoyValue(type, delegate);
    }

    public static Expression boxListWithSoyNullishAsJavaNull(List<SoyExpression> items) {
        return BytecodeUtils.asList((Iterable)items.stream().map(SoyExpression::boxWithSoyNullishAsJavaNull).collect(ImmutableList.toImmutableList()));
    }

    public static Expression boxListWithSoyNullAsJavaNull(List<SoyExpression> items) {
        return BytecodeUtils.asList((Iterable)items.stream().map(SoyExpression::boxWithSoyNullAsJavaNull).collect(ImmutableList.toImmutableList()));
    }

    public static Expression asBoxedValueProviderList(List<SoyExpression> items) {
        return BytecodeUtils.asImmutableList((Iterable)items.stream().map(SoyExpression::box).collect(ImmutableList.toImmutableList()));
    }

    private static SoyRuntimeType getUnboxedType(SoyType soyType) {
        return SoyRuntimeType.getUnboxedType(soyType).get();
    }

    private SoyExpression(SoyRuntimeType soyRuntimeType, Expression delegate) {
        super(delegate.resultType(), delegate.features());
        Preconditions.checkState((!(delegate instanceof SoyExpression) ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)BytecodeUtils.isPossiblyAssignableFrom(soyRuntimeType.runtimeType(), delegate.resultType()), (String)"Expecting SoyExpression type of %s for soy type %s, found delegate with type of %s", (Object)soyRuntimeType.runtimeType(), (Object)soyRuntimeType.soyType(), (Object)delegate.resultType());
        if (soyRuntimeType.isBoxed() != BytecodeUtils.isDefinitelyAssignableFrom(BytecodeUtils.SOY_VALUE_PROVIDER_TYPE, delegate.resultType())) {
            throw new IllegalArgumentException("boxed=" + soyRuntimeType.isBoxed() + " for type " + String.valueOf(delegate.resultType()));
        }
        this.soyRuntimeType = soyRuntimeType;
        this.delegate = delegate;
    }

    public SoyType soyType() {
        return this.soyRuntimeType.soyType();
    }

    public SoyRuntimeType soyRuntimeType() {
        return this.soyRuntimeType;
    }

    @Override
    protected void doGen(CodeBuilder adapter) {
        this.delegate.gen(adapter);
    }

    @Override
    public SoyExpression toConstantExpression() {
        return this.withSource(this.delegate.toConstantExpression());
    }

    @Override
    public SoyExpression withConstantValue(Expression.ConstantValue constantValue) {
        return this.withSource(this.delegate.withConstantValue(constantValue));
    }

    @Override
    public boolean isConstant() {
        return this.delegate.isConstant();
    }

    @Override
    public Expression.ConstantValue constantValue() {
        return this.delegate.constantValue();
    }

    @Override
    public Object constantBytecodeValue() {
        return this.delegate.constantBytecodeValue();
    }

    @Override
    public SoyExpression toMaybeConstant() {
        Expression newDelegate = this.delegate.toMaybeConstant();
        if (newDelegate != this.delegate) {
            return this.withSource(newDelegate);
        }
        return this;
    }

    @Override
    public SoyExpression withSourceLocation(SourceLocation location) {
        return this.withSource(this.delegate.withSourceLocation(location));
    }

    @Override
    public SourceLocation location() {
        return this.delegate.location();
    }

    public boolean assignableToNullableInt() {
        return this.soyRuntimeType.assignableToNullableInt();
    }

    public boolean assignableToNullableFloat() {
        return this.soyRuntimeType.assignableToNullableFloat();
    }

    public boolean assignableToNullableNumber() {
        return this.soyRuntimeType.assignableToNullableNumber();
    }

    public boolean assignableToNullableString() {
        return this.soyRuntimeType.assignableToNullableString();
    }

    public boolean isBoxed() {
        return this.soyRuntimeType.isBoxed();
    }

    public SoyExpression box() {
        if (this.isBoxed()) {
            return this;
        }
        if (this.soyRuntimeType.isKnownBool()) {
            if (this.delegate.isConstant() && this.delegate.constantValue().hasJavaValue()) {
                boolean value = this.delegate.constantValue().getJavaValueAsType(Boolean.class).get();
                if (value) {
                    return this.asBoxed(FieldRef.BOOLEAN_DATA_TRUE.accessor());
                }
                return this.asBoxed(FieldRef.BOOLEAN_DATA_FALSE.accessor());
            }
            return this.asBoxed(MethodRefs.BOOLEAN_DATA_FOR_VALUE.invoke(this.delegate).toMaybeConstant());
        }
        if (this.soyRuntimeType.isKnownInt()) {
            return this.asBoxed(MethodRefs.INTEGER_DATA_FOR_VALUE.invoke(this.delegate).toMaybeConstant());
        }
        if (this.soyRuntimeType.isKnownFloat()) {
            return this.asBoxed(MethodRefs.FLOAT_DATA_FOR_VALUE.invoke(this.delegate).toMaybeConstant());
        }
        boolean nonNullable = this.delegate.isNonJavaNullable();
        Expression.Features features = this.features().plus(Expression.Feature.NON_JAVA_NULLABLE);
        if (nonNullable) {
            features = features.plus(Expression.Feature.NON_SOY_NULLISH);
        }
        return this.asBoxed(nonNullable ? this.doBoxNonJavaNullable(this.soyRuntimeType) : new Expression(this.soyRuntimeType.box().runtimeType(), features){

            @Override
            protected void doGen(CodeBuilder adapter) {
                Label end = new Label();
                SoyExpression.this.delegate.gen(adapter);
                BytecodeUtils.coalesceSoyNullishToSoyNull(adapter, SoyExpression.this.delegate.resultType(), end);
                SoyExpression.doBox(adapter, SoyExpression.this.soyRuntimeType.asNonSoyNullish());
                adapter.mark(end);
            }
        });
    }

    public SoyExpression boxWithSoyNullishAsJavaNull() {
        if (this.isNonSoyNullish()) {
            return this.box();
        }
        if (this.isBoxed()) {
            return this.withSource(MethodRefs.SOY_NULLISH_TO_JAVA_NULL.invoke(this.delegate));
        }
        return this.asBoxed(new Expression(this.soyRuntimeType.box().runtimeType()){

            @Override
            protected void doGen(CodeBuilder adapter) {
                Label end = new Label();
                SoyExpression.this.delegate.gen(adapter);
                BytecodeUtils.coalesceSoyNullishToJavaNull(adapter, SoyExpression.this.delegate.resultType(), end);
                SoyExpression.doBox(adapter, SoyExpression.this.soyRuntimeType.asNonSoyNullish());
                adapter.mark(end);
            }
        });
    }

    public SoyExpression boxWithSoyNullAsJavaNull() {
        if (this.isNonSoyNullish()) {
            return this.box();
        }
        if (this.isBoxed()) {
            return this.withSource(MethodRefs.SOY_NULL_TO_JAVA_NULL.invoke(this.delegate));
        }
        return this.asBoxed(new Expression(this.soyRuntimeType.box().runtimeType()){

            @Override
            protected void doGen(CodeBuilder adapter) {
                Label end = new Label();
                SoyExpression.this.delegate.gen(adapter);
                BytecodeUtils.coalesceSoyNullToJavaNull(adapter, SoyExpression.this.delegate.resultType(), end);
                SoyExpression.doBox(adapter, SoyExpression.this.soyRuntimeType.asNonSoyNullish());
                adapter.mark(end);
            }
        });
    }

    public static void doBox(CodeBuilder adapter, SoyRuntimeType type) {
        if (type.isKnownSanitizedContent()) {
            SanitizedContent.ContentKind kind = Converters.toContentKind(((SanitizedType)type.soyType()).getContentKind());
            Preconditions.checkState((kind != SanitizedContent.ContentKind.TEXT ? 1 : 0) != 0);
            FieldRef.enumReference(kind).accessStaticUnchecked(adapter);
            MethodRefs.ORDAIN_AS_SAFE.invokeUnchecked(adapter);
        } else if (type.isKnownString()) {
            MethodRefs.STRING_DATA_FOR_VALUE.invokeUnchecked(adapter);
        } else if (type.isKnownListOrUnionOfLists()) {
            MethodRefs.LIST_IMPL_FOR_PROVIDER_LIST.invokeUnchecked(adapter);
        } else if (type.isKnownLegacyObjectMapOrUnionOfMaps()) {
            FieldRef.enumReference(RuntimeMapTypeTracker.Type.LEGACY_OBJECT_MAP_OR_RECORD).putUnchecked(adapter);
            MethodRefs.DICT_IMPL_FOR_PROVIDER_MAP.invokeUnchecked(adapter);
        } else if (type.isKnownMapOrUnionOfMaps()) {
            MethodRefs.MAP_IMPL_FOR_PROVIDER_MAP.invokeUnchecked(adapter);
        } else if (type.isKnownProtoOrUnionOfProtos()) {
            MethodRefs.SOY_PROTO_VALUE_CREATE.invokeUnchecked(adapter);
        } else {
            throw new IllegalStateException("Can't box soy expression of type " + String.valueOf(type));
        }
    }

    private Expression doBoxNonJavaNullable(SoyRuntimeType type) {
        if (type.isKnownSanitizedContent()) {
            SanitizedContent.ContentKind kind = Converters.toContentKind(((SanitizedType)type.soyType()).getContentKind());
            Preconditions.checkState((kind != SanitizedContent.ContentKind.TEXT ? 1 : 0) != 0);
            return MethodRefs.ORDAIN_AS_SAFE.invoke(this.delegate, FieldRef.enumReference(kind).accessor()).toMaybeConstant();
        }
        if (type.isKnownString()) {
            String constantValue;
            if (this.delegate.isConstant() && (constantValue = (String)this.delegate.constantValue().getJavaValueAsType(String.class).orElse(null)) != null && constantValue.isEmpty()) {
                return FieldRef.EMPTY_STRING_DATA.accessor().withSourceLocation(this.delegate.location);
            }
            return MethodRefs.STRING_DATA_FOR_VALUE.invoke(this.delegate).toMaybeConstant();
        }
        if (type.isKnownListOrUnionOfLists()) {
            return MethodRefs.LIST_IMPL_FOR_PROVIDER_LIST.invoke(this.delegate);
        }
        if (type.isKnownLegacyObjectMapOrUnionOfMaps()) {
            return MethodRefs.DICT_IMPL_FOR_PROVIDER_MAP.invoke(this.delegate, FieldRef.enumReference(RuntimeMapTypeTracker.Type.LEGACY_OBJECT_MAP_OR_RECORD).accessor());
        }
        if (type.isKnownMapOrUnionOfMaps()) {
            return MethodRefs.MAP_IMPL_FOR_PROVIDER_MAP.invoke(this.delegate);
        }
        if (type.isKnownProtoOrUnionOfProtos()) {
            return MethodRefs.SOY_PROTO_VALUE_CREATE.invoke(this.delegate).toMaybeConstant();
        }
        throw new IllegalStateException("Can't box soy expression of type " + String.valueOf(type));
    }

    private SoyExpression asBoxed(Expression expr) {
        return new SoyExpression(this.soyRuntimeType.box(), expr);
    }

    public Branch compileToBranch() {
        if (BytecodeUtils.isPrimitive(this.resultType())) {
            if (this.resultType().equals((Object)Type.BOOLEAN_TYPE)) {
                return Branch.ifTrue(this);
            }
            if (this.resultType().equals((Object)Type.DOUBLE_TYPE)) {
                return Branch.ifTrue(MethodRefs.RUNTIME_COERCE_DOUBLE_TO_BOOLEAN.invoke(this.delegate).toMaybeConstant());
            }
            if (this.resultType().equals((Object)Type.LONG_TYPE)) {
                Long maybeLong;
                if (this.delegate.isConstant() && (maybeLong = (Long)this.delegate.constantValue().getJavaValueAsType(Long.class).orElse(null)) == null) {
                    return maybeLong == 0L ? Branch.never() : Branch.never().negate();
                }
                return Branch.ifNotZero(this.delegate);
            }
            throw new AssertionError((Object)("resultType(): " + String.valueOf(this.resultType()) + " is not a valid type for a SoyExpression"));
        }
        if (SoyTypes.isNullOrUndefined(this.soyType())) {
            return Branch.never();
        }
        if (this.isBoxed()) {
            return Branch.ifTrue(this.delegate.invoke(MethodRefs.SOY_VALUE_COERCE_TO_BOOLEAN, new Expression[0]).toMaybeConstant());
        }
        if (this.resultType().equals((Object)BytecodeUtils.STRING_TYPE)) {
            return this.isNonJavaNullable() ? Branch.ifTrue(this.delegate.invoke(MethodRefs.STRING_IS_EMPTY, new Expression[0]).toMaybeConstant()).negate() : Branch.ifTrue(MethodRefs.RUNTIME_COERCE_STRING_TO_BOOLEAN.invoke(this.delegate).toMaybeConstant());
        }
        return Branch.ifNonSoyNullish(this.delegate);
    }

    public SoyExpression coerceToBoolean() {
        return SoyExpression.forBool(this.compileToBranch().asBoolean());
    }

    public SoyExpression coerceToString() {
        if (this.soyRuntimeType.isKnownString() && !this.isBoxed()) {
            if (this.isNonJavaNullable()) {
                return this;
            }
            return SoyExpression.forString(MethodRefs.STRING_VALUE_OF.invoke(this.delegate));
        }
        if (BytecodeUtils.isPrimitive(this.resultType())) {
            if (this.resultType().equals((Object)Type.BOOLEAN_TYPE)) {
                return SoyExpression.forString(MethodRefs.BOOLEAN_TO_STRING.invoke(this.delegate).toMaybeConstant());
            }
            if (this.resultType().equals((Object)Type.DOUBLE_TYPE)) {
                return SoyExpression.forString(MethodRefs.DOUBLE_TO_STRING.invoke(this.delegate).toMaybeConstant());
            }
            if (this.resultType().equals((Object)Type.LONG_TYPE)) {
                return SoyExpression.forString(MethodRefs.LONG_TO_STRING.invoke(this.delegate).toMaybeConstant());
            }
            throw new AssertionError((Object)("resultType(): " + String.valueOf(this.resultType()) + " is not a valid type for a SoyExpression"));
        }
        if (!this.isBoxed()) {
            return SoyExpression.forString(MethodRefs.STRING_VALUE_OF.invoke(this.delegate).toMaybeConstant());
        }
        return SoyExpression.forString(MethodRefs.SOY_VALUE_COERCE_TO_STRING.invoke(this.delegate).toMaybeConstant());
    }

    public SoyExpression coerceToDouble() {
        if (!this.isBoxed()) {
            if (this.soyRuntimeType.isKnownFloat()) {
                return this;
            }
            if (this.soyRuntimeType.isKnownInt()) {
                return SoyExpression.forFloat(BytecodeUtils.numericConversion(this.delegate, Type.DOUBLE_TYPE).toMaybeConstant());
            }
            throw new UnsupportedOperationException("Can't convert " + String.valueOf(this.resultType()) + " to a double");
        }
        if (this.soyRuntimeType.isKnownFloat()) {
            return SoyExpression.forFloat(this.delegate.invoke(MethodRefs.SOY_VALUE_FLOAT_VALUE, new Expression[0]).toMaybeConstant());
        }
        return SoyExpression.forFloat(this.delegate.invoke(MethodRefs.SOY_VALUE_NUMBER_VALUE, new Expression[0]).toMaybeConstant());
    }

    public Expression unboxAsNumberOrJavaNull() {
        if (!this.isBoxed()) {
            if (this.soyRuntimeType.isKnownFloat()) {
                return MethodRefs.BOX_DOUBLE.invoke(this).toMaybeConstant();
            }
            if (this.soyRuntimeType.isKnownInt()) {
                return MethodRefs.BOX_LONG.invoke(this).toMaybeConstant();
            }
            throw new UnsupportedOperationException("Can't convert " + String.valueOf(this.resultType()) + " to a Number");
        }
        if (this.isNonSoyNullish()) {
            return MethodRefs.SOY_VALUE_JAVA_NUMBER_VALUE.invoke(this.checkedCast(BytecodeUtils.NUMBER_DATA_TYPE));
        }
        return new Expression(BytecodeUtils.NUMBER_TYPE, this.featuresAfterUnboxing()){

            @Override
            protected void doGen(CodeBuilder adapter) {
                Label end = new Label();
                SoyExpression.this.delegate.gen(adapter);
                BytecodeUtils.coalesceSoyNullishToJavaNull(adapter, SoyExpression.this.delegate.resultType(), end);
                adapter.checkCast(BytecodeUtils.NUMBER_DATA_TYPE);
                MethodRefs.SOY_VALUE_JAVA_NUMBER_VALUE.invokeUnchecked(adapter);
                adapter.mark(end);
            }
        };
    }

    public SoyExpression unboxAsBoolean() {
        if (this.alreadyUnboxed(Boolean.TYPE)) {
            return this;
        }
        this.assertBoxed(Boolean.TYPE);
        return SoyExpression.forBool(this.delegate.invoke(MethodRefs.SOY_VALUE_BOOLEAN_VALUE, new Expression[0]).toMaybeConstant());
    }

    public SoyExpression unboxAsLong() {
        if (this.alreadyUnboxed(Long.TYPE)) {
            return this;
        }
        this.assertBoxed(Long.TYPE);
        return SoyExpression.forInt(this.delegate.invoke(MethodRefs.SOY_VALUE_LONG_VALUE, new Expression[0]));
    }

    public Expression unboxAsInt() {
        if (this.alreadyUnboxed(Long.TYPE)) {
            return SoyExpression.checkedCastLongToInt(this);
        }
        return this.box().invoke(MethodRefs.SOY_VALUE_INTEGER_VALUE, new Expression[0]);
    }

    public Expression coerceToInt() {
        if (this.soyRuntimeType.isKnownInt()) {
            return this.unboxAsInt();
        }
        return SoyExpression.checkedCastLongToInt(BytecodeUtils.numericConversion(this.soyRuntimeType.isKnownFloat() ? this.unboxAsDouble() : this.coerceToDouble(), Type.LONG_TYPE));
    }

    private static Expression checkedCastLongToInt(Expression delegate) {
        long longValue;
        Long javaValue;
        if (delegate.isConstant() && (javaValue = (Long)delegate.constantValue().getJavaValueAsType(Long.class).orElse(null)) != null && (longValue = javaValue.longValue()) == (long)((int)longValue)) {
            return BytecodeUtils.constant((int)longValue);
        }
        return MethodRefs.INTS_CHECKED_CAST.invoke(delegate);
    }

    public SoyExpression unboxAsDouble() {
        if (this.alreadyUnboxed(Double.TYPE)) {
            return this;
        }
        this.assertBoxed(Double.TYPE);
        return SoyExpression.forFloat(this.delegate.invoke(MethodRefs.SOY_VALUE_FLOAT_VALUE, new Expression[0]));
    }

    private Expression.Features featuresAfterUnboxing() {
        Expression.Features features = this.features();
        if (!features.has(Expression.Feature.NON_SOY_NULLISH)) {
            features = features.minus(Expression.Feature.NON_JAVA_NULLABLE);
        }
        return features;
    }

    public SoyExpression unboxAsStringUnchecked() {
        return this.asNonSoyNullish().unboxAsStringOrJavaNull();
    }

    public SoyExpression unboxAsStringOrJavaNull() {
        if (this.alreadyUnboxed(String.class)) {
            return this;
        }
        this.assertBoxed(String.class);
        return SoyExpression.forString(this.delegate.invoke(this.delegate.isNonSoyNullish() ? MethodRefs.SOY_VALUE_STRING_VALUE : MethodRefs.SOY_VALUE_STRING_VALUE_OR_NULL, new Expression[0]));
    }

    public SoyExpression unboxAsListUnchecked() {
        return this.asNonSoyNullish().unboxAsListOrJavaNull();
    }

    public SoyExpression unboxAsListOrJavaNull() {
        ListType asListType;
        if (this.alreadyUnboxed(List.class)) {
            return this;
        }
        this.assertBoxed(List.class);
        Expression unboxedList = this.delegate.invoke(this.delegate.isNonSoyNullish() ? MethodRefs.SOY_VALUE_AS_JAVA_LIST : MethodRefs.SOY_VALUE_AS_JAVA_LIST_OR_NULL, new Expression[0]);
        SoyRuntimeType nonNullRuntimeType = SoyRuntimeType.getBoxedType(SoyTypes.tryRemoveNullish(this.soyType()));
        if (!SoyTypes.isNullOrUndefined(this.soyType()) && nonNullRuntimeType.isKnownListOrUnionOfLists()) {
            asListType = nonNullRuntimeType.asListType();
        } else if (this.soyType().getKind() == SoyType.Kind.UNKNOWN || this.soyType().isNullOrUndefined()) {
            asListType = ListType.of(UnknownType.getInstance());
        } else {
            throw new UnsupportedOperationException("Can't convert " + String.valueOf(this.soyRuntimeType) + " to List");
        }
        return SoyExpression.forList(asListType, unboxedList);
    }

    public Expression unboxAsMessageUnchecked(Type runtimeType) {
        return this.asNonSoyNullish().unboxAsMessageOrJavaNull(runtimeType);
    }

    public Expression unboxAsMessageOrJavaNull(Type runtimeType) {
        if (this.soyType().isNullOrUndefined()) {
            return BytecodeUtils.constantNull(runtimeType);
        }
        if (this.soyRuntimeType.asNonSoyNullish().isKnownProtoOrUnionOfProtos() && !this.isBoxed()) {
            if (this.delegate.resultType().equals((Object)runtimeType) || runtimeType.equals((Object)BytecodeUtils.MESSAGE_TYPE)) {
                return this;
            }
            return this.delegate.checkedCast(runtimeType);
        }
        return this.delegate.invoke(this.delegate.isNonSoyNullish() ? MethodRefs.SOY_VALUE_GET_PROTO : MethodRefs.SOY_VALUE_GET_PROTO_OR_NULL, new Expression[0]).checkedCast(runtimeType);
    }

    private boolean alreadyUnboxed(Class<?> asType) {
        return BytecodeUtils.isDefinitelyAssignableFrom(Type.getType(asType), this.soyRuntimeType.runtimeType());
    }

    private void assertBoxed(Class<?> asType) {
        if (!this.isBoxed()) {
            throw new IllegalStateException("Trying to unbox an unboxed value (" + String.valueOf(this.soyRuntimeType) + ") into " + String.valueOf(asType) + " doesn't make sense. Should you be using a type coercion? e.g. coerceToBoolean()");
        }
    }

    public SoyExpression withSource(Expression expr) {
        if (expr == this.delegate) {
            return this;
        }
        return new SoyExpression(this.soyRuntimeType, expr);
    }

    @Override
    public SoyExpression asCheap() {
        return this.withSource(this.delegate.asCheap());
    }

    @Override
    public SoyExpression asNonJavaNullable() {
        return new SoyExpression(this.soyRuntimeType, this.delegate.asNonJavaNullable());
    }

    @Override
    public SoyExpression asJavaNullable() {
        return new SoyExpression(this.soyRuntimeType, this.delegate.asJavaNullable());
    }

    @Override
    public SoyExpression asNonSoyNullish() {
        return new SoyExpression(this.soyRuntimeType.asNonSoyNullish(), this.delegate.asNonSoyNullish());
    }

    public SoyExpression asSoyUndefinable() {
        return new SoyExpression(this.soyRuntimeType.asSoyUndefinable(), this.delegate.asSoyNullish());
    }

    @Override
    public SoyExpression labelStart(Label label) {
        return this.withSource(this.delegate.labelStart(label));
    }

    @Override
    public SoyExpression labelEnd(Label label) {
        return this.withSource(this.delegate.labelEnd(label));
    }

    @Override
    protected void extraToStringProperties(MoreObjects.ToStringHelper helper) {
        helper.add("soyType", (Object)this.soyType());
    }
}

