/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc.runtime;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Streams;
import com.google.common.html.types.SafeHtml;
import com.google.common.html.types.SafeHtmlProto;
import com.google.common.html.types.SafeHtmls;
import com.google.common.html.types.SafeUrl;
import com.google.common.html.types.SafeUrlProto;
import com.google.common.html.types.SafeUrls;
import com.google.common.html.types.TrustedResourceUrl;
import com.google.common.html.types.TrustedResourceUrlProto;
import com.google.common.html.types.TrustedResourceUrls;
import com.google.errorprone.annotations.Keep;
import com.google.protobuf.Message;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SanitizedContents;
import com.google.template.soy.data.SoyMap;
import com.google.template.soy.data.SoyRecord;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.SoyValueConverter;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.data.SoyValueUnconverter;
import com.google.template.soy.data.restricted.NumberData;
import com.google.template.soy.jbcsrc.restricted.MethodRef;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class JbcSrcExternRuntime {
    public static final MethodRef CONVERT_OBJECT_TO_SOY_VALUE_PROVIDER = JbcSrcExternRuntime.create("convertObjectToSoyValueProvider", Object.class);
    public static final MethodRef CONVERT_SAFE_HTML_PROTO_TO_SOY_VALUE_PROVIDER = MethodRef.createPure(SanitizedContents.class, "fromSafeHtmlProto", SafeHtmlProto.class);
    public static final MethodRef CONVERT_SAFE_HTML_TO_SOY_VALUE_PROVIDER = MethodRef.createPure(SanitizedContents.class, "fromSafeHtml", SafeHtml.class);
    public static final MethodRef CONVERT_SAFE_URL_PROTO_TO_SOY_VALUE_PROVIDER = MethodRef.createPure(SanitizedContents.class, "fromSafeUrlProto", SafeUrlProto.class);
    public static final MethodRef CONVERT_SAFE_URL_TO_SOY_VALUE_PROVIDER = MethodRef.createPure(SanitizedContents.class, "fromSafeUrl", SafeUrl.class);
    public static final MethodRef CONVERT_TRUSTED_RESOURCE_URL_PROTO_TO_SOY_VALUE_PROVIDER = MethodRef.createPure(SanitizedContents.class, "fromTrustedResourceUrlProto", TrustedResourceUrlProto.class);
    public static final MethodRef CONVERT_TRUSTED_RESOURCE_URL_TO_SOY_VALUE_PROVIDER = MethodRef.createPure(SanitizedContents.class, "fromTrustedResourceUrl", TrustedResourceUrl.class);
    public static final MethodRef LIST_BOX_VALUES = JbcSrcExternRuntime.create("listBoxValues", Iterable.class);
    public static final MethodRef LIST_UNBOX_BOOLS = JbcSrcExternRuntime.create("listUnboxBools", List.class);
    public static final MethodRef LIST_UNBOX_ENUMS = JbcSrcExternRuntime.create("listUnboxEnums", List.class, Class.class);
    public static final MethodRef LIST_UNBOX_FLOATS = JbcSrcExternRuntime.create("listUnboxFloats", List.class);
    public static final MethodRef LIST_UNBOX_INTS = JbcSrcExternRuntime.create("listUnboxInts", List.class);
    public static final MethodRef LIST_UNBOX_NUMBERS = JbcSrcExternRuntime.create("listUnboxNumbers", List.class);
    public static final MethodRef LIST_UNBOX_PROTOS = JbcSrcExternRuntime.create("listUnboxProtos", List.class);
    public static final MethodRef LIST_UNBOX_STRINGS = JbcSrcExternRuntime.create("listUnboxStrings", List.class);
    public static final MethodRef LONG_TO_INT = JbcSrcExternRuntime.create("longToInt", Long.TYPE);
    public static final MethodRef MARK_AS_SOY_MAP = MethodRef.createNonPure(SoyValueConverter.class, "markAsSoyMap", Map.class);
    public static final MethodRef NO_EXTERN_JAVA_IMPL = JbcSrcExternRuntime.create("noExternJavaImpl", new Class[0]);
    public static final MethodRef SOY_VALUE_TO_BOXED_BOOLEAN = JbcSrcExternRuntime.create("toBoxedBoolean", SoyValue.class);
    public static final MethodRef SOY_VALUE_TO_BOXED_DOUBLE = JbcSrcExternRuntime.create("toBoxedDouble", SoyValue.class);
    public static final MethodRef SOY_VALUE_TO_BOXED_FLOAT = JbcSrcExternRuntime.create("toBoxedFloat", SoyValue.class);
    public static final MethodRef SOY_VALUE_TO_BOXED_INTEGER = JbcSrcExternRuntime.create("toBoxedInteger", SoyValue.class);
    public static final MethodRef SOY_VALUE_TO_BOXED_LONG = JbcSrcExternRuntime.create("toBoxedLong", SoyValue.class);
    public static final MethodRef SOY_VALUE_TO_ENUM = JbcSrcExternRuntime.create("toEnum", SoyValue.class, Class.class);
    public static final MethodRef UNBOX_BOOLEAN = MethodRef.createPure(Boolean.class, "booleanValue", new Class[0]);
    public static final MethodRef UNBOX_DOUBLE = MethodRef.createPure(Double.class, "doubleValue", new Class[0]);
    public static final MethodRef UNBOX_FLOAT = MethodRef.createPure(Float.class, "doubleValue", new Class[0]);
    public static final MethodRef UNBOX_INTEGER = MethodRef.createPure(Integer.class, "longValue", new Class[0]);
    public static final MethodRef UNBOX_LONG = MethodRef.createPure(Long.class, "longValue", new Class[0]);
    public static final MethodRef UNBOX_MAP = JbcSrcExternRuntime.create("unboxMap", SoyValue.class, Class.class, Class.class);
    public static final MethodRef UNBOX_OBJECT = MethodRef.createPure(SoyValueUnconverter.class, "unconvert", SoyValueProvider.class);
    public static final MethodRef UNBOX_RECORD = JbcSrcExternRuntime.create("unboxRecord", SoyValue.class);
    public static final MethodRef UNBOX_SAFE_HTML = JbcSrcExternRuntime.create("unboxSafeHtml", SoyValue.class);
    public static final MethodRef UNBOX_SAFE_HTML_PROTO = JbcSrcExternRuntime.create("unboxSafeHtmlProto", SoyValue.class);
    public static final MethodRef UNBOX_SAFE_URL = JbcSrcExternRuntime.create("unboxSafeUrl", SoyValue.class);
    public static final MethodRef UNBOX_SAFE_URL_PROTO = JbcSrcExternRuntime.create("unboxSafeUrlProto", SoyValue.class);
    public static final MethodRef UNBOX_TRUSTED_RESOURCE_URL = JbcSrcExternRuntime.create("unboxTrustedResourceUrl", SoyValue.class);
    public static final MethodRef UNBOX_TRUSTED_RESOURCE_URL_PROTO = JbcSrcExternRuntime.create("unboxTrustedResourceUrlProto", SoyValue.class);

    private JbcSrcExternRuntime() {
    }

    private static MethodRef create(String methodName, Class<?> ... params) {
        return MethodRef.createPure(JbcSrcExternRuntime.class, methodName, params);
    }

    @Keep
    @Nonnull
    public static SoyValueProvider convertObjectToSoyValueProvider(Object o) {
        return SoyValueConverter.INSTANCE.convert(o);
    }

    @Keep
    @Nullable
    public static List<SoyValueProvider> listBoxValues(Iterable<?> javaValues) {
        if (javaValues == null) {
            return null;
        }
        return Streams.stream(javaValues).map(SoyValueConverter.INSTANCE::convert).collect(Collectors.toList());
    }

    @Keep
    @Nullable
    public static ImmutableList<Boolean> listUnboxBools(List<SoyValue> values) {
        if (values == null) {
            return null;
        }
        return (ImmutableList)values.stream().map(SoyValue::coerceToBoolean).collect(ImmutableList.toImmutableList());
    }

    @Keep
    @Nullable
    public static <T extends ProtocolMessageEnum> ImmutableList<T> listUnboxEnums(List<SoyValue> values, Class<T> type) {
        if (values == null) {
            return null;
        }
        return (ImmutableList)values.stream().map(v -> (ProtocolMessageEnum)JbcSrcExternRuntime.getEnumValue(type, (int)v.longValue())).collect(ImmutableList.toImmutableList());
    }

    @Keep
    @Nullable
    public static ImmutableList<Double> listUnboxFloats(List<SoyValue> values) {
        if (values == null) {
            return null;
        }
        return (ImmutableList)values.stream().map(SoyValue::floatValue).collect(ImmutableList.toImmutableList());
    }

    @Keep
    @Nullable
    public static ImmutableList<Long> listUnboxInts(List<SoyValue> values) {
        if (values == null) {
            return null;
        }
        return (ImmutableList)values.stream().map(SoyValue::longValue).collect(ImmutableList.toImmutableList());
    }

    @Keep
    @Nullable
    public static ImmutableList<Double> listUnboxNumbers(List<SoyValue> values) {
        if (values == null) {
            return null;
        }
        return (ImmutableList)values.stream().map(SoyValue::numberValue).collect(ImmutableList.toImmutableList());
    }

    @Keep
    @Nullable
    public static ImmutableList<Message> listUnboxProtos(List<SoyValue> values) {
        if (values == null) {
            return null;
        }
        return (ImmutableList)values.stream().map(SoyValue::getProto).collect(ImmutableList.toImmutableList());
    }

    @Keep
    @Nullable
    public static ImmutableList<String> listUnboxStrings(List<SoyValue> values) {
        if (values == null) {
            return null;
        }
        return (ImmutableList)values.stream().map(SoyValue::coerceToString).collect(ImmutableList.toImmutableList());
    }

    @Keep
    public static int longToInt(long value) {
        Preconditions.checkState((value >= Integer.MIN_VALUE && value <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"Casting long to integer results in overflow: %s", (long)value);
        return (int)value;
    }

    @Nonnull
    public static NoSuchMethodException noExternJavaImpl() {
        return new NoSuchMethodException("No Java implementation for extern.");
    }

    @Keep
    @Nullable
    public static Boolean toBoxedBoolean(SoyValue value) {
        if (value.isNullish()) {
            return null;
        }
        return value.coerceToBoolean();
    }

    @Keep
    @Nullable
    public static Double toBoxedDouble(SoyValue value) {
        if (value.isNullish()) {
            return null;
        }
        if (value instanceof NumberData) {
            return value.numberValue();
        }
        return value.floatValue();
    }

    @Keep
    @Nullable
    public static Float toBoxedFloat(SoyValue value) {
        if (value.isNullish()) {
            return null;
        }
        if (value instanceof NumberData) {
            return Float.valueOf((float)value.numberValue());
        }
        return Float.valueOf((float)value.floatValue());
    }

    @Keep
    @Nullable
    public static Integer toBoxedInteger(SoyValue value) {
        if (value.isNullish()) {
            return null;
        }
        return value.integerValue();
    }

    @Keep
    @Nullable
    public static Long toBoxedLong(SoyValue value) {
        if (value.isNullish()) {
            return null;
        }
        return value.longValue();
    }

    @Keep
    @Nullable
    public static <T> T toEnum(SoyValue value, Class<T> clazz) {
        if (value.isNullish()) {
            return null;
        }
        return JbcSrcExternRuntime.getEnumValue(clazz, value.integerValue());
    }

    @Keep
    @Nullable
    public static ImmutableMap<?, ?> unboxMap(SoyValue value, Class<?> keyType, Class<?> valueType) {
        if (value.isNullish()) {
            return null;
        }
        SoyMap map = (SoyMap)value;
        return (ImmutableMap)map.entrySet().stream().collect(ImmutableMap.toImmutableMap(e -> JbcSrcExternRuntime.unboxMapItem((SoyValue)e.getKey(), keyType), e -> JbcSrcExternRuntime.unboxMapItem(((SoyValueProvider)e.getValue()).resolve(), valueType)));
    }

    @Keep
    @Nullable
    public static ImmutableMap<?, ?> unboxRecord(SoyValue value) {
        if (value.isNullish()) {
            return null;
        }
        SoyRecord map = (SoyRecord)value;
        return (ImmutableMap)map.recordAsMap().entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, e -> SoyValueUnconverter.unconvert((SoyValueProvider)e.getValue())));
    }

    @Keep
    @Nullable
    public static SafeHtml unboxSafeHtml(SoyValue value) {
        if (value.isNullish()) {
            return null;
        }
        return ((SanitizedContent)value).toSafeHtml();
    }

    @Keep
    @Nullable
    public static SafeHtmlProto unboxSafeHtmlProto(SoyValue value) {
        if (value.isNullish()) {
            return null;
        }
        return SafeHtmls.toProto((SafeHtml)((SanitizedContent)value).toSafeHtml());
    }

    @Keep
    @Nullable
    public static SafeUrl unboxSafeUrl(SoyValue value) {
        if (value.isNullish()) {
            return null;
        }
        return ((SanitizedContent)value).toSafeUrl();
    }

    @Keep
    @Nullable
    public static SafeUrlProto unboxSafeUrlProto(SoyValue value) {
        if (value.isNullish()) {
            return null;
        }
        return SafeUrls.toProto((SafeUrl)((SanitizedContent)value).toSafeUrl());
    }

    @Keep
    @Nullable
    public static TrustedResourceUrl unboxTrustedResourceUrl(SoyValue value) {
        if (value.isNullish()) {
            return null;
        }
        return ((SanitizedContent)value).toTrustedResourceUrl();
    }

    @Keep
    @Nullable
    public static TrustedResourceUrlProto unboxTrustedResourceUrlProto(SoyValue value) {
        if (value.isNullish()) {
            return null;
        }
        return TrustedResourceUrls.toProto((TrustedResourceUrl)((SanitizedContent)value).toTrustedResourceUrl());
    }

    private static Object unboxMapItem(SoyValue value, Class<?> type) {
        if (value == null || value.isNullish()) {
            return null;
        }
        if (type == Long.class) {
            return value.longValue();
        }
        if (type == String.class) {
            return value.coerceToString();
        }
        if (type == Boolean.class) {
            return value.coerceToBoolean();
        }
        if (type == Double.class) {
            return value.floatValue();
        }
        if (Message.class.isAssignableFrom(type)) {
            return value.getProto();
        }
        if (ProtocolMessageEnum.class.isAssignableFrom(type)) {
            return JbcSrcExternRuntime.getEnumValue(type, value.integerValue());
        }
        throw new IllegalArgumentException("unsupported type: " + String.valueOf(type));
    }

    private static <T> T getEnumValue(Class<T> clazz, int enumValue) {
        try {
            Method forNumber = clazz.getMethod("forNumber", Integer.TYPE);
            return clazz.cast(forNumber.invoke(null, enumValue));
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }
}

