/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc.runtime;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.errorprone.annotations.Keep;
import com.google.template.soy.data.RecordProperty;
import com.google.template.soy.data.SoyLegacyObjectMap;
import com.google.template.soy.data.SoyMap;
import com.google.template.soy.data.SoyRecord;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.SoyValueConverter;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.data.internal.ParamStore;
import com.google.template.soy.data.internal.SoyLegacyObjectMapImpl;
import com.google.template.soy.data.internal.SoyMapImpl;
import com.google.template.soy.data.internal.SoyRecordImpl;
import com.google.template.soy.data.restricted.NullData;
import com.google.template.soy.jbcsrc.restricted.MethodRef;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class JbcSrcPluginRuntime {
    public static final MethodRef CONVERT_FUTURE_TO_SOY_VALUE_PROVIDER = JbcSrcPluginRuntime.create("convertFutureToSoyValueProvider", Future.class);
    public static final MethodRef NULLISH_TO_JAVA_NULL = JbcSrcPluginRuntime.create("nullishToJavaNull", SoyValue.class);
    public static final MethodRef NULL_TO_JAVA_NULL = JbcSrcPluginRuntime.create("soyNullToJavaNull", SoyValue.class);
    public static final MethodRef JAVA_NULL_TO_SOY_NULL = JbcSrcPluginRuntime.create("javaNullToSoyNull", SoyValue.class).asNonJavaNullable();
    public static final MethodRef BOX_JAVA_MAP_AS_SOY_MAP = JbcSrcPluginRuntime.create("boxJavaMapAsSoyMap", Map.class);
    public static final MethodRef BOX_JAVA_MAP_AS_SOY_RECORD = JbcSrcPluginRuntime.create("boxJavaMapAsSoyRecord", Map.class);
    public static final MethodRef BOX_JAVA_MAP_AS_SOY_LEGACY_OBJECT_MAP = JbcSrcPluginRuntime.create("boxJavaMapAsSoyLegacyObjectMap", Map.class);

    private JbcSrcPluginRuntime() {
    }

    private static MethodRef create(String methodName, Class<?> ... params) {
        return MethodRef.createPure(JbcSrcPluginRuntime.class, methodName, params);
    }

    @Keep
    @Nonnull
    public static SoyValueProvider convertFutureToSoyValueProvider(Future<?> future) {
        return SoyValueConverter.INSTANCE.convert(future);
    }

    @Keep
    @Nullable
    public static SoyValue nullishToJavaNull(@Nonnull SoyValue value) {
        return value.isNullish() ? null : value;
    }

    @Keep
    @Nullable
    public static SoyValue soyNullToJavaNull(@Nonnull SoyValue value) {
        return value.isNull() ? null : value;
    }

    @Keep
    public static SoyValue javaNullToSoyNull(@Nullable SoyValue value) {
        return value == null ? NullData.INSTANCE : value;
    }

    @Keep
    @Nonnull
    public static SoyMap boxJavaMapAsSoyMap(Map<?, ?> javaMap) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)javaMap.size());
        for (Map.Entry<?, ?> entry : javaMap.entrySet()) {
            map.put(SoyValueConverter.INSTANCE.convert(entry.getKey()).resolve(), SoyValueConverter.INSTANCE.convert(entry.getValue()));
        }
        return SoyMapImpl.forProviderMap(map);
    }

    @Keep
    @Nonnull
    public static SoyRecord boxJavaMapAsSoyRecord(Map<String, ?> javaMap) {
        ParamStore map = new ParamStore(javaMap.size());
        for (Map.Entry<String, ?> entry : javaMap.entrySet()) {
            map.setField(RecordProperty.get(entry.getKey()), SoyValueConverter.INSTANCE.convert(entry.getValue()));
        }
        return new SoyRecordImpl(map);
    }

    @Keep
    @Nonnull
    public static SoyLegacyObjectMap boxJavaMapAsSoyLegacyObjectMap(Map<String, ?> javaMap) {
        return new SoyLegacyObjectMapImpl((ImmutableMap<String, SoyValueProvider>)((ImmutableMap)javaMap.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, e -> SoyValueConverter.INSTANCE.convert(e.getValue())))));
    }
}

