/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc.shared;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Sets;
import com.google.errorprone.annotations.concurrent.LazyInit;
import com.google.template.soy.data.LoggingAdvisingAppendable;
import com.google.template.soy.data.RecordProperty;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.data.TemplateValue;
import com.google.template.soy.data.internal.ParamStore;
import com.google.template.soy.data.restricted.UndefinedData;
import com.google.template.soy.jbcsrc.api.RenderResult;
import com.google.template.soy.jbcsrc.shared.CompiledTemplate;
import com.google.template.soy.jbcsrc.shared.Names;
import com.google.template.soy.jbcsrc.shared.RenderContext;
import com.google.template.soy.jbcsrc.shared.TemplateMetadata;
import com.google.template.soy.shared.internal.DelTemplateSelector;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

public class CompiledTemplates {
    private static final AtomicInteger idGenerator = new AtomicInteger(0);
    private static final MethodType RENDER_TYPE = MethodType.methodType(RenderResult.class, ParamStore.class, LoggingAdvisingAppendable.class, RenderContext.class);
    private final ClassLoader loader;
    private final ConcurrentHashMap<String, TemplateData> templateNameToFactory = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, MethodHandle> constOrExternNameToMethod = new ConcurrentHashMap();
    final DelTemplateSelector<TemplateData> selector;
    private final int id = idGenerator.incrementAndGet();
    private static final Splitter HASH_SPLITTER = Splitter.on((char)'#');

    public CompiledTemplates(ImmutableSet<String> delTemplateNames, ClassLoader loader) {
        this.loader = (ClassLoader)Preconditions.checkNotNull((Object)loader);
        DelTemplateSelector.Builder<TemplateData> builder = new DelTemplateSelector.Builder<TemplateData>();
        for (String delTemplateImplName : delTemplateNames) {
            TemplateData data = this.getTemplateData(delTemplateImplName);
            if (!data.delTemplateName.isPresent()) {
                throw new IllegalArgumentException("Expected " + delTemplateImplName + " to be a deltemplate");
            }
            String delTemplateName = data.delTemplateName.get();
            if (data.modName.isPresent()) {
                String modName = data.modName.get();
                TemplateData prev = builder.add(delTemplateName, modName, data.variant, data);
                if (prev == null) continue;
                throw new IllegalArgumentException(String.format("Found multiple deltemplates with the same name (%s) and package (%s). %s and %s", delTemplateName, modName, delTemplateImplName, prev.soyTemplateName()));
            }
            TemplateData prev = builder.addDefault(delTemplateName, data.variant, data);
            if (prev == null) continue;
            throw new IllegalArgumentException(String.format("Found multiple default deltemplates with the same name (%s). %s and %s", delTemplateName, delTemplateImplName, prev.soyTemplateName()));
        }
        this.selector = builder.build();
    }

    ClassLoader getClassLoader() {
        return this.loader;
    }

    int getId() {
        return this.id;
    }

    public CompiledTemplate getTemplate(String name) {
        return this.getTemplateData(name).template();
    }

    TemplateValue getTemplateValue(String name) {
        return this.getTemplateData(name).templateValue();
    }

    MethodHandle getRenderMethod(String name) {
        return this.getTemplateData(name).renderMethod();
    }

    MethodHandle getPositionalRenderMethod(String name, int arity) {
        return this.getTemplateData(name).positionalRenderMethod(arity);
    }

    public ImmutableSortedSet<String> getTransitiveIjParamsForTemplate(String templateName) {
        TemplateData templateData = this.getTemplateData(templateName);
        ImmutableSortedSet transitiveIjParams = templateData.transitiveIjParams;
        if (transitiveIjParams != null) {
            return transitiveIjParams;
        }
        HashSet<TemplateData> all = new HashSet<TemplateData>();
        this.collectTransitiveCallees(templateData, all);
        ImmutableSortedSet.Builder ijs = ImmutableSortedSet.naturalOrder();
        for (TemplateData callee : all) {
            ijs.addAll(callee.injectedParams);
        }
        templateData.transitiveIjParams = transitiveIjParams = ijs.build();
        return transitiveIjParams;
    }

    public ImmutableList<String> getRequiredCssNamespaces(String templateName) {
        return this.getTemplateData((String)templateName).requiredCssNamespaces.asList();
    }

    public ImmutableList<String> getRequiredCssPaths(String templateName) {
        return this.getTemplateData((String)templateName).requiredCssPaths.asList();
    }

    public ImmutableList<String> getAllRequiredCssNamespaces(String templateName, Predicate<String> enabledMods, boolean collectCssFromDelvariants) {
        TemplateData templateData = this.getTemplateData(templateName);
        LinkedHashSet orderedTemplateCalls = Sets.newLinkedHashSet();
        LinkedHashSet visited = Sets.newLinkedHashSet();
        this.collectTransitiveCallees(templateData, orderedTemplateCalls, visited, enabledMods, collectCssFromDelvariants);
        LinkedHashSet requiredNamespaces = Sets.newLinkedHashSet();
        for (TemplateData callee : orderedTemplateCalls) {
            requiredNamespaces.addAll(callee.requiredCssNamespaces);
        }
        return ImmutableList.copyOf((Collection)requiredNamespaces);
    }

    public ImmutableList<String> getAllRequiredCssPaths(String templateName, Predicate<String> enabledMods, boolean collectCssFromDelvariants) {
        TemplateData templateData = this.getTemplateData(templateName);
        LinkedHashSet orderedTemplateCalls = Sets.newLinkedHashSet();
        LinkedHashSet visited = Sets.newLinkedHashSet();
        this.collectTransitiveCallees(templateData, orderedTemplateCalls, visited, enabledMods, collectCssFromDelvariants);
        LinkedHashSet requiredPaths = Sets.newLinkedHashSet();
        for (TemplateData callee : orderedTemplateCalls) {
            requiredPaths.addAll(callee.requiredCssPaths);
        }
        return ImmutableList.copyOf((Collection)requiredPaths);
    }

    @Nullable
    CompiledTemplate selectDelTemplate(String delTemplateName, String variant, Predicate<String> activeModSelector) {
        TemplateData selectedTemplate = this.selector.selectTemplate(delTemplateName, variant, activeModSelector);
        if (selectedTemplate == null) {
            return null;
        }
        return selectedTemplate.template();
    }

    MethodHandle getConstOrExternMethod(String fqn) {
        return this.constOrExternNameToMethod.computeIfAbsent(fqn, this::findConstOrExternMethod);
    }

    private MethodHandle findConstOrExternMethod(String fqn) {
        Iterator parts = HASH_SPLITTER.split((CharSequence)fqn).iterator();
        String className = (String)parts.next();
        String methodName = (String)parts.next();
        String descriptor = (String)parts.next();
        Preconditions.checkArgument((!parts.hasNext() ? 1 : 0) != 0, (String)"Expected FQN with exactly 2 hash characters: %s", (Object)fqn);
        try {
            Class<?> ownerClass = Class.forName(className, true, this.getClassLoader());
            return MethodHandles.publicLookup().in(ownerClass).findStatic(ownerClass, methodName, MethodType.fromMethodDescriptorString(descriptor, ownerClass.getClassLoader()));
        }
        catch (ReflectiveOperationException e) {
            throw new LinkageError("Could not invoke " + fqn, e);
        }
    }

    public TemplateData getTemplateData(String name) {
        TemplateData old;
        Preconditions.checkNotNull((Object)name);
        TemplateData template = this.templateNameToFactory.get(name);
        if (template == null && (old = this.templateNameToFactory.putIfAbsent(name, template = CompiledTemplates.loadTemplate(name, this.loader))) != null) {
            return old;
        }
        return template;
    }

    private static TemplateData loadTemplate(String name, ClassLoader loader) {
        Class<?> templateClass;
        String templateName = Names.javaClassNameFromSoyTemplateName(name);
        try {
            templateClass = Class.forName(templateName, true, loader);
        }
        catch (ClassNotFoundException e) {
            String format = "No class was compiled for template: %s.";
            throw new IllegalArgumentException(String.format(format, name), e);
        }
        catch (LinkageError e) {
            String debugInfo;
            if (loader instanceof DebuggingClassLoader && (debugInfo = ((DebuggingClassLoader)((Object)loader)).getDebugInfoForClass(templateName)) != null) {
                throw new LinkageError(debugInfo, e);
            }
            throw e;
        }
        return new TemplateData(templateClass, name);
    }

    private void collectTransitiveCallees(@Nullable TemplateData templateData, Set<TemplateData> visited) {
        if (templateData == null || visited.contains(templateData)) {
            return;
        }
        visited.add(templateData);
        for (String callee : templateData.callees) {
            this.collectTransitiveCallees(this.getTemplateData(callee), visited);
        }
        for (String delCallee : templateData.delCallees) {
            for (TemplateData potentialCallee : this.selector.delTemplateNameToValues().get((Object)delCallee)) {
                this.collectTransitiveCallees(potentialCallee, visited);
            }
        }
    }

    private void collectTransitiveCallees(@Nullable TemplateData templateData, Set<TemplateData> orderedTemplateCalls, Set<TemplateData> visited, Predicate<String> enabledMods, boolean collectCssFromDelvariants) {
        if (templateData == null || visited.contains(templateData)) {
            return;
        }
        visited.add(templateData);
        for (String callee : templateData.callees) {
            this.collectTransitiveCallees(this.getTemplateData(callee), orderedTemplateCalls, visited, enabledMods, collectCssFromDelvariants);
        }
        for (String delCallee : templateData.delCallees) {
            this.selector.delTemplateNameToValues().get((Object)delCallee).stream().map(tmpl -> tmpl.variant).filter(variant -> collectCssFromDelvariants || variant.isEmpty()).distinct().forEach(variant -> this.collectTransitiveCallees(this.selector.selectTemplate(delCallee, (String)variant, enabledMods), orderedTemplateCalls, visited, enabledMods, collectCssFromDelvariants));
        }
        orderedTemplateCalls.add(templateData);
    }

    private static final class HandlesForTesting {
        private static final MethodHandle COMPILED_TEMPLATE_RENDER;
        private static final MethodHandle POSITIONAL_TO_RECORD;

        private HandlesForTesting() {
        }

        private static ParamStore positionalToRecord(ImmutableList<RecordProperty> names, SoyValueProvider[] values) {
            ParamStore paramStore = new ParamStore(names.size());
            for (int i = 0; i < names.size(); ++i) {
                if (values[i] == UndefinedData.INSTANCE) continue;
                paramStore.setField((RecordProperty)names.get(i), values[i]);
            }
            return paramStore.freeze();
        }

        static {
            try {
                COMPILED_TEMPLATE_RENDER = MethodHandles.publicLookup().findVirtual(CompiledTemplate.class, "render", RENDER_TYPE);
                POSITIONAL_TO_RECORD = MethodHandles.lookup().findStatic(HandlesForTesting.class, "positionalToRecord", MethodType.methodType(ParamStore.class, ImmutableList.class, SoyValueProvider[].class));
            }
            catch (ReflectiveOperationException e) {
                throw new LinkageError(e.getMessage(), e);
            }
        }
    }

    public static final class TemplateData {
        final Method templateMethod;
        @GuardedBy(value="this")
        MethodHandle renderMethod;
        @GuardedBy(value="this")
        MethodHandle positionalRenderMethod;
        final String soyTemplateName;
        @LazyInit
        CompiledTemplate template;
        @GuardedBy(value="this")
        TemplateValue templateValue;
        final SanitizedContent.ContentKind kind;
        final Optional<ImmutableList<String>> positionalParameters;
        final ImmutableSet<String> callees;
        final ImmutableSet<String> delCallees;
        final ImmutableSet<String> injectedParams;
        final ImmutableSet<String> requiredCssNamespaces;
        final ImmutableSet<String> requiredCssPaths;
        final Optional<String> delTemplateName;
        final Optional<String> modName;
        final String variant;
        @LazyInit
        ImmutableSortedSet<String> transitiveIjParams;

        public TemplateData(Class<?> fileClass, String soyTemplateName) {
            this.templateMethod = TemplateData.getTemplateMethod(fileClass, soyTemplateName);
            this.soyTemplateName = soyTemplateName;
            TemplateMetadata annotation = this.templateMethod.getAnnotation(TemplateMetadata.class);
            this.kind = annotation.contentKind();
            this.positionalParameters = annotation.hasPositionalSignature() ? Optional.of(ImmutableList.copyOf((Object[])annotation.positionalParams())) : Optional.empty();
            this.callees = ImmutableSet.copyOf((Object[])annotation.callees());
            this.delCallees = ImmutableSet.copyOf((Object[])annotation.delCallees());
            this.injectedParams = ImmutableSet.copyOf((Object[])annotation.injectedParams());
            this.requiredCssNamespaces = ImmutableSet.copyOf((Object[])annotation.requiredCssNames());
            this.requiredCssPaths = ImmutableSet.copyOf((Object[])annotation.requiredCssPaths());
            TemplateMetadata.DelTemplateMetadata deltemplateMetadata = annotation.deltemplateMetadata();
            this.variant = deltemplateMetadata.variant();
            if (!deltemplateMetadata.name().isEmpty()) {
                this.delTemplateName = Optional.of(deltemplateMetadata.name());
                this.modName = deltemplateMetadata.modName().isEmpty() ? Optional.empty() : Optional.of(deltemplateMetadata.modName());
            } else {
                this.delTemplateName = Optional.empty();
                this.modName = Optional.empty();
            }
        }

        @VisibleForTesting
        public TemplateData(TemplateData copy, CompiledTemplate template) {
            this.template = template;
            this.templateMethod = copy.templateMethod;
            this.soyTemplateName = copy.soyTemplateName;
            this.kind = copy.kind;
            this.positionalParameters = copy.positionalParameters;
            this.callees = ImmutableSet.of();
            this.delCallees = ImmutableSet.of();
            this.requiredCssNamespaces = ImmutableSet.of();
            this.requiredCssPaths = ImmutableSet.of();
            this.injectedParams = ImmutableSet.of();
            this.delTemplateName = Optional.empty();
            this.modName = Optional.empty();
            this.variant = "";
            this.renderMethod = HandlesForTesting.COMPILED_TEMPLATE_RENDER.bindTo(template);
            if (this.positionalParameters.isPresent()) {
                ImmutableList<String> positionalParameters = this.positionalParameters.get();
                MethodHandle positionalRenderMethod = this.renderMethod;
                positionalRenderMethod = MethodHandles.filterArguments(positionalRenderMethod, 0, MethodHandles.insertArguments(HandlesForTesting.POSITIONAL_TO_RECORD, 0, positionalParameters.stream().map(RecordProperty::get).collect(ImmutableList.toImmutableList())));
                this.positionalRenderMethod = positionalRenderMethod.asCollector(0, SoyValueProvider[].class, positionalParameters.size());
            }
        }

        private static Method getTemplateMethod(Class<?> fileClass, String soyTemplateName) {
            String templateMethodName = Names.renderMethodNameFromSoyTemplateName(soyTemplateName);
            try {
                return fileClass.getDeclaredMethod(templateMethodName, new Class[0]);
            }
            catch (NoSuchMethodException nsme) {
                throw new IllegalArgumentException("cannot find the " + templateMethodName + "() method for " + soyTemplateName, nsme);
            }
        }

        synchronized MethodHandle renderMethod() {
            MethodHandle renderMethod = this.renderMethod;
            if (renderMethod == null) {
                String templateMethodName = Names.renderMethodNameFromSoyTemplateName(this.soyTemplateName);
                try {
                    renderMethod = MethodHandles.publicLookup().findStatic(this.templateMethod.getDeclaringClass(), templateMethodName, RENDER_TYPE);
                }
                catch (ReflectiveOperationException e) {
                    throw new IllegalArgumentException("cannot find the " + templateMethodName + "(SoyRecord,SoyRecord,LoggingAdvisingAppendable,RenderContext) method for " + this.soyTemplateName, e);
                }
                this.renderMethod = renderMethod;
            }
            return renderMethod;
        }

        synchronized MethodHandle positionalRenderMethod(int arity) {
            MethodHandle positionalRenderMethod = this.positionalRenderMethod;
            if (positionalRenderMethod == null) {
                String templateMethodName = Names.renderMethodNameFromSoyTemplateName(this.soyTemplateName);
                Object[] paramTypes = new Class[arity + 2];
                Arrays.fill(paramTypes, 0, arity, SoyValueProvider.class);
                paramTypes[paramTypes.length - 2] = LoggingAdvisingAppendable.class;
                paramTypes[paramTypes.length - 1] = RenderContext.class;
                try {
                    positionalRenderMethod = MethodHandles.publicLookup().findStatic(this.templateMethod.getDeclaringClass(), templateMethodName, MethodType.methodType(RenderResult.class, paramTypes));
                }
                catch (ReflectiveOperationException e) {
                    throw new IllegalArgumentException("cannot find the " + templateMethodName + "(" + Arrays.toString(paramTypes) + ") method for " + this.soyTemplateName, e);
                }
                this.positionalRenderMethod = positionalRenderMethod;
            }
            return positionalRenderMethod;
        }

        @VisibleForTesting
        public Class<?> templateClass() {
            return this.templateMethod.getDeclaringClass();
        }

        @VisibleForTesting
        public Method templateMethod() {
            return this.templateMethod;
        }

        public SanitizedContent.ContentKind kind() {
            return this.kind;
        }

        @VisibleForTesting
        public boolean isPublicTemplate() {
            try {
                this.template();
                return false;
            }
            catch (IllegalArgumentException expected) {
                return false;
            }
        }

        synchronized TemplateValue templateValue() {
            TemplateValue local = this.templateValue;
            if (local == null) {
                this.templateValue = local = TemplateValue.create(this.soyTemplateName, this.template());
            }
            return local;
        }

        public synchronized CompiledTemplate template() {
            CompiledTemplate local = this.template;
            if (local == null) {
                try {
                    local = (CompiledTemplate)this.templateMethod.invoke(null, new Object[0]);
                }
                catch (IllegalAccessException iae) {
                    throw new IllegalArgumentException("cannot get a factory for the private template: " + this.soyTemplateName(), iae);
                }
                catch (ReflectiveOperationException e) {
                    throw new AssertionError((Object)e);
                }
                this.template = local;
            }
            return local;
        }

        String soyTemplateName() {
            return this.soyTemplateName;
        }
    }

    public static interface Factory {
        public CompiledTemplates create(ImmutableSet<String> var1, ClassLoader var2);
    }

    public static interface DebuggingClassLoader {
        @Nullable
        public String getDebugInfoForClass(String var1);
    }
}

