/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc.shared;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.data.RecordProperty;
import com.google.template.soy.internal.exemptions.NamespaceExemptions;
import java.util.regex.Pattern;
import org.objectweb.asm.Type;

public final class Names {
    public static final String META_INF_DELTEMPLATE_PATH = "META-INF/services/com.google.template.soy.deltemplates";
    public static final String META_INF_PLUGIN_PATH = "META-INF/services/com.google.template.soy.plugins";
    static final String CLASS_PREFIX = "com.google.template.soy.jbcsrc.gen.";
    public static final String INTERNAL_CLASS_PREFIX = "com.google.template.soy.jbcsrc.gen.".replace('.', '/');
    public static final String VARIANT_VAR_NAME = "__modifiable_variant__";
    public static final RecordProperty VARIANT_VAR_PROPERTY = RecordProperty.get("__modifiable_variant__");
    public static final ImmutableSet<String> ALLOWED_SVP_PREFIXES = ImmutableSet.of((Object)"param", (Object)"let", (Object)"ph");
    private static final Pattern SVP_PATTERN = Pattern.compile("\\$(" + Joiner.on((char)'|').join(ALLOWED_SVP_PREFIXES) + ")_[_\\w]+(#\\d+)?$");

    private Names() {
    }

    public static boolean isGenerated(Type type) {
        return Names.isGenerated(type.getClassName());
    }

    public static boolean isGenerated(String javaFqn) {
        return javaFqn.startsWith(CLASS_PREFIX);
    }

    public static boolean isGeneratedSoyValueProvider(Type type) {
        return Names.isGenerated(type) && SVP_PATTERN.matcher(type.getClassName()).find();
    }

    public static String javaClassNameFromSoyTemplateName(String soyTemplate) {
        Preconditions.checkArgument((boolean)BaseUtils.isDottedIdentifier(soyTemplate), (String)"%s is not a valid template name.", (Object)soyTemplate);
        int lastDot = soyTemplate.lastIndexOf(46);
        Preconditions.checkArgument((lastDot != -1 ? 1 : 0) != 0, (String)"%s should contain a dot", (Object)soyTemplate);
        String soyNamespace = soyTemplate.substring(0, lastDot);
        return NamespaceExemptions.isKnownDuplicateNamespace(soyNamespace) ? CLASS_PREFIX + soyTemplate : CLASS_PREFIX + soyNamespace;
    }

    public static String javaClassNameFromSoyNamespace(String soyTemplateNamespace) {
        Preconditions.checkArgument((boolean)BaseUtils.isDottedIdentifier(soyTemplateNamespace), (String)"%s is not a valid template namespace.", (Object)soyTemplateNamespace);
        Preconditions.checkArgument((!NamespaceExemptions.isKnownDuplicateNamespace(soyTemplateNamespace) ? 1 : 0) != 0);
        return CLASS_PREFIX + soyTemplateNamespace;
    }

    public static String renderMethodNameFromSoyTemplateName(String soyTemplate) {
        Preconditions.checkArgument((boolean)BaseUtils.isDottedIdentifier(soyTemplate), (String)"%s is not a valid template name.", (Object)soyTemplate);
        int lastDot = soyTemplate.lastIndexOf(46);
        String soyNamespace = soyTemplate.substring(0, lastDot);
        if (NamespaceExemptions.isKnownDuplicateNamespace(soyNamespace)) {
            return "render";
        }
        return soyTemplate.substring(lastDot + 1);
    }

    public static String templateMethodNameFromSoyTemplateName(String soyTemplate) {
        Preconditions.checkArgument((boolean)BaseUtils.isDottedIdentifier(soyTemplate), (String)"%s is not a valid template name.", (Object)soyTemplate);
        int lastDot = soyTemplate.lastIndexOf(46);
        String soyNamespace = soyTemplate.substring(0, lastDot);
        if (NamespaceExemptions.isKnownDuplicateNamespace(soyNamespace)) {
            return "template";
        }
        return "template$" + soyTemplate.substring(lastDot + 1);
    }

    public static String javaFileName(String soyNamespace, String fileName) {
        Preconditions.checkArgument((boolean)BaseUtils.isDottedIdentifier(soyNamespace), (String)"%s is not a valid soy namspace name.", (Object)soyNamespace);
        String javaClassName = Names.javaClassNameFromSoyTemplateName(soyNamespace + ".foo");
        String javaPackageName = javaClassName.substring(0, javaClassName.lastIndexOf(46));
        return javaPackageName.replace('.', '/') + "/" + fileName;
    }

    public static void rewriteStackTrace(Throwable throwable) {
        StackTraceElement[] stack = throwable.getStackTrace();
        for (int i = 0; i < stack.length; ++i) {
            StackTraceElement curr = stack[i];
            if (!Names.isGenerated(curr.getClassName())) continue;
            stack[i] = new StackTraceElement(curr.getClassName().substring(CLASS_PREFIX.length()), curr.getMethodName(), curr.getFileName(), curr.getLineNumber());
        }
        throwable.setStackTrace(stack);
    }
}

