/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.template.soy.jssrc.AutoValue_SoyJsSrcOptions;

@AutoValue
public abstract class SoyJsSrcOptions {
    abstract JsDepsStrategy depsStrategy();

    public abstract boolean shouldGenerateGoogMsgDefs();

    public abstract boolean dependOnCssHeader();

    public abstract boolean googMsgsAreExternal();

    abstract int bidiGlobalDir();

    public int getBidiGlobalDir() {
        return this.bidiGlobalDir();
    }

    public abstract boolean useGoogIsRtlForBidiGlobalDir();

    public boolean getUseGoogIsRtlForBidiGlobalDir() {
        return this.useGoogIsRtlForBidiGlobalDir();
    }

    public boolean shouldProvideRequireSoyNamespaces() {
        return this.depsStrategy() == JsDepsStrategy.NAMESPACES;
    }

    public boolean shouldGenerateGoogModules() {
        return this.depsStrategy() == JsDepsStrategy.MODULE;
    }

    public static Builder builder() {
        return new AutoValue_SoyJsSrcOptions.Builder().setDepsStrategy(JsDepsStrategy.NAMESPACES).setDependOnCssHeader(false).setShouldGenerateGoogMsgDefs(false).setGoogMsgsAreExternal(false).setBidiGlobalDir(0).setUseGoogIsRtlForBidiGlobalDir(false);
    }

    public abstract Builder toBuilder();

    public static SoyJsSrcOptions getDefault() {
        return SoyJsSrcOptions.builder().build();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        abstract Builder setDepsStrategy(JsDepsStrategy var1);

        @CanIgnoreReturnValue
        public Builder setShouldProvideRequireSoyNamespaces(boolean shouldProvideRequireSoyNamespaces) {
            if (shouldProvideRequireSoyNamespaces) {
                this.setDepsStrategy(JsDepsStrategy.NAMESPACES);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setShouldGenerateGoogModules(boolean shouldGenerateGoogModules) {
            if (shouldGenerateGoogModules) {
                this.setDepsStrategy(JsDepsStrategy.MODULE);
            }
            return this;
        }

        public abstract Builder setShouldGenerateGoogMsgDefs(boolean var1);

        public abstract Builder setDependOnCssHeader(boolean var1);

        public abstract Builder setGoogMsgsAreExternal(boolean var1);

        public abstract Builder setBidiGlobalDir(int var1);

        public abstract Builder setUseGoogIsRtlForBidiGlobalDir(boolean var1);

        abstract SoyJsSrcOptions autoBuild();

        public SoyJsSrcOptions build() {
            SoyJsSrcOptions options = this.autoBuild();
            int bidiGlobalDir = options.getBidiGlobalDir();
            boolean useGoogIsRtlForBidiGlobalDir = options.getUseGoogIsRtlForBidiGlobalDir();
            Preconditions.checkArgument((bidiGlobalDir >= -1 && bidiGlobalDir <= 1 ? 1 : 0) != 0, (Object)"bidiGlobalDir must be 1 for LTR, or -1 for RTL (or 0 to leave unspecified).");
            Preconditions.checkState((!useGoogIsRtlForBidiGlobalDir || bidiGlobalDir == 0 ? 1 : 0) != 0, (Object)"Must not specify both bidiGlobalDir and useGoogIsRtlForBidiGlobalDir.");
            Preconditions.checkState((!useGoogIsRtlForBidiGlobalDir || options.shouldGenerateGoogMsgDefs() ? 1 : 0) != 0, (Object)"Do not specify useGoogIsRtlForBidiGlobalDir without shouldGenerateGoogMsgDefs.");
            Preconditions.checkState((!useGoogIsRtlForBidiGlobalDir || bidiGlobalDir == 0 ? 1 : 0) != 0, (Object)"Must not specify both bidiGlobalDir and useGoogIsRtlForBidiGlobalDir.");
            return options;
        }
    }

    static enum JsDepsStrategy {
        NAMESPACES,
        MODULE;

    }
}

