/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.jssrc.dsl.AutoValue_ClassExpression;
import com.google.template.soy.jssrc.dsl.AutoValue_ClassExpression_MethodDeclaration;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.dsl.FunctionDeclaration;
import com.google.template.soy.jssrc.dsl.JsDoc;
import com.google.template.soy.jssrc.dsl.Statement;
import java.util.stream.Stream;
import javax.annotation.Nullable;

@AutoValue
public abstract class ClassExpression
extends Expression
implements Expression.InitialStatementsScope {
    @Nullable
    abstract Expression baseClass();

    abstract ImmutableList<MethodDeclaration> methods();

    public static ClassExpression create(Expression baseClass, ImmutableList<MethodDeclaration> methods) {
        return new AutoValue_ClassExpression(baseClass, methods);
    }

    public static ClassExpression create(ImmutableList<MethodDeclaration> methods) {
        return new AutoValue_ClassExpression(null, methods);
    }

    @Override
    Stream<? extends CodeChunk> childrenStream() {
        Stream<Expression> children = this.methods().stream();
        if (this.baseClass() != null) {
            children = Stream.concat(Stream.of(this.baseClass()), children);
        }
        return children;
    }

    @Override
    void doFormatOutputExpr(FormattingContext ctx) {
        ctx.append("class");
        if (this.baseClass() != null) {
            ctx.append(" extends ");
            ctx.appendOutputExpression(this.baseClass());
        }
        ctx.append(" ");
        try (FormattingContext ignored = ctx.enterBlock();){
            for (int i = 0; i < this.methods().size(); ++i) {
                if (i > 0) {
                    ctx.appendBlankLine();
                }
                ctx.appendOutputExpression((Expression)this.methods().get(i));
            }
        }
    }

    @AutoValue
    public static abstract class MethodDeclaration
    extends Expression
    implements Expression.InitialStatementsScope {
        abstract String name();

        abstract JsDoc jsDoc();

        abstract Statement body();

        public static MethodDeclaration create(String name, JsDoc jsDoc, Statement body) {
            return new AutoValue_ClassExpression_MethodDeclaration(name, jsDoc, body);
        }

        @Override
        Stream<? extends CodeChunk> childrenStream() {
            return Stream.of(this.jsDoc(), this.body());
        }

        @Override
        void doFormatOutputExpr(FormattingContext ctx) {
            ctx.appendAll(this.jsDoc());
            ctx.endLine();
            ctx.append(this.name() + "(");
            ctx.append(FunctionDeclaration.generateParamList(this.jsDoc(), false));
            ctx.append(") ");
            try (FormattingContext ignored = ctx.enterBlock();){
                ctx.appendAll(this.body());
            }
        }
    }
}

