/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.jssrc.dsl.AutoValue_Dot;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.dsl.OperandPosition;
import com.google.template.soy.jssrc.dsl.Operation;
import com.google.template.soy.jssrc.dsl.Precedence;
import java.util.stream.Stream;

@Immutable
@AutoValue
abstract class Dot
extends Operation {
    Dot() {
    }

    abstract Expression receiver();

    abstract Expression key();

    abstract boolean nullSafe();

    static Dot create(Expression receiver, Expression key) {
        return new AutoValue_Dot(receiver, key, false);
    }

    static Dot createNullSafe(Expression receiver, Expression key) {
        return new AutoValue_Dot(receiver, key, true);
    }

    @Override
    public Precedence precedence() {
        return Precedence.P17;
    }

    @Override
    public Precedence.Associativity associativity() {
        return Precedence.Associativity.LEFT;
    }

    @Override
    Stream<? extends CodeChunk> childrenStream() {
        return Stream.of(this.receiver(), this.key());
    }

    @Override
    void doFormatOutputExpr(FormattingContext ctx) {
        this.formatOperand(this.receiver(), OperandPosition.LEFT, ctx);
        ctx.noBreak().append(this.nullSafe() ? "?." : ".");
        this.formatOperand(this.key(), OperandPosition.RIGHT, ctx);
    }

    @Override
    boolean initialExpressionIsObjectLiteral() {
        return this.receiver().initialExpressionIsObjectLiteral();
    }
}

