/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import com.google.template.soy.base.internal.QuoteStyle;
import com.google.template.soy.exprtree.IntegerNode;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.jssrc.dsl.ArrayLiteral;
import com.google.template.soy.jssrc.dsl.ArrayType;
import com.google.template.soy.jssrc.dsl.AutoValue_Expressions_DecoratedExpression;
import com.google.template.soy.jssrc.dsl.BinaryOperation;
import com.google.template.soy.jssrc.dsl.Call;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.CodeChunks;
import com.google.template.soy.jssrc.dsl.Concatenation;
import com.google.template.soy.jssrc.dsl.ConditionalExpressionBuilder;
import com.google.template.soy.jssrc.dsl.DelegatingExpression;
import com.google.template.soy.jssrc.dsl.Dot;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.FormatOptions;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.dsl.FunctionDeclaration;
import com.google.template.soy.jssrc.dsl.FunctionType;
import com.google.template.soy.jssrc.dsl.GenericType;
import com.google.template.soy.jssrc.dsl.GoogRequire;
import com.google.template.soy.jssrc.dsl.Group;
import com.google.template.soy.jssrc.dsl.JsArrowFunction;
import com.google.template.soy.jssrc.dsl.JsDoc;
import com.google.template.soy.jssrc.dsl.Leaf;
import com.google.template.soy.jssrc.dsl.New;
import com.google.template.soy.jssrc.dsl.ObjectLiteral;
import com.google.template.soy.jssrc.dsl.ParamDecl;
import com.google.template.soy.jssrc.dsl.ParamDecls;
import com.google.template.soy.jssrc.dsl.Precedence;
import com.google.template.soy.jssrc.dsl.RecordType;
import com.google.template.soy.jssrc.dsl.Return;
import com.google.template.soy.jssrc.dsl.SpecialToken;
import com.google.template.soy.jssrc.dsl.Statement;
import com.google.template.soy.jssrc.dsl.Statements;
import com.google.template.soy.jssrc.dsl.StringLiteral;
import com.google.template.soy.jssrc.dsl.Ternary;
import com.google.template.soy.jssrc.dsl.TsFunction;
import com.google.template.soy.jssrc.dsl.UnaryOperation;
import com.google.template.soy.jssrc.dsl.UnionType;
import com.google.template.soy.jssrc.restricted.JsExpr;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public final class Expressions {
    public static final Expression LITERAL_ANY = Expressions.id("any");
    public static final Expression LITERAL_TRUE = Expressions.id("true");
    public static final Expression LITERAL_FALSE = Expressions.id("false");
    public static final Expression LITERAL_NULL = Expressions.id("null");
    public static final Expression LITERAL_UNDEFINED = Expressions.id("undefined");
    public static final Expression LITERAL_EMPTY_STRING = Expressions.stringLiteral("");
    public static final Expression LITERAL_EMPTY_LIST = Expressions.arrayLiteral((Iterable<? extends Expression>)ImmutableList.of());
    public static final Expression EMPTY_OBJECT_LITERAL = Expressions.objectLiteral((Map<String, Expression>)ImmutableMap.of());
    public static final Expression THIS = Expressions.id("this");
    public static final Expression EMPTY = new Expression(){

        @Override
        void doFormatOutputExpr(FormattingContext ctx) {
        }

        @Override
        Stream<? extends CodeChunk> childrenStream() {
            return Stream.empty();
        }
    };
    public static final Expression ERROR_EXPR = new Expression(){

        @Override
        void doFormatOutputExpr(FormattingContext ctx) {
            throw new IllegalStateException("ERROR_EXPR should never be used to write gencode! This soy file had a problem, and the resulting js/ts will be invalid.");
        }

        @Override
        Stream<? extends CodeChunk> childrenStream() {
            return Stream.empty();
        }

        @Override
        public JsExpr singleExprOrName(FormatOptions formatOptions) {
            return new JsExpr("$$SOY_INTERNAL_ERROR_EXPR", Integer.MAX_VALUE);
        }
    };

    public static boolean isStringLiteral(Expression expr) {
        return expr instanceof StringLiteral;
    }

    private Expressions() {
    }

    static boolean isSpread(Expression expr) {
        return expr instanceof UnaryOperation && ((UnaryOperation)expr).operator().equals("...");
    }

    public static Expression spread(Expression expr) {
        return UnaryOperation.create("...", Precedence.P2, expr, true);
    }

    public static ConditionalExpressionBuilder ifExpression(Expression predicate, Expression consequent) {
        return new ConditionalExpressionBuilder(predicate, consequent);
    }

    public static Expression fromExpr(JsExpr expr, Iterable<GoogRequire> requires) {
        return Leaf.create(expr, false, requires);
    }

    public static Expression tsFunction(ParamDecls params, Expression returnType, List<Statement> bodyStmts) {
        return TsFunction.anonymous(params, returnType, bodyStmts);
    }

    public static Expression tsArrowFunction(List<Statement> bodyStmts) {
        return Expressions.tsArrowFunction(ParamDecls.EMPTY, bodyStmts);
    }

    public static Expression tsArrowFunction(ParamDecls params, List<Statement> bodyStmts) {
        return TsFunction.arrow(params, bodyStmts);
    }

    public static Expression tsArrowFunction(ParamDecls params, Expression returnType, List<Statement> bodyStmts) {
        return TsFunction.arrow(params, returnType, bodyStmts);
    }

    public static Expression tsArrowFunction(Expression lambda) {
        return Expressions.tsArrowFunction(ParamDecls.EMPTY, (List<Statement>)ImmutableList.of((Object)Return.create(lambda)));
    }

    public static Expression tsArrowFunction(ParamDecls params, Expression lambda) {
        return Expressions.tsArrowFunction(params, (List<Statement>)ImmutableList.of((Object)Return.create(lambda)));
    }

    public static Expression genericType(Expression className, ImmutableList<Expression> generics) {
        return GenericType.create(className, generics);
    }

    public static Expression genericType(Expression className, Expression ... generics) {
        return GenericType.create(className, (List<Expression>)ImmutableList.copyOf((Object[])generics));
    }

    public static Expression functionType(Expression returnType, List<ParamDecl> params) {
        return FunctionType.create(returnType, params);
    }

    public static Expression functionType(Expression returnType, ParamDecls params) {
        return FunctionType.create(returnType, params);
    }

    public static Expression arrayType(Expression simpleType, boolean readonly) {
        return ArrayType.create(readonly, simpleType);
    }

    public static Expression unionType(List<Expression> members) {
        return UnionType.create(members);
    }

    public static Expression recordType(List<ParamDecl> params) {
        return RecordType.create(params);
    }

    public static Expression id(String id) {
        CodeChunks.checkId(id);
        return Leaf.create(id, true);
    }

    public static Expression id(String id, Iterable<GoogRequire> requires) {
        CodeChunks.checkId(id);
        return Leaf.create(id, true, requires);
    }

    public static Expression id(String id, GoogRequire ... requires) {
        CodeChunks.checkId(id);
        return Leaf.create(id, true, (Iterable<GoogRequire>)ImmutableList.copyOf((Object[])requires));
    }

    public static Expression importedId(String id, String path) {
        return Expressions.id(id, GoogRequire.createImport(id, path));
    }

    public static Expression importedId(String id, String alias, String path) {
        return Expressions.id(alias, GoogRequire.createImport(id, alias, path));
    }

    public static Expression dottedIdNoRequire(String dotSeparatedIdentifiers) {
        return Expressions.dottedIdWithRequires(dotSeparatedIdentifiers, (Iterable<GoogRequire>)ImmutableSet.of());
    }

    public static Expression dottedIdWithRequires(String dotSeparatedIdentifiers, Iterable<GoogRequire> requires) {
        List ids = Splitter.on((char)'.').splitToList((CharSequence)dotSeparatedIdentifiers);
        Preconditions.checkState((!ids.isEmpty() ? 1 : 0) != 0, (String)"not a dot-separated sequence of JavaScript identifiers: %s", (Object)dotSeparatedIdentifiers);
        Expression tip = Expressions.id((String)ids.get(0), requires);
        for (int i = 1; i < ids.size(); ++i) {
            tip = tip.dotAccess((String)ids.get(i));
        }
        return tip;
    }

    public static Expression stringLiteral(String contents) {
        return StringLiteral.create(contents);
    }

    public static Expression stringLiteral(String contents, QuoteStyle quoteStyle) {
        return StringLiteral.create(contents, quoteStyle);
    }

    public static Expression regexLiteral(String contents) {
        int lastSlash;
        int firstSlash = contents.indexOf(47);
        Preconditions.checkArgument((firstSlash < (lastSlash = contents.lastIndexOf(47)) && firstSlash != -1 ? 1 : 0) != 0, (String)"expected regex to start with a '/' and have a second '/' near the end, got %s", (Object)contents);
        return Leaf.createNonNull(contents, false);
    }

    public static Expression number(long value) {
        Preconditions.checkArgument((boolean)IntegerNode.isInRange(value), (String)"Number is outside JS safe integer range: %s", (long)value);
        return Leaf.createNonNull(Long.toString(value), true);
    }

    public static Expression number(double value) {
        return Leaf.createNonNull(Double.toString(value), true);
    }

    public static Expression function(JsDoc parameters, Statement body) {
        return FunctionDeclaration.create(parameters, body);
    }

    public static Expression arrowFunction(JsDoc parameters, Statement body) {
        return JsArrowFunction.create(parameters, body);
    }

    public static Expression arrowFunction(JsDoc parameters, Expression body) {
        return Expressions.arrowFunction(parameters, Statements.returnValue(body));
    }

    public static Expression not(Expression arg) {
        return UnaryOperation.create(Operator.NOT, arg);
    }

    public static Expression assertNonNull(Expression arg) {
        return UnaryOperation.create(Operator.ASSERT_NON_NULL, arg);
    }

    public static Expression construct(Expression ctor, Expression ... args) {
        return New.create(ctor).call(args);
    }

    public static Expression constructMap(Expression ... initializers) {
        return New.create(Expressions.id("Map", GoogRequire.create("soy.map"))).call(initializers);
    }

    public static Expression operation(Operator op, Expression ... operands) {
        return Expressions.operation(op, (List<Expression>)ImmutableList.copyOf((Object[])operands));
    }

    public static Expression operation(Operator op, List<Expression> operands) {
        Preconditions.checkArgument((operands.size() == op.getNumOperands() ? 1 : 0) != 0);
        Preconditions.checkArgument((op != Operator.AND && op != Operator.OR && op != Operator.CONDITIONAL ? 1 : 0) != 0);
        switch (op.getNumOperands()) {
            case 1: {
                return UnaryOperation.create(op, operands.get(0));
            }
            case 2: {
                return BinaryOperation.create(op, operands.get(0), operands.get(1));
            }
        }
        throw new AssertionError();
    }

    public static Expression arrayLiteral(Iterable<? extends Expression> elements) {
        return ArrayLiteral.create((ImmutableList<? extends Expression>)ImmutableList.copyOf(elements));
    }

    public static Expression arrayLiteral(Expression ... elements) {
        return ArrayLiteral.create((ImmutableList<? extends Expression>)ImmutableList.copyOf((Object[])elements));
    }

    public static Expression objectLiteral(Map<String, Expression> object) {
        return ObjectLiteral.create(object);
    }

    public static String objectLiteralSpreadKey() {
        return ObjectLiteral.newSpread();
    }

    public static Expression objectLiteralWithQuotedKeys(Map<String, Expression> object) {
        return ObjectLiteral.createWithQuotedKeys(object);
    }

    public static Expression ternary(Expression predicate, Expression consequent, Expression alternate) {
        return Ternary.create(predicate, consequent, alternate);
    }

    public static Expression dontTrustPrecedenceOf(JsExpr couldHaveWrongPrecedence, Iterable<GoogRequire> requires) {
        return Group.create(Expressions.fromExpr(couldHaveWrongPrecedence, requires));
    }

    public static Expression group(Expression e) {
        return Group.create(e);
    }

    public static Expression concat(List<? extends Expression> chunks) {
        return Concatenation.create(chunks);
    }

    public static Expression concat(Expression ... chunks) {
        return Concatenation.create((Iterable<? extends Expression>)ImmutableList.copyOf((Object[])chunks));
    }

    public static Expression concatForceString(List<? extends Expression> chunks) {
        if (!chunks.isEmpty() && chunks.get(0).isRepresentableAsSingleExpression() && Expressions.isStringLiteral(chunks.get(0))) {
            return Expressions.concat(chunks);
        }
        if (chunks.size() > 1 && chunks.get(1).isRepresentableAsSingleExpression() && Expressions.isStringLiteral(chunks.get(1))) {
            return Expressions.concat(chunks);
        }
        return Expressions.concat((List<? extends Expression>)ImmutableList.builder().add((Object)LITERAL_EMPTY_STRING).addAll(chunks).build());
    }

    @Nullable
    static String getLeafText(Expression expr) {
        return expr instanceof Leaf ? ((Leaf)expr).value().getText() : null;
    }

    @Nullable
    public static Expression baseForMethodCall(Expression expr, String name) {
        Expression dotKeyExpression;
        Expression receiver;
        if (expr instanceof Call && (receiver = ((Call)expr).receiver()) instanceof Dot && (dotKeyExpression = ((Dot)receiver).key()) instanceof Leaf && ((Leaf)dotKeyExpression).value().getText().equals(name)) {
            return ((Dot)receiver).receiver();
        }
        return null;
    }

    public static NullSafeAccumulatorReceiver nullSafeAccumulatorReceiver(Expression delegate, boolean nullSafe) {
        return new NullSafeAccumulatorReceiver(delegate, nullSafe);
    }

    public static class NullSafeAccumulatorReceiver
    extends DelegatingExpression {
        private final boolean nullSafe;
        private boolean dereferenced = false;

        public NullSafeAccumulatorReceiver(Expression delegate, boolean nullSafe) {
            super(delegate);
            this.nullSafe = nullSafe;
        }

        @Override
        public Expression dotAccess(String identifier, boolean nullSafe) {
            this.dereferenced = true;
            return this.delegate.dotAccess(identifier, this.nullSafe || nullSafe);
        }

        @Override
        public Expression bracketAccess(Expression arg, boolean nullSafe) {
            this.dereferenced = true;
            return this.delegate.bracketAccess(arg, this.nullSafe || nullSafe);
        }

        @Override
        void doFormatOutputExpr(FormattingContext ctx) {
            this.delegate.doFormatOutputExpr(ctx);
        }

        public boolean wasDereferenced() {
            return this.dereferenced;
        }
    }

    @AutoValue
    static abstract class DecoratedExpression
    extends Expression {
        DecoratedExpression() {
        }

        public static Expression create(Expression expr, List<SpecialToken> before, List<SpecialToken> after) {
            if (before.isEmpty() && after.isEmpty()) {
                return expr;
            }
            return new AutoValue_Expressions_DecoratedExpression((ImmutableList<SpecialToken>)ImmutableList.copyOf(before), expr, (ImmutableList<SpecialToken>)ImmutableList.copyOf(after));
        }

        abstract ImmutableList<SpecialToken> beforeTokens();

        abstract Expression expr();

        abstract ImmutableList<SpecialToken> afterTokens();

        @Override
        void doFormatOutputExpr(FormattingContext ctx) {
            for (CodeChunk chunk : this.beforeTokens()) {
                ctx.appendAll(chunk);
            }
            ctx.appendOutputExpression(this.expr());
            for (CodeChunk chunk : this.afterTokens()) {
                ctx.appendAll(chunk);
            }
        }

        @Override
        Stream<? extends CodeChunk> childrenStream() {
            return Streams.concat((Stream[])new Stream[]{this.beforeTokens().stream(), Stream.of(this.expr()), this.afterTokens().stream()});
        }

        @Override
        public Expression append(List<SpecialToken> tokens) {
            if (tokens.isEmpty()) {
                return this;
            }
            return DecoratedExpression.create(this.expr(), this.beforeTokens(), (List<SpecialToken>)ImmutableList.builder().addAll(tokens).addAll(this.afterTokens()).build());
        }

        @Override
        public Expression prepend(List<SpecialToken> tokens) {
            if (tokens.isEmpty()) {
                return this;
            }
            return DecoratedExpression.create(this.expr(), (List<SpecialToken>)ImmutableList.builder().addAll(tokens).addAll(this.beforeTokens()).build(), this.afterTokens());
        }
    }
}

