/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.jssrc.dsl.AutoValue_File;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.dsl.Statement;
import com.google.template.soy.jssrc.dsl.StatementList;
import java.util.List;
import java.util.stream.Stream;

@Immutable
@AutoValue
public abstract class File
extends Statement {
    abstract String fileOverviewComments();

    abstract CodeChunk imports();

    abstract ImmutableList<Statement> children();

    public static File create(String fileOverviewComments, CodeChunk imports, List<Statement> children) {
        return new AutoValue_File(fileOverviewComments, imports, (ImmutableList<Statement>)ImmutableList.copyOf(children));
    }

    @Override
    Stream<? extends CodeChunk> childrenStream() {
        return this.children().stream();
    }

    @Override
    void doFormatStatement(FormattingContext ctx) {
        ctx.append(this.fileOverviewComments());
        if (!(this.imports() instanceof StatementList) || !((StatementList)this.imports()).isEmpty()) {
            ctx.appendBlankLine();
        }
        ctx.appendAll(this.imports());
        for (int i = 0; i < this.children().size(); ++i) {
            Statement child = (Statement)this.children().get(i);
            ctx.appendBlankLine();
            if (i > 0) {
                ctx.appendBlankLine();
            }
            ctx.appendAll(child);
        }
        ctx.endLine().append("");
    }
}

