/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.jssrc.dsl.AbstractType;
import com.google.template.soy.jssrc.dsl.AutoValue_GenericType;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import java.util.List;
import java.util.stream.Stream;

@AutoValue
public abstract class GenericType
extends AbstractType {
    public static GenericType create(Expression className, List<Expression> generics) {
        return new AutoValue_GenericType(className, (ImmutableList<Expression>)ImmutableList.copyOf(generics));
    }

    abstract Expression className();

    abstract ImmutableList<Expression> generics();

    @Override
    void doFormatOutputExpr(FormattingContext ctx) {
        ctx.appendOutputExpression(this.className());
        ctx.noBreak().append("<");
        boolean first = true;
        for (int i = 0; i < this.generics().size(); ++i) {
            first = ctx.commaAfterFirst(first);
            ctx.appendOutputExpression((Expression)this.generics().get(i));
        }
        ctx.append(">");
    }

    @Override
    Stream<? extends CodeChunk> childrenStream() {
        return Stream.concat(Stream.of(this.className()), this.generics().stream());
    }
}

