/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.jssrc.dsl.AutoValue_HtmlAttribute;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.Expressions;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.dsl.StringLiteral;
import com.google.template.soy.jssrc.dsl.TsxPrintNode;
import java.util.stream.Stream;
import javax.annotation.Nullable;

@Immutable
@AutoValue
public abstract class HtmlAttribute
extends Expression {
    abstract String name();

    @Nullable
    abstract Expression value();

    public static HtmlAttribute create(String name, @Nullable Expression value) {
        if (value != null && !(value instanceof StringLiteral)) {
            value = TsxPrintNode.wrap(value);
        }
        return new AutoValue_HtmlAttribute(name, value);
    }

    public static HtmlAttribute create(String name, @Nullable String value) {
        return HtmlAttribute.create(name, value != null ? Expressions.stringLiteral(value) : null);
    }

    @Override
    void doFormatOutputExpr(FormattingContext ctx) {
        ctx.append(this.name());
        if (this.value() != null) {
            ctx.append("=");
            ctx.pushLexicalState(FormattingContext.LexicalState.TSX_ATTR);
            ctx.appendOutputExpression(this.value());
            ctx.popLexicalState();
        }
    }

    @Override
    Stream<? extends CodeChunk> childrenStream() {
        return this.value() != null ? Stream.of(this.value()) : Stream.empty();
    }
}

