/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.jssrc.dsl.AutoValue_HtmlTag;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.Concatenation;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.Expressions;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.dsl.GoogRequire;
import com.google.template.soy.jssrc.dsl.HtmlAttribute;
import com.google.template.soy.jssrc.dsl.Statement;
import com.google.template.soy.jssrc.dsl.Statements;
import com.google.template.soy.jssrc.dsl.StringLiteral;
import com.google.template.soy.jssrc.dsl.TsxFragmentElement;
import com.google.template.soy.jssrc.dsl.TsxPrintNode;
import java.util.List;
import java.util.stream.Stream;

@Immutable
@AutoValue
public abstract class HtmlTag
extends Expression
implements CodeChunk.HasRequires {
    public static final HtmlTag FRAGMENT_OPEN = HtmlTag.createOpen("", new CodeChunk[0]);
    public static final HtmlTag FRAGMENT_CLOSE = HtmlTag.createClose("", new CodeChunk[0]);

    public static HtmlTag createOpen(String tagName, List<? extends CodeChunk> attributes) {
        return HtmlTag.create(Expressions.stringLiteral(tagName), Type.OPEN, attributes.stream());
    }

    public static HtmlTag createOpen(String tagName, CodeChunk ... attributes) {
        return HtmlTag.create(Expressions.stringLiteral(tagName), Type.OPEN, Stream.of(attributes));
    }

    public static HtmlTag createClose(String tagName, CodeChunk ... attributes) {
        return HtmlTag.create(Expressions.stringLiteral(tagName), Type.CLOSE, Stream.of(attributes));
    }

    public static HtmlTag create(String tagName, Type type, Iterable<? extends CodeChunk> attributes) {
        return HtmlTag.create(Expressions.stringLiteral(tagName), type, Streams.stream(attributes));
    }

    public static HtmlTag create(Expression tagName, Type type, Iterable<? extends CodeChunk> attributes) {
        return HtmlTag.create(tagName, type, Streams.stream(attributes));
    }

    public HtmlTag withExtraAttributes(Iterable<? extends CodeChunk> attributes) {
        return HtmlTag.create(this.tagName(), this.type(), Streams.concat((Stream[])new Stream[]{this.attributes().stream(), Streams.stream(attributes)}));
    }

    private static HtmlTag create(Expression tagName, Type type, Stream<? extends CodeChunk> attributes) {
        return new AutoValue_HtmlTag(tagName, type, (ImmutableList<? extends CodeChunk>)((ImmutableList)TsxFragmentElement.mergeLineComments(attributes).flatMap(HtmlTag::wrapChild).collect(ImmutableList.toImmutableList())));
    }

    private static Stream<CodeChunk> wrapChild(CodeChunk chunk) {
        if (chunk instanceof HtmlAttribute || chunk instanceof TsxPrintNode.CommandChar) {
            return Stream.of(chunk);
        }
        if (chunk == Expressions.EMPTY) {
            return Stream.of(new CodeChunk[0]);
        }
        if (chunk instanceof StringLiteral) {
            return Stream.of(TsxPrintNode.wrapIfNeeded((StringLiteral)chunk));
        }
        if (chunk instanceof Concatenation) {
            return Stream.of(((Concatenation)chunk).map1toN(HtmlTag::wrapChild));
        }
        if (chunk instanceof Statements.DecoratedStatement || chunk instanceof Expressions.DecoratedExpression) {
            return TsxFragmentElement.mergeLineComments(chunk.childrenStream()).flatMap(TsxFragmentElement::wrapChild);
        }
        if (chunk instanceof Statement) {
            return Stream.of(TsxPrintNode.wrap(((Statement)chunk).asExpr()));
        }
        return Stream.of(TsxPrintNode.wrap(chunk));
    }

    abstract Expression tagName();

    abstract Type type();

    abstract ImmutableList<? extends CodeChunk> attributes();

    public HtmlTag copyWithTagName(String newTagName) {
        return HtmlTag.create(newTagName, this.type(), this.attributes());
    }

    boolean isOpen() {
        return this.type() == Type.OPEN;
    }

    boolean isClose() {
        return this.type() == Type.CLOSE;
    }

    @Override
    void doFormatOutputExpr(FormattingContext ctx) {
        if (this.type() == Type.CLOSE) {
            ctx.decreaseIndentLenient();
        }
        FormattingContext buffer = this.attributes().isEmpty() ? ctx.buffer() : ctx;
        buffer.append(this.type() == Type.CLOSE ? "</" : "<");
        buffer.pushLexicalState(FormattingContext.LexicalState.TSX);
        buffer.appendAll(this.tagName());
        for (CodeChunk attribute : this.attributes()) {
            buffer.append(" ");
            buffer.appendAll(attribute);
        }
        buffer.popLexicalState();
        buffer.append(this.type() == Type.SELF_CLOSE ? "/>" : ">");
        if (buffer != ctx) {
            buffer.close();
        }
        if (this.type() == Type.OPEN) {
            ctx.increaseIndent();
        }
    }

    @Override
    Stream<? extends CodeChunk> childrenStream() {
        return Streams.concat((Stream[])new Stream[]{Stream.of(this.tagName()), this.attributes().stream()});
    }

    @Override
    public ImmutableSet<GoogRequire> googRequires() {
        return ImmutableSet.of((Object)TsxFragmentElement.ELEMENT);
    }

    public static enum Type {
        OPEN,
        CLOSE,
        SELF_CLOSE;

    }
}

