/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.jssrc.dsl.AutoValue_NamedFunctionDeclaration;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.dsl.JsDoc;
import com.google.template.soy.jssrc.dsl.ParamDecls;
import com.google.template.soy.jssrc.dsl.Statement;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;

@AutoValue
public abstract class NamedFunctionDeclaration
extends Statement {
    abstract String name();

    abstract ParamDecls params();

    abstract Expression returnType();

    abstract Optional<JsDoc> jsDoc();

    @Nullable
    abstract ImmutableList<Statement> bodyStmts();

    abstract boolean isExported();

    abstract boolean isDeclaration();

    @Nullable
    abstract SourceLocation.ByteSpan soySpan();

    public static Builder builder(String name, ParamDecls params, Expression returnType) {
        return new AutoValue_NamedFunctionDeclaration.Builder().setName(name).setParams(params).setReturnType(returnType).setJsDoc(Optional.empty()).setBodyStmts(null).setIsExported(false).setIsDeclaration(false).setSoySpan(null);
    }

    public static Builder builder(String name, ParamDecls params, Expression returnType, JsDoc jsDoc) {
        return new AutoValue_NamedFunctionDeclaration.Builder().setName(name).setParams(params).setReturnType(returnType).setJsDoc(Optional.ofNullable(jsDoc)).setBodyStmts(null).setIsExported(false).setIsDeclaration(false).setSoySpan(null);
    }

    @Override
    void doFormatStatement(FormattingContext ctx) {
        if (this.jsDoc().isPresent()) {
            ctx.appendAll(this.jsDoc().get());
        }
        ctx.endLine();
        if (this.isExported()) {
            ctx.append("export ");
        }
        if (this.isDeclaration()) {
            ctx.append("declare ");
        }
        ctx.append("function ");
        ctx.appendImputee(this.name(), this.soySpan());
        ctx.append("(");
        ctx.appendOutputExpression(this.params());
        ctx.append("): ").appendOutputExpression(this.returnType());
        if (this.bodyStmts() != null) {
            ctx.append(" ");
            ctx.enterBlock();
            for (Statement stmt : this.bodyStmts()) {
                ctx.appendAll(stmt);
                ctx.endLine();
            }
            ctx.close();
        } else {
            ctx.noBreak().append(";");
        }
        ctx.endLine();
    }

    @Override
    Stream<? extends CodeChunk> childrenStream() {
        return Streams.concat((Stream[])new Stream[]{this.bodyStmts() != null ? this.bodyStmts().stream() : Stream.of(new CodeChunk[0]), Stream.of(this.params(), this.returnType(), this.jsDoc().orElse(null)).filter(Objects::nonNull)});
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setName(String var1);

        public abstract Builder setParams(ParamDecls var1);

        public abstract Builder setReturnType(Expression var1);

        public abstract Builder setJsDoc(Optional<JsDoc> var1);

        public abstract Builder setBodyStmts(ImmutableList<Statement> var1);

        public abstract Builder setIsExported(boolean var1);

        public abstract Builder setIsDeclaration(boolean var1);

        public abstract Builder setSoySpan(SourceLocation.ByteSpan var1);

        public abstract NamedFunctionDeclaration build();
    }
}

