/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.FormatOptions;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.dsl.Leaf;
import com.google.template.soy.jssrc.dsl.OperandPosition;
import com.google.template.soy.jssrc.dsl.OperatorInterface;
import com.google.template.soy.jssrc.dsl.Precedence;
import com.google.template.soy.jssrc.dsl.TsxPrintNode;
import com.google.template.soy.jssrc.restricted.JsExpr;

abstract class Operation
extends Expression
implements OperatorInterface {
    Operation() {
    }

    public static String getOperatorToken(Operator soyOperator) {
        switch (soyOperator) {
            case AND: 
            case AMP_AMP: {
                return "&&";
            }
            case BAR_BAR: 
            case OR: {
                return "||";
            }
            case NULL_COALESCING: {
                return "??";
            }
            case ASSERT_NON_NULL: 
            case BITWISE_AND: 
            case BITWISE_OR: 
            case BITWISE_XOR: 
            case DIVIDE_BY: 
            case EQUAL: 
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: 
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: 
            case MINUS: 
            case MOD: 
            case NEGATIVE: 
            case NOT: 
            case NOT_EQUAL: 
            case PLUS: 
            case SHIFT_LEFT: 
            case SHIFT_RIGHT: 
            case TIMES: 
            case TRIPLE_EQUAL: 
            case TRIPLE_NOT_EQUAL: {
                return soyOperator.getTokenString();
            }
            case CONDITIONAL: {
                throw new IllegalArgumentException("Not a single token.");
            }
        }
        throw new AssertionError();
    }

    @Override
    public abstract Precedence precedence();

    @Override
    public abstract Precedence.Associativity associativity();

    @Override
    public final JsExpr singleExprOrName(FormatOptions formatOptions) {
        FormattingContext ctx = new FormattingContext(formatOptions);
        ctx.appendOutputExpression(this);
        return new JsExpr(ctx.toString(), this.precedence().toInt());
    }

    final void formatOperand(Expression operand, OperandPosition operandPosition, FormattingContext ctx) {
        boolean protect = this.shouldProtect(operand, operandPosition);
        if (protect) {
            ctx.enterGroup();
        }
        ctx.appendOutputExpression(operand);
        if (protect) {
            ctx.exitGroup();
        }
    }

    protected boolean shouldProtect(Expression operand, OperandPosition operandPosition) {
        CodeChunk cc = operand;
        if (cc instanceof TsxPrintNode) {
            cc = ((TsxPrintNode)operand).expr();
        }
        if (cc instanceof OperatorInterface) {
            OperatorInterface operation = (OperatorInterface)((Object)cc);
            return operation.precedence().lessThan(this.precedence()) || operation.precedence() == this.precedence() && operandPosition.shouldParenthesize(operation.associativity());
        }
        if (cc instanceof Leaf) {
            JsExpr expr = ((Leaf)cc).value();
            return expr.getPrecedence() < this.precedence().toInt();
        }
        return false;
    }
}

