/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.jssrc.dsl.AutoValue_ParamDecl;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;

@Immutable
@AutoValue
public abstract class ParamDecl
extends Expression {
    public abstract String name();

    @Nullable
    public abstract String alias();

    @Nullable
    abstract Expression type();

    abstract boolean optional();

    @Nullable
    abstract Expression defaultValue();

    public static ParamDecl create(String name) {
        return ParamDecl.builder(name).build();
    }

    public static ParamDecl create(String name, Expression type) {
        return ParamDecl.builder(name).setType(type).build();
    }

    @Override
    Stream<? extends CodeChunk> childrenStream() {
        return Stream.of(this.type(), this.defaultValue()).filter(Objects::nonNull);
    }

    @Override
    void doFormatOutputExpr(FormattingContext ctx) {
        ctx.append(this.name());
        if (this.optional()) {
            ctx.noBreak().append("?");
        }
        if (this.type() != null) {
            ctx.noBreak().append(": ").appendOutputExpression(this.type());
        }
    }

    public static Builder builder(String name) {
        return new AutoValue_ParamDecl.Builder().setName(name).setOptional(false);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setName(String var1);

        public abstract Builder setAlias(String var1);

        public abstract Builder setType(Expression var1);

        public abstract Builder setOptional(boolean var1);

        public abstract Builder setDefaultValue(Expression var1);

        public abstract ParamDecl build();
    }
}

