/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.jssrc.dsl.AutoValue_ParamDecls;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.dsl.ParamDecl;
import com.google.template.soy.jssrc.dsl.TsInterface;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;

@Immutable
@AutoValue
public abstract class ParamDecls
extends Expression {
    public static final ParamDecls EMPTY = ParamDecls.create((List<ParamDecl>)ImmutableList.of());

    abstract ImmutableList<ParamDecl> params();

    abstract boolean namedStyle();

    @Nullable
    abstract TsInterface tsInterface();

    public static ParamDecls createNamed(List<ParamDecl> params) {
        return new AutoValue_ParamDecls((ImmutableList<ParamDecl>)ImmutableList.copyOf(params), true, null);
    }

    public static ParamDecls createFromInterface(TsInterface tsInterface) {
        return new AutoValue_ParamDecls(tsInterface.properties(), true, tsInterface);
    }

    public static ParamDecls create(List<ParamDecl> params) {
        return new AutoValue_ParamDecls((ImmutableList<ParamDecl>)ImmutableList.copyOf(params), false, null);
    }

    @Override
    void doFormatOutputExpr(FormattingContext ctx) {
        if (this.namedStyle()) {
            if (this.params().isEmpty()) {
                ctx.append("{}: {}");
                return;
            }
            ctx.append("{");
            boolean first = true;
            for (ParamDecl param : this.params()) {
                first = ctx.commaAfterFirst(first);
                ctx.append(param.name());
                if (param.alias() != null) {
                    ctx.noBreak().append(": " + param.alias());
                }
                if (param.defaultValue() == null) continue;
                ctx.noBreak().append(" = ").appendOutputExpression(param.defaultValue());
            }
            ctx.append("}: ");
            if (this.tsInterface() != null) {
                ctx.append(this.tsInterface().name());
            } else {
                ctx.append("{");
                first = true;
                for (ParamDecl param : this.params()) {
                    first = ctx.commaAfterFirst(first);
                    ctx.appendOutputExpression(param);
                }
                ctx.append("}");
            }
        } else {
            boolean first = true;
            for (ParamDecl param : this.params()) {
                first = ctx.commaAfterFirst(first);
                ctx.appendOutputExpression(param);
            }
        }
    }

    @Override
    Stream<? extends CodeChunk> childrenStream() {
        return this.params().stream();
    }
}

