/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.Expressions;
import com.google.template.soy.jssrc.dsl.FormatOptions;
import com.google.template.soy.jssrc.dsl.GoogRequire;
import com.google.template.soy.jssrc.dsl.Statement;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.SoyJsSrcFunction;
import com.google.template.soy.jssrc.restricted.SoyJsSrcPrintDirective;
import com.google.template.soy.jssrc.restricted.SoyLibraryAssistedJsSrcFunction;
import com.google.template.soy.jssrc.restricted.SoyLibraryAssistedJsSrcPrintDirective;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class SoyJsPluginUtils {
    private static final SoyErrorKind UNEXPECTED_PLUGIN_ERROR = SoyErrorKind.of(SoyJsPluginUtils.formatPlain("{3}"), SoyErrorKind.StyleAllowance.NO_PUNCTUATION);

    private SoyJsPluginUtils() {
    }

    private static String formatPlain(String innerFmt) {
        return "Error in plugin implementation for {0} ''{1}''.\n" + innerFmt + "\nPlugin implementation: {2}";
    }

    public static Expression applyDirective(Expression expr, SoyJsSrcPrintDirective directive, List<Expression> args, SourceLocation location, ErrorReporter errorReporter) {
        JsExpr applied;
        List argExprs = Lists.transform(args, a -> a.singleExprOrName(FormatOptions.JSSRC));
        try {
            applied = directive.applyForJsSrc(expr.singleExprOrName(FormatOptions.JSSRC), argExprs);
        }
        catch (Throwable t) {
            applied = SoyJsPluginUtils.report(location, directive, t, errorReporter);
        }
        ImmutableSet.Builder requiresBuilder = ImmutableSet.builder();
        expr.collectRequires(arg_0 -> ((ImmutableSet.Builder)requiresBuilder).add(arg_0));
        for (Expression arg : args) {
            arg.collectRequires(arg_0 -> ((ImmutableSet.Builder)requiresBuilder).add(arg_0));
        }
        if (directive instanceof SoyLibraryAssistedJsSrcPrintDirective) {
            for (String name : ((SoyLibraryAssistedJsSrcPrintDirective)directive).getRequiredJsLibNames()) {
                requiresBuilder.add((Object)GoogRequire.create(name));
            }
        }
        ImmutableList.Builder initialStatements = ImmutableList.builder().addAll(expr.allInitialStatementsInTopScope());
        for (Expression arg : args) {
            initialStatements.addAll(arg.allInitialStatementsInTopScope());
        }
        return Expressions.fromExpr(applied, (Iterable<GoogRequire>)requiresBuilder.build()).withInitialStatements((Iterable<? extends Statement>)initialStatements.build());
    }

    public static Expression applySoyFunction(SoyJsSrcFunction soyJsSrcFunction, List<Expression> args, SourceLocation location, ErrorReporter errorReporter) {
        JsExpr outputExpr;
        ArrayList<JsExpr> functionInputs = new ArrayList<JsExpr>(args.size());
        ArrayList<Statement> initialStatements = new ArrayList<Statement>();
        ImmutableSet.Builder requiresBuilder = ImmutableSet.builder();
        for (Expression arg : args) {
            arg.collectRequires(arg_0 -> ((ImmutableSet.Builder)requiresBuilder).add(arg_0));
            functionInputs.add(arg.singleExprOrName(FormatOptions.JSSRC));
            initialStatements.addAll((Collection<Statement>)arg.allInitialStatementsInTopScope());
        }
        if (soyJsSrcFunction instanceof SoyLibraryAssistedJsSrcFunction) {
            ImmutableSet<String> requires = ImmutableSet.of();
            try {
                requires = ((SoyLibraryAssistedJsSrcFunction)soyJsSrcFunction).getRequiredJsLibNames();
            }
            catch (Throwable t) {
                SoyJsPluginUtils.report(location, soyJsSrcFunction, t, errorReporter);
            }
            for (String name : requires) {
                requiresBuilder.add((Object)GoogRequire.create(name));
            }
        }
        try {
            outputExpr = soyJsSrcFunction.computeForJsSrc(functionInputs);
        }
        catch (Throwable t) {
            outputExpr = SoyJsPluginUtils.report(location, soyJsSrcFunction, t, errorReporter);
        }
        Expression functionOutput = Expressions.dontTrustPrecedenceOf(outputExpr, (Iterable<GoogRequire>)requiresBuilder.build());
        return functionOutput.withInitialStatements(initialStatements);
    }

    private static JsExpr report(SourceLocation location, Object obj, Throwable t, ErrorReporter errorReporter) {
        BaseUtils.trimStackTraceTo(t, SoyJsPluginUtils.class);
        errorReporter.report(location, UNEXPECTED_PLUGIN_ERROR, obj instanceof SoyJsSrcFunction ? "function" : "directive", obj instanceof SoyJsSrcFunction ? ((SoyJsSrcFunction)obj).getName() : ((SoyJsSrcPrintDirective)obj).getName(), obj.getClass().getName(), Throwables.getStackTraceAsString((Throwable)t));
        return new JsExpr("if you see this, soy swallowed an error", Integer.MAX_VALUE);
    }
}

